/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.util;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.DialogController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXulDialogController<T>
extends AbstractXulEventHandler
implements DialogController<T> {
    private List<DialogController.DialogListener<T>> listeners = new ArrayList<DialogController.DialogListener<T>>();

    protected abstract XulDialog getDialog();

    protected abstract T getDialogResult();

    @Override
    @Bindable
    public void showDialog() {
        this.getDialog().show();
    }

    @Bindable
    public void onDialogAccept() {
        this.hideDialog();
        for (DialogController.DialogListener<T> listener : this.listeners) {
            listener.onDialogAccept(this.getDialogResult());
        }
        this.listeners.clear();
    }

    @Bindable
    public void onDialogReady() {
        for (DialogController.DialogListener<T> listener : this.listeners) {
            listener.onDialogReady();
        }
    }

    @Bindable
    public void onDialogCancel() {
        this.hideDialog();
        for (DialogController.DialogListener<T> listener : this.listeners) {
            listener.onDialogCancel();
        }
        this.listeners.clear();
    }

    @Override
    public void addDialogListener(DialogController.DialogListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDialogListener(DialogController.DialogListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    @Bindable
    public void hideDialog() {
        this.getDialog().hide();
    }
}

