/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.libsparklines.util;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public final class ColorUtilitiy {
    private static final HashMap knownColorsByName = new HashMap();

    private ColorUtilitiy() {
    }

    private static Color parseColor(String value) {
        if (value == null) {
            return null;
        }
        Object o = knownColorsByName.get(value.toLowerCase());
        if (o != null) {
            return (Color)o;
        }
        try {
            return Color.decode(value.trim());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Color convertColor(String colorText, Color defValue) {
        if (colorText == null || colorText.length() == 0) {
            return defValue;
        }
        Color retval = ColorUtilitiy.parseColor(colorText);
        if (retval == null) {
            return defValue;
        }
        return retval;
    }

    static {
        try {
            Field[] fields = Color.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Modifier.isStatic(f.getModifiers())) continue;
                String name = f.getName();
                Object oColor = f.get(null);
                if (!(oColor instanceof Color)) continue;
                knownColorsByName.put(name.toLowerCase(), oColor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

