/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.libsparklines.util;

import java.math.BigDecimal;
import java.util.StringTokenizer;

public final class StringUtils {
    private static final Number[] EMPTY_NUMBERS = new Number[0];

    private StringUtils() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static Number[] toIntList(String s) {
        return StringUtils.toIntList(s, ",");
    }

    public static Number[] toIntList(String s, String sep) {
        if (StringUtils.isEmpty(s)) {
            return EMPTY_NUMBERS;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(s, sep);
        Number[] ret = new Number[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            ret[i] = new Integer(stringTokenizer.nextToken().trim());
            ++i;
        }
        return ret;
    }

    public static Number[] toBigDecimalList(String s) {
        return StringUtils.toBigDecimalList(s, ",");
    }

    public static Number[] toBigDecimalList(String s, String sep) {
        if (StringUtils.isEmpty(s)) {
            return EMPTY_NUMBERS;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(s, sep);
        Number[] ret = new Number[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String val = stringTokenizer.nextToken().trim();
            ret[i] = new BigDecimal(val);
            ++i;
        }
        return ret;
    }
}

