/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.libformula.ui.editor;

import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;

public class FormulaMessage {
    public static final int TYPE_ERROR = 1;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_MESSAGE = 3;
    public static final int TYPE_FUNCTION = 4;
    public static final int TYPE_FIELD = 5;
    public static final int TYPE_STATIC_NUMBER = 6;
    public static final int TYPE_STATIC_STRING = 7;
    public static final int TYPE_STATIC_DATE = 8;
    public static final int TYPE_STATIC_LOGICAL = 9;
    private ParsePosition position;
    private int type;
    private String subject;
    private String message;

    public FormulaMessage(int type, ParsePosition position, String subject, String message) {
        this.type = type;
        this.position = position;
        this.subject = subject;
        this.message = message;
    }

    public FormulaMessage(int type, String subject, String message) {
        this(type, null, subject, message);
    }

    public String toString() {
        String m = "";
        switch (this.type) {
            case 1: {
                m = m + "ERROR";
                break;
            }
            case 2: {
                m = m + "WARNING";
                break;
            }
            case 3: {
                m = m + "MESSAGE";
                break;
            }
            case 4: {
                m = m + "FUNCTION";
                break;
            }
            case 5: {
                m = m + "FIELD";
                break;
            }
            case 7: {
                m = m + "STATIC STRING";
                break;
            }
            case 6: {
                m = m + "STATIC NUMBER";
                break;
            }
            case 8: {
                m = m + "STATIC DATE/TIME";
                break;
            }
            case 9: {
                m = m + "STATIC LOGICAL";
                break;
            }
        }
        m = this.position != null ? m + "@" + this.position.getStartLine() + "/" + this.position.getStartColumn() + " : " : m + " : ";
        m = m + this.subject + " : " + this.message;
        return m;
    }

    public ParsePosition getPosition() {
        return this.position;
    }

    public void setPosition(ParsePosition position) {
        this.position = position;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

