/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.outputs;

import java.io.OutputStream;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.output.SimpleContentItem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.outputhandler.BaseOutputHandler;
import org.pentaho.platform.util.logging.Logger;

public class ApacheVFSOutputHandler
extends BaseOutputHandler {
    public IContentItem getFileOutputContentItem() {
        String contentRef = this.getContentRef();
        try {
            String contentName = this.getHandlerId().substring(4) + ":" + contentRef;
            FileSystemManager fsManager = VFS.getManager();
            if (fsManager == null) {
                Logger.error((String)ApacheVFSOutputHandler.class.getName(), (String)Messages.getString((String)"ApacheVFSOutputHandler.ERROR_0001_CANNOT_GET_VFSMGR"));
                return null;
            }
            FileObject file = fsManager.resolveFile(contentName);
            if (file == null) {
                Logger.error((String)ApacheVFSOutputHandler.class.getName(), (String)Messages.getString((String)"ApacheVFSOutputHandler.ERROR_0002_CANNOT_GET_VF", (String)contentName));
                return null;
            }
            if (!file.isWriteable()) {
                Logger.error((String)ApacheVFSOutputHandler.class.getName(), (String)Messages.getString((String)"ApacheVFSOutputHandler.ERROR_0003_CANNOT_WRITE", (String)contentName));
                return null;
            }
            FileContent fileContent = file.getContent();
            if (fileContent == null) {
                Logger.error((String)ApacheVFSOutputHandler.class.getName(), (String)Messages.getString((String)"ApacheVFSOutputHandler.ERROR_0004_CANNOT_GET_CTX", (String)contentName));
                return null;
            }
            OutputStream outputStream = fileContent.getOutputStream();
            SimpleContentItem content = new SimpleContentItem(outputStream);
            return content;
        }
        catch (Throwable t) {
            Logger.error((String)ApacheVFSOutputHandler.class.getName(), (String)Messages.getString((String)"ApacheVFSOutputHandler.ERROR_0005_CANNOT_GET_HANDLER", (String)contentRef), (Throwable)t);
            return null;
        }
    }
}

