/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.outputs;

import java.io.InputStream;
import java.util.Calendar;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.exception.NestableRuntimeException;
import org.pentaho.platform.api.engine.IContentListener;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.output.BufferedContentItem;
import org.pentaho.platform.engine.services.outputhandler.BaseOutputHandler;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;

public abstract class JcrCmsOutputHandler
extends BaseOutputHandler {
    private static final Log logger = LogFactory.getLog(JcrCmsOutputHandler.class);

    public abstract Repository getRepository();

    public abstract Session getJcrSession(Repository var1);

    public IContentItem getFileOutputContentItem() {
        String contentName = this.getContentRef();
        try {
            Repository repository = this.getRepository();
            if (repository == null) {
                Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)Messages.getString("JcrCmsOutputHandler.ERROR_0001_GETTING_CMSREPO"));
                return null;
            }
            Session jcrSession = this.getJcrSession(repository);
            if (jcrSession == null) {
                Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)Messages.getString("JcrCmsOutputHandler.ERROR_0002_GETTING_SESSION"));
                return null;
            }
            Node root = jcrSession.getRootNode();
            if (root == null) {
                Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)Messages.getString("JcrCmsOutputHandler.ERROR_0003_GETTING_ROOT"));
                return null;
            }
            Node node = root;
            StringTokenizer tokenizer = new StringTokenizer(contentName, "/");
            int levels = tokenizer.countTokens();
            for (int idx = 0; idx < levels - 1; ++idx) {
                String folder = tokenizer.nextToken();
                node = !node.hasNode(folder) ? node.addNode(folder, "nt:folder") : node.getNodes(folder).nextNode();
            }
            String fileName = tokenizer.nextToken();
            Node fileNode = null;
            Node contentNode = null;
            Version version = null;
            if (node.hasNode(fileName)) {
                fileNode = node.getNode(fileName);
                contentNode = fileNode.getNode("jcr:content");
                if (contentNode.isLocked()) {
                    logger.warn((Object)Messages.getString("JcrCmsOutputHandler.ERROR_0004_NODE_LOCKED", contentName));
                    return null;
                }
                if (contentNode.isCheckedOut()) {
                    logger.warn((Object)Messages.getString("JcrCmsOutputHandler.ERROR_0005_NODE_CHECKED_OUT", contentName));
                    return null;
                }
                contentNode.checkout();
                VersionHistory history = contentNode.getVersionHistory();
                VersionIterator iterator = history.getAllVersions();
                while (iterator.hasNext()) {
                    version = iterator.nextVersion();
                    logger.trace((Object)(version.getPath() + "," + version.getName() + "," + version.getIndex() + "," + version.getCreated().toString()));
                }
            } else {
                fileNode = node.addNode(fileName, "nt:file");
                fileNode.addMixin("mix:versionable");
                contentNode = fileNode.addNode("jcr:content", "nt:resource");
                contentNode.addMixin("mix:versionable");
                contentNode.addMixin("mix:filename");
                contentNode.setProperty("jcr:mimeType", this.getMimeType());
                contentNode.setProperty("jcr:name", fileName);
                contentNode.setProperty("jcr:encoding", LocaleHelper.getSystemEncoding());
            }
            CmsContentListener listener = new CmsContentListener(contentNode, jcrSession);
            BufferedContentItem contentItem = new BufferedContentItem((IContentListener)listener);
            listener.setContentItem(contentItem);
            return contentItem;
        }
        catch (LockException le) {
            Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)(Messages.getString("JcrCmsOutputHandler.ERROR_0006_GETTING_OUTPUTHANDLER") + contentName), (Throwable)le);
        }
        catch (NestableRuntimeException nre) {
            Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)(Messages.getString("JcrCmsOutputHandler.ERROR_0006_GETTING_OUTPUTHANDLER") + contentName), (Throwable)nre);
        }
        catch (RepositoryException re) {
            Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)(Messages.getString("JcrCmsOutputHandler.ERROR_0006_GETTING_OUTPUTHANDLER") + contentName), (Throwable)re);
        }
        return null;
    }

    private void search(String searchStr, Session session) {
        try {
            Workspace workspace = session.getWorkspace();
            QueryManager queryManager = workspace.getQueryManager();
            Query query = queryManager.createQuery("//*[jcr:contains(., '" + searchStr + "')]", "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                Node n = it.nextNode();
                logger.trace((Object)n.getName());
                if (!n.getName().equals("jcr:content") || n.getProperty("jcr:mimeType") == null) continue;
                logger.trace((Object)("jcr:mimeType=" + n.getProperty("jcr:mimeType").getString()));
            }
        }
        catch (InvalidQueryException iqe) {
            Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)Messages.getString("JcrCmsOutputHandler.ERROR_0008_SEARCH_FAILED"), (Throwable)iqe);
        }
        catch (RepositoryException re) {
            Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)Messages.getString("JcrCmsOutputHandler.ERROR_0008_SEARCH_FAILED"), (Throwable)re);
        }
    }

    private class CmsContentListener
    implements IContentListener {
        private Node node;
        private Session session;
        private BufferedContentItem contentItem;

        public CmsContentListener() {
        }

        public CmsContentListener(Node node, Session session) {
            this.node = node;
            this.session = session;
        }

        public void close() {
            try {
                InputStream inputStream = this.contentItem.getInputStream();
                this.node.setProperty("jcr:data", inputStream);
                Calendar lastModified = Calendar.getInstance();
                this.node.setProperty("jcr:lastModified", lastModified);
                this.session.save();
                this.node.checkin();
                this.session.save();
            }
            catch (LockException le) {
                Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)Messages.getString("JcrCmsOutputHandler.ERROR_0007_SAVING_CONTENT"), (Throwable)le);
            }
            catch (RepositoryException re) {
                Logger.error((String)JcrCmsOutputHandler.class.getName(), (String)Messages.getString("JcrCmsOutputHandler.ERROR_0007_SAVING_CONTENT"), (Throwable)re);
            }
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public void setSession(Session session) {
            this.session = session;
        }

        public void setContentItem(BufferedContentItem contentItem) {
            this.contentItem = contentItem;
        }

        public void setMimeType(String mimeType) {
        }

        public void setName(String Name) {
        }
    }
}

