/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.cache.ICacheExpirationRegistry;
import org.pentaho.platform.api.cache.ILastModifiedCacheItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheExpirationRegistry
implements ICacheExpirationRegistry {
    private Map<String, ILastModifiedCacheItem> cacheItems = Collections.synchronizedMap(new HashMap());

    public void register(ILastModifiedCacheItem cacheItem) {
        if (cacheItem == null || cacheItem.getCacheKey() == null || cacheItem.getCacheKey().trim().length() == 0) {
            return;
        }
        this.cacheItems.put(cacheItem.getCacheKey(), cacheItem);
    }

    public void unRegister(ILastModifiedCacheItem cacheItem) {
        if (cacheItem == null || cacheItem.getCacheKey() == null || cacheItem.getCacheKey().trim().length() == 0) {
            return;
        }
        this.cacheItems.remove(cacheItem.getCacheKey());
    }

    public List<ILastModifiedCacheItem> getCachedItems() {
        return new ArrayList<ILastModifiedCacheItem>(this.cacheItems.values());
    }
}

