/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.pentaho.platform.api.cache.ICacheExpirationRegistry;
import org.pentaho.platform.api.cache.ILastModifiedCacheItem;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.plugin.services.cache.LastModifiedCache;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class CacheManager
implements ICacheManager {
    protected static final Log logger = LogFactory.getLog(CacheManager.class);
    private CacheProvider cacheProvider;
    private Map<String, Cache> regionCache;
    private String cacheProviderClassName;
    private boolean cacheEnabled;
    private final Properties cacheProperties = new Properties();
    private ICacheExpirationRegistry cacheExpirationRegistry;

    public CacheManager() {
        ISystemSettings settings = PentahoSystem.getSystemSettings();
        String s = System.getProperty("java.io.tmpdir");
        char c = s.charAt(s.length() - 1);
        if (c != '/' && c != '\\') {
            System.setProperty("java.io.tmpdir", s + "/");
        }
        if (settings != null) {
            this.cacheProviderClassName = settings.getSystemSetting("cache-provider/class", null);
            if (this.cacheProviderClassName != null) {
                Properties cacheProperties = this.getCacheProperties(settings);
                this.setupCacheProvider(cacheProperties);
                this.cacheEnabled = true;
            }
        }
        PentahoSystem.addLogoutListener((ILogoutListener)this);
    }

    protected void setupCacheProvider(Properties cacheProperties) {
        Object obj = PentahoSystem.createObject((String)this.cacheProviderClassName);
        this.cacheExpirationRegistry = (ICacheExpirationRegistry)PentahoSystem.get(ICacheExpirationRegistry.class, null);
        if (null != obj) {
            if (obj instanceof CacheProvider) {
                this.cacheProvider = (CacheProvider)obj;
                this.cacheProvider.start(cacheProperties);
                this.regionCache = new HashMap<String, Cache>();
                LastModifiedCache cache = this.buildCache("SESSION", cacheProperties);
                if (cache == null) {
                    logger.error((Object)Messages.getString((String)"CacheManager.ERROR_0005_UNABLE_TO_BUILD_CACHE"));
                } else {
                    this.regionCache.put("SESSION", cache);
                }
                cache = this.buildCache("GLOBAL", cacheProperties);
                if (cache == null) {
                    logger.error((Object)Messages.getString((String)"CacheManager.ERROR_0005_UNABLE_TO_BUILD_CACHE"));
                } else {
                    this.regionCache.put("GLOBAL", cache);
                }
            } else {
                logger.error((Object)Messages.getString((String)"CacheManager.ERROR_0002_NOT_INSTANCE_OF_CACHE_PROVIDER"));
            }
        }
    }

    public void cacheStop() {
        if (this.cacheEnabled) {
            this.regionCache.clear();
            this.cacheProvider.stop();
        }
    }

    protected CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    private Properties getCacheProperties(ISystemSettings settings) {
        Properties cacheProperties = new Properties();
        List propertySettings = settings.getSystemSettings("cache-provider/properties/*");
        for (int i = 0; i < propertySettings.size(); ++i) {
            String propertyValue;
            Object obj = propertySettings.get(i);
            Element someProperty = (Element)obj;
            String propertyName = XmlDom4JHelper.getNodeText((String)"@name", (Node)someProperty, null);
            if (propertyName == null || (propertyValue = someProperty.getTextTrim()) == null) continue;
            cacheProperties.put(propertyName, propertyValue);
        }
        return cacheProperties;
    }

    public boolean cacheEnabled(String region) {
        Cache cache = this.regionCache.get(region);
        return cache != null;
    }

    public void onLogout(IPentahoSession session) {
        this.removeRegionCache(session.getName());
    }

    public boolean addCacheRegion(String region, Properties cacheProperties) {
        boolean returnValue = false;
        if (this.cacheEnabled) {
            if (!this.cacheEnabled(region)) {
                LastModifiedCache cache = this.buildCache(region, cacheProperties);
                if (cache == null) {
                    logger.error((Object)Messages.getString((String)"CacheManager.ERROR_0005_UNABLE_TO_BUILD_CACHE"));
                } else {
                    this.regionCache.put(region, cache);
                    returnValue = true;
                }
            } else {
                logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0002_REGION_ALREADY_EXIST", (String)region));
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
        return returnValue;
    }

    public boolean addCacheRegion(String region) {
        boolean returnValue = false;
        if (this.cacheEnabled) {
            if (!this.cacheEnabled(region)) {
                LastModifiedCache cache = this.buildCache(region, null);
                if (cache == null) {
                    logger.error((Object)Messages.getString((String)"CacheManager.ERROR_0005_UNABLE_TO_BUILD_CACHE"));
                } else {
                    this.regionCache.put(region, cache);
                    returnValue = true;
                }
            } else {
                logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0002_REGION_ALREADY_EXIST", (String)region));
                returnValue = true;
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
        return returnValue;
    }

    public void clearRegionCache(String region) {
        if (this.cacheEnabled) {
            Cache cache = this.regionCache.get(region);
            if (cache != null) {
                try {
                    cache.clear();
                }
                catch (CacheException e) {
                    logger.error((Object)Messages.getString((String)"CacheManager.ERROR_0006_CACHE_EXCEPTION", (String)e.getLocalizedMessage()));
                }
            } else {
                logger.info((Object)Messages.getString((String)"CacheManager.INFO_0001_CACHE_DOES_NOT_EXIST", (String)region));
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
    }

    public void removeRegionCache(String region) {
        if (this.cacheEnabled) {
            if (this.cacheEnabled(region)) {
                this.clearRegionCache(region);
            } else {
                logger.info((Object)Messages.getString((String)"CacheManager.INFO_0001_CACHE_DOES_NOT_EXIST", (String)region));
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
    }

    public void putInRegionCache(String region, Object key, Object value) {
        if (this.cacheEnabled) {
            if (this.cacheEnabled(region)) {
                Cache cache = this.regionCache.get(region);
                cache.put(key, value);
            } else {
                logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0003_REGION_DOES_NOT_EXIST", (String)region));
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
    }

    public Object getFromRegionCache(String region, Object key) {
        Object returnValue = null;
        if (this.cacheEnabled) {
            Cache cache = this.regionCache.get(region);
            if (this.cacheEnabled(region)) {
                returnValue = cache.get(key);
            } else {
                logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0003_REGION_DOES_NOT_EXIST", (String)region));
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
        return returnValue;
    }

    public List getAllValuesFromRegionCache(String region) {
        ArrayList list = new ArrayList();
        if (this.cacheEnabled) {
            Map cacheMap;
            Cache cache = this.regionCache.get(region);
            if (this.cacheEnabled(region) && (cacheMap = cache.toMap()) != null) {
                for (Map.Entry entry : cacheMap.entrySet()) {
                    list.add(entry.getValue());
                }
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
        return list;
    }

    public Set getAllKeysFromRegionCache(String region) {
        Set set = null;
        if (this.cacheEnabled) {
            Map cacheMap;
            Cache cache = this.regionCache.get(region);
            if (this.cacheEnabled(region) && (cacheMap = cache.toMap()) != null) {
                set = cacheMap.keySet();
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
        return set;
    }

    public Set getAllEntriesFromRegionCache(String region) {
        Set set = null;
        if (this.cacheEnabled) {
            Map cacheMap;
            Cache cache = this.regionCache.get(region);
            if (this.cacheEnabled(region) && (cacheMap = cache.toMap()) != null) {
                set = cacheMap.entrySet();
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
        return set;
    }

    public void removeFromRegionCache(String region, Object key) {
        if (this.cacheEnabled) {
            Cache cache = this.regionCache.get(region);
            if (this.cacheEnabled(region)) {
                cache.remove(key);
            } else {
                logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0003_REGION_DOES_NOT_EXIST", (String)region));
            }
        } else {
            logger.warn((Object)Messages.getString((String)"CacheManager.WARN_0001_CACHE_NOT_ENABLED"));
        }
    }

    public boolean cacheEnabled() {
        return this.cacheEnabled;
    }

    public void clearCache() {
        if (this.cacheEnabled) {
            for (Map.Entry<String, Cache> entry : this.regionCache.entrySet()) {
                String key = entry.getKey() != null ? entry.getKey().toString() : "";
                if (key == null) continue;
                Cache cache = this.regionCache.get(key);
                cache.clear();
            }
        }
    }

    public Object getFromGlobalCache(Object key) {
        return this.getFromRegionCache("GLOBAL", key);
    }

    public Object getFromSessionCache(IPentahoSession session, String key) {
        return this.getFromRegionCache("SESSION", this.getCorrectedKey(session, key));
    }

    public void killSessionCache(IPentahoSession session) {
        Map cacheMap;
        Cache cache;
        if (this.cacheEnabled && (cache = this.regionCache.get("SESSION")) != null && (cacheMap = cache.toMap()) != null) {
            Set set = cacheMap.keySet();
            for (String key : set) {
                if (key.indexOf(session.getId()) < 0) continue;
                cache.remove((Object)key);
            }
        }
    }

    public void killSessionCaches() {
        this.removeRegionCache("SESSION");
    }

    public void putInGlobalCache(Object key, Object value) {
        this.putInRegionCache("GLOBAL", key, value);
    }

    public void putInSessionCache(IPentahoSession session, String key, Object value) {
        this.putInRegionCache("SESSION", this.getCorrectedKey(session, key), value);
    }

    public void removeFromGlobalCache(Object key) {
        this.removeFromRegionCache("GLOBAL", key);
    }

    public void removeFromSessionCache(IPentahoSession session, String key) {
        this.removeFromRegionCache("SESSION", this.getCorrectedKey(session, key));
    }

    private String getCorrectedKey(IPentahoSession session, String key) {
        String sessionId = session.getId();
        if (sessionId != null) {
            String newKey = sessionId + "\t" + key;
            return newKey;
        }
        throw new CacheException(Messages.getErrorString((String)"CacheManager.ERROR_0001_NOSESSION"));
    }

    private LastModifiedCache buildCache(String key, Properties cacheProperties) {
        if (this.getCacheProvider() != null) {
            Cache cache = this.getCacheProvider().buildCache(key, cacheProperties);
            LastModifiedCache lmCache = new LastModifiedCache(cache);
            if (this.cacheExpirationRegistry != null) {
                this.cacheExpirationRegistry.register((ILastModifiedCacheItem)lmCache);
            } else {
                logger.warn((Object)Messages.getErrorString((String)"CacheManager.WARN_0003_NO_CACHE_EXPIRATION_REGISTRY"));
            }
            return lmCache;
        }
        logger.error((Object)Messages.getErrorString((String)"CacheManager.ERROR_0004_CACHE_PROVIDER_NOT_AVAILABLE"));
        return null;
    }

    public long getElementCountInRegionCache(String region) {
        if (this.cacheEnabled) {
            Cache cache = this.regionCache.get(region);
            if (cache != null) {
                try {
                    long memCnt = cache.getElementCountInMemory();
                    long discCnt = cache.getElementCountOnDisk();
                    return memCnt + discCnt;
                }
                catch (Exception ignored) {
                    return -1L;
                }
            }
            return -1L;
        }
        return -1L;
    }

    public long getElementCountInSessionCache() {
        return this.getElementCountInRegionCache("SESSION");
    }

    public long getElementCountInGlobalCache() {
        return this.getElementCountInRegionCache("GLOBAL");
    }
}

