/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.mondrian;

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.IConnectionUserRoleMapper;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.engine.core.system.IPentahoLoggingConnection;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXResultSet;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;

public class MDXConnection
implements IPentahoLoggingConnection {
    public static final String CONNECTION_STRING_KEY = "mdx-connection-string";
    public static final String MDX_CONNECTION_MAPPER_KEY = "Mondrian-UserRoleMapper";
    protected Connection nativeConnection = null;
    private String lastQuery = null;
    private IPentahoResultSet resultSet = null;
    private ILogger logger = null;
    private boolean useExtendedColumnNames = false;
    private Role role = null;

    public MDXConnection() {
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public void setProperties(Properties props) {
        if (props == null) {
            return;
        }
        String connectStr = props.getProperty("jndiName");
        if (connectStr != null) {
            this.init(connectStr);
        } else {
            String connection = props.getProperty("connection");
            String provider = props.getProperty("provider");
            String userName = props.getProperty("userName");
            String password = props.getProperty("password");
            if (connection != null && provider != null) {
                this.init(connection, provider, userName, password, props);
            } else {
                this.init(props);
            }
        }
    }

    @Deprecated
    public MDXConnection(String driver, String provider, String userName, String password) {
        this.init(driver, provider, userName, password, new Properties());
    }

    public MDXConnection(String connectStr, ILogger logger) {
        this.logger = logger;
        this.init(connectStr);
    }

    protected void init(String connectStr) {
        Util.PropertyList properties = Util.parseConnectString((String)connectStr);
        this.init(properties);
    }

    protected void init(Properties properties) {
        Util.PropertyList pl = new Util.PropertyList();
        Enumeration<Object> enum1 = properties.keys();
        while (enum1.hasMoreElements()) {
            Object key = enum1.nextElement();
            Object value = properties.get(key);
            pl.put(key.toString(), value.toString());
        }
        this.init(pl);
    }

    protected void init(String driver, String provider, String userName, String password, Properties props) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("provider=" + provider);
        if (driver.indexOf("dataSource=") >= 0) {
            buffer.append("; ").append(driver);
        } else {
            buffer.append("; Jdbc=" + driver);
        }
        if (userName != null) {
            buffer.append("; JdbcUser=" + userName);
        }
        if (password != null) {
            buffer.append("; JdbcPassword=" + password);
        }
        Enumeration<Object> enum1 = props.keys();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            if ("connection".equals(key) || "provider".equals(key) || "userName".equals(key) || "password".equals(key)) continue;
            buffer.append("; " + key + "=" + props.get(key));
        }
        this.init(buffer.toString());
    }

    protected void mapPlatformRolesToMondrianRoles(Util.PropertyList properties) throws PentahoAccessControlException {
        String[] validMondrianRolesForUser;
        IConnectionUserRoleMapper mondrianUserRoleMapper;
        if (properties.get(RolapConnectionProperties.Role.name(), null) == null && PentahoSystem.getObjectFactory().objectDefined(MDX_CONNECTION_MAPPER_KEY) && (mondrianUserRoleMapper = (IConnectionUserRoleMapper)PentahoSystem.get(IConnectionUserRoleMapper.class, (String)MDX_CONNECTION_MAPPER_KEY, null)) != null && (validMondrianRolesForUser = mondrianUserRoleMapper.mapConnectionRoles(PentahoSessionHolder.getSession(), properties.get(RolapConnectionProperties.Catalog.name()))) != null && validMondrianRolesForUser.length > 0) {
            StringBuffer buff = new StringBuffer();
            String aRole = null;
            for (int i = 0; i < validMondrianRolesForUser.length; ++i) {
                aRole = validMondrianRolesForUser[i];
                if (i > 0) {
                    buff.append(",");
                }
                buff.append(aRole.replaceAll(",", ",,"));
            }
            properties.put(RolapConnectionProperties.Role.name(), buff.toString());
        }
    }

    protected void init(Util.PropertyList properties) {
        try {
            if (this.nativeConnection != null) {
                this.close();
            }
            if (properties.get(RolapConnectionProperties.Locale.name()) == null) {
                properties.put(RolapConnectionProperties.Locale.name(), LocaleHelper.getLocale().toString());
            }
            String dataSourceName = properties.get(RolapConnectionProperties.DataSource.name());
            this.mapPlatformRolesToMondrianRoles(properties);
            if (dataSourceName != null) {
                IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, null);
                DataSource dataSourceImpl = datasourceService.getDataSource(dataSourceName);
                if (dataSourceImpl != null) {
                    properties.remove(RolapConnectionProperties.DataSource.name());
                    this.nativeConnection = DriverManager.getConnection((Util.PropertyList)properties, null, (DataSource)dataSourceImpl);
                } else {
                    this.nativeConnection = DriverManager.getConnection((Util.PropertyList)properties, null);
                }
            } else {
                this.nativeConnection = DriverManager.getConnection((Util.PropertyList)properties, null);
            }
            if (this.nativeConnection != null && this.role != null) {
                this.nativeConnection.setRole(this.role);
            }
            if (this.nativeConnection == null) {
                this.logger.error(Messages.getErrorString("MDXConnection.ERROR_0002_INVALID_CONNECTION", properties != null ? properties.toString() : "null"));
            }
        }
        catch (Throwable t) {
            if (this.logger != null) {
                this.logger.error(Messages.getErrorString("MDXConnection.ERROR_0002_INVALID_CONNECTION", properties != null ? properties.toString() : "null"), t);
            }
            Logger.error((String)this.getClass().getName(), (String)Messages.getErrorString("MDXConnection.ERROR_0002_INVALID_CONNECTION", properties != null ? properties.toString() : "null"), (Throwable)t);
        }
    }

    public boolean initialized() {
        return this.nativeConnection != null;
    }

    public IPentahoResultSet prepareAndExecuteQuery(String query, List parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean preparedQueriesSupported() {
        return false;
    }

    public void close() {
        if (this.nativeConnection != null) {
            this.nativeConnection.close();
        }
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public IPentahoResultSet executeQuery(String query) {
        Query mdxQuery = this.nativeConnection.parseQuery(query);
        Result result = this.nativeConnection.execute(mdxQuery);
        this.resultSet = new MDXResultSet(result, this.nativeConnection, this.useExtendedColumnNames);
        return this.resultSet;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void clearWarnings() {
    }

    public IPentahoResultSet getResultSet() {
        return this.resultSet;
    }

    public boolean connect(Properties props) {
        if (this.nativeConnection != null) {
            this.close();
        }
        this.init(props);
        String query = props.getProperty("query");
        if (query != null && query.length() > 0 && this.nativeConnection != null) {
            this.executeQuery(query);
        }
        return this.nativeConnection != null;
    }

    public void setMaxRows(int maxRows) {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int fetchSize) {
        throw new UnsupportedOperationException();
    }

    public Connection getConnection() {
        return this.nativeConnection;
    }

    public String getDatasourceType() {
        return "MDX";
    }

    public void setUseExtendedColumnNames(boolean useExtendedColumnNames) {
        this.useExtendedColumnNames = useExtendedColumnNames;
    }

    public void setRole(Role customRole) {
        this.role = customRole;
    }
}

