/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.mondrian;

import mondrian.olap.Connection;
import mondrian.olap.Result;
import org.pentaho.commons.connection.IMultiDimensionalResultSet;
import org.pentaho.commons.connection.IPeekable;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXMetaData;

public class MDXResultSet
implements IPentahoResultSet,
IPeekable,
IMultiDimensionalResultSet {
    private Result nativeResultSet;
    private Connection nativeConnection;
    private int rowIndex = 0;
    private MDXMetaData mdxMetaData = null;
    private Object[] peekRow;

    public MDXResultSet() {
    }

    public MDXResultSet(Result nativeResultSet, Connection nativeConnection, boolean useExtendedColumnNames) {
        this.nativeResultSet = nativeResultSet;
        this.nativeConnection = nativeConnection;
        this.mdxMetaData = new MDXMetaData(this.nativeResultSet, useExtendedColumnNames);
    }

    public IPentahoMetaData getMetaData() {
        return this.mdxMetaData;
    }

    public Object[] peekRowHeaders() {
        int peekRowNo = this.rowIndex;
        if (peekRowNo < this.getRowCount()) {
            return this.mdxMetaData.getRowHeaders()[peekRowNo];
        }
        return null;
    }

    public Object[] peek() {
        if (this.peekRow == null) {
            this.peekRow = this.next();
        }
        return this.peekRow;
    }

    public Object[] next() {
        if (this.peekRow != null) {
            Object[] row = this.peekRow;
            this.peekRow = null;
            return row;
        }
        Object[] currentRow = null;
        int columnCount = this.getColumnCount();
        if (this.rowIndex < this.getRowCount()) {
            currentRow = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                currentRow[i] = this.getValueAt(this.rowIndex, i);
            }
            ++this.rowIndex;
        }
        return currentRow;
    }

    public void close() {
        this.nativeResultSet.close();
    }

    public void closeConnection() {
        this.nativeResultSet.close();
        this.nativeConnection.close();
    }

    public void dispose() {
        this.closeConnection();
    }

    public boolean isScrollable() {
        return true;
    }

    public Object getValueAt(int row, int column) {
        int[] key = new int[]{column, row};
        return this.nativeResultSet.getCell(key).getValue();
    }

    public int getRowCount() {
        return this.mdxMetaData.getRowHeaders().length;
    }

    public int getColumnCount() {
        return this.mdxMetaData.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPentahoResultSet memoryCopy() {
        try {
            IPentahoMetaData metadata = this.getMetaData();
            Object[][] columnHeaders = metadata.getColumnHeaders();
            Object[][] rowHeaders = metadata.getRowHeaders();
            MemoryMetaData cachedMetaData = new MemoryMetaData(columnHeaders, rowHeaders);
            MemoryResultSet cachedResultSet = new MemoryResultSet((IPentahoMetaData)cachedMetaData);
            Object[] rowObjects = this.next();
            while (rowObjects != null) {
                cachedResultSet.addRow(rowObjects);
                rowObjects = this.next();
            }
            MemoryResultSet memoryResultSet = cachedResultSet;
            return memoryResultSet;
        }
        finally {
            this.close();
        }
    }

    public void beforeFirst() {
        this.rowIndex = 0;
    }

    public Object[] getDataColumn(int column) {
        int oldIndex = this.rowIndex;
        this.beforeFirst();
        Object[] result = new Object[this.getRowCount()];
        int index = 0;
        Object[] rowData = this.next();
        while (rowData != null) {
            result[index] = rowData[column];
            ++index;
            rowData = this.next();
        }
        this.rowIndex = oldIndex;
        return result;
    }

    public Object[] getDataRow(int row) {
        int oldIndex = this.rowIndex;
        this.rowIndex = row;
        Object[] rowData = this.next();
        this.rowIndex = oldIndex;
        return rowData;
    }

    protected Result getNativeResultSet() {
        return this.nativeResultSet;
    }

    protected void setNativeResultSet(Result nativeResultSet) {
        this.nativeResultSet = nativeResultSet;
    }

    protected Connection getNativeConnection() {
        return this.nativeConnection;
    }

    protected void setNativeConnection(Connection nativeConnection) {
        this.nativeConnection = nativeConnection;
    }

    protected MDXMetaData getMdxMetaData() {
        return this.mdxMetaData;
    }

    protected void setMdxMetaData(MDXMetaData mdxMetaData) {
        this.mdxMetaData = mdxMetaData;
    }

    protected Object[] getPeekRow() {
        return this.peekRow;
    }

    protected void setPeekRow(Object[] peekRow) {
        this.peekRow = peekRow;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object[] nextFlattened() {
        Object[][] rowHeaders = this.mdxMetaData.getRowHeaders();
        if (rowHeaders == null) {
            return this.next();
        }
        Object[] row = this.next();
        if (row == null) {
            return null;
        }
        if (this.rowIndex <= rowHeaders.length) {
            Object[] rowHeads = rowHeaders[this.rowIndex - 1];
            Object[] flatRow = new Object[rowHeads.length + row.length];
            System.arraycopy(rowHeads, 0, flatRow, 0, rowHeads.length);
            System.arraycopy(row, 0, flatRow, rowHeads.length, row.length);
            return flatRow;
        }
        return row;
    }

    public Object[] peekFlattened() {
        Object[][] rowHeaders = this.mdxMetaData.getRowHeaders();
        if (rowHeaders == null) {
            return this.peek();
        }
        Object[] row = this.peek();
        if (row == null) {
            return null;
        }
        if (this.rowIndex <= rowHeaders.length) {
            Object[] rowHeads = rowHeaders[this.rowIndex - 1];
            Object[] flatRow = new Object[rowHeads.length + row.length];
            System.arraycopy(rowHeads, 0, flatRow, 0, rowHeads.length);
            System.arraycopy(row, 0, flatRow, rowHeads.length, row.length);
            return flatRow;
        }
        return row;
    }
}

