/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPeekable;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.plugin.services.connections.sql.SQLMetaData;
import org.pentaho.platform.plugin.services.connections.sql.SQLResultSetException;
import org.pentaho.platform.plugin.services.messages.Messages;

public class SQLResultSet
implements IPentahoResultSet,
IPeekable {
    ResultSet nativeResultSet = null;
    SQLConnection connection;
    private static final int COUNT_NEVER_OBTAINED = -2;
    private int rowCount = -2;
    private int columnCount = -2;
    protected Object[] peekRow;
    private static final Log log = LogFactory.getLog(SQLResultSet.class);
    private IPentahoMetaData metadata;

    public SQLResultSet(ResultSet nativeResultSet, SQLConnection nativeConnection) {
        this.connection = nativeConnection;
        this.nativeResultSet = nativeResultSet;
    }

    public void setMetaData(IPentahoMetaData metadata) {
        this.metadata = metadata;
    }

    public IPentahoMetaData getMetaData() {
        if (this.metadata == null) {
            try {
                this.metadata = new SQLMetaData(this.nativeResultSet.getMetaData());
            }
            catch (SQLException e) {
                log.error((Object)Messages.getErrorString("SQLResultSet.ERROR_0004_GET_METADATA"), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.metadata;
    }

    public Object[] peek() {
        if (this.peekRow == null) {
            this.peekRow = this.next();
        }
        return this.peekRow;
    }

    public Object[] next() {
        if (this.peekRow != null) {
            Object[] row = this.peekRow;
            this.peekRow = null;
            return row;
        }
        try {
            int columns = this.nativeResultSet.getMetaData().getColumnCount();
            if (this.nativeResultSet.next()) {
                Object[] currentRow = new Object[columns];
                for (int column = 0; column < columns; ++column) {
                    currentRow[column] = this.nativeResultSet.getObject(column + 1);
                }
                return currentRow;
            }
        }
        catch (SQLException e) {
            log.error((Object)Messages.getErrorString("SQLResultSet.ERROR_0005_NEXT"), (Throwable)e);
            throw new SQLResultSetException(Messages.getErrorString("SQLResultSet.ERROR_0005_NEXT"), e);
        }
        return null;
    }

    public void closeConnection() {
        this.close();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    public void close() {
        if (this.nativeResultSet != null) {
            try {
                this.nativeResultSet.close();
            }
            catch (SQLException e) {
                log.warn((Object)Messages.getString("SQLResultSet.WARN_CONNECTION_NOT_CLOSED"));
            }
            this.rowCount = -2;
        }
        this.nativeResultSet = null;
    }

    public void dispose() {
        this.closeConnection();
    }

    public boolean isScrollable() {
        if (this.nativeResultSet == null) {
            return false;
        }
        int resultSetType = 1003;
        try {
            resultSetType = this.nativeResultSet.getType();
        }
        catch (SQLException ex) {
            log.warn((Object)Messages.getString("SQLResultSet.WARN_RESULTSET_TYPE_UNDETERMINED"));
        }
        return resultSetType != 1003;
    }

    public int getColumnCount() {
        if (this.columnCount != -2) {
            return this.columnCount;
        }
        if (this.nativeResultSet == null) {
            return 0;
        }
        try {
            this.columnCount = this.nativeResultSet.getMetaData().getColumnCount();
            return this.columnCount;
        }
        catch (SQLException ex) {
            log.error((Object)Messages.getErrorString("SQLResultSet.ERROR_0006_GET_COLUMNCOUNT"), (Throwable)ex);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        if (!this.isScrollable()) {
            return -1;
        }
        if (this.rowCount != -2) {
            return this.rowCount;
        }
        if (this.nativeResultSet == null) {
            return 0;
        }
        try {
            int curRow = this.nativeResultSet.getRow();
            try {
                if (this.nativeResultSet.last()) {
                    this.rowCount = this.nativeResultSet.getRow();
                    if (this.rowCount <= 0) {
                        this.rowCount = 0;
                    }
                } else {
                    this.rowCount = 0;
                }
            }
            finally {
                if (curRow == 0) {
                    this.nativeResultSet.beforeFirst();
                } else {
                    this.nativeResultSet.absolute(curRow);
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)Messages.getErrorString("SQLResultSet.ERROR_0001_OBTAINING_ROWCOUNT"), (Throwable)sqle);
            this.rowCount = 0;
        }
        return this.rowCount;
    }

    public Object getValueAt(int row, int column) {
        if (this.nativeResultSet != null) {
            try {
                int curNativeRow = this.nativeResultSet.getRow();
                if (curNativeRow != row + 1) {
                    if (curNativeRow == row) {
                        this.nativeResultSet.next();
                    } else {
                        this.nativeResultSet.absolute(row + 1);
                    }
                }
                return this.nativeResultSet.getObject(column + 1);
            }
            catch (SQLException ex) {
                log.error((Object)Messages.getErrorString("SQLResultSet.ERROR_0002_GET_VALUE"), (Throwable)ex);
                throw new IllegalStateException(Messages.getErrorString("SQLResultSet.ERROR_0008_FORWARDED_SQL_MSG"), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPentahoResultSet memoryCopy() {
        try {
            IPentahoMetaData meta = this.getMetaData();
            Object[][] columnHeaders = meta.getColumnHeaders();
            MemoryMetaData cachedMetaData = new MemoryMetaData(columnHeaders, (Object[][])null);
            MemoryResultSet cachedResultSet = new MemoryResultSet((IPentahoMetaData)cachedMetaData);
            Object[] rowObjects = this.next();
            while (rowObjects != null) {
                cachedResultSet.addRow(rowObjects);
                rowObjects = this.next();
            }
            MemoryResultSet memoryResultSet = cachedResultSet;
            return memoryResultSet;
        }
        finally {
            this.close();
        }
    }

    public void beforeFirst() {
        try {
            if (this.nativeResultSet == null) {
                log.error((Object)Messages.getErrorString("SQLResultSet.ERROR_0007_BEFORE_FIRST_CONNECTION_CLOSED"));
            } else if (this.isScrollable()) {
                this.nativeResultSet.beforeFirst();
            } else {
                log.info((Object)Messages.getString("SQLResultSet.INFO_IGNORE_BEFORE_FIRST_RESULTSET_NON_SCROLLABLE"));
            }
        }
        catch (SQLException e) {
            log.error((Object)Messages.getErrorString("SQLResultSet.ERROR_0003_BEFORE_FIRST"), (Throwable)e);
        }
    }

    public Object[] getDataColumn(int column) {
        Object[] result = null;
        result = new Object[this.getRowCount()];
        for (int row = 0; row < result.length; ++row) {
            result[row] = this.getValueAt(row, column);
        }
        return result;
    }

    public Object[] getDataRow(int row) {
        Object[] rowData = new Object[this.getColumnCount()];
        for (int column = 0; column < rowData.length; ++column) {
            rowData[column] = this.getValueAt(row, column);
        }
        return rowData;
    }
}

