/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.xquery;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.engine.core.system.IPentahoLoggingConnection;
import org.pentaho.platform.plugin.services.connections.xquery.XQResultSet;
import org.pentaho.platform.plugin.services.messages.Messages;

public class XQConnection
implements IPentahoLoggingConnection {
    protected Configuration config = new Configuration();
    protected StaticQueryContext sqc = new StaticQueryContext(this.config);
    protected String lastQuery = null;
    protected ILogger logger = null;
    IPentahoResultSet resultSet = null;
    int maxRows = -1;

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public void setProperties(Properties props) {
        this.connect(props);
    }

    public boolean initialized() {
        return true;
    }

    public IPentahoResultSet prepareAndExecuteQuery(String query, List parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean preparedQueriesSupported() {
        return false;
    }

    public String getDatasourceType() {
        return "XML";
    }

    public void close() {
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public IPentahoResultSet executeQuery(String query) throws XPathException {
        return this.executeQuery(query, null);
    }

    public IPentahoResultSet executeQuery(String query, String[] columnTypes) throws XPathException {
        XQueryExpression exp = this.sqc.compileQuery(query);
        DynamicQueryContext dynamicContext = new DynamicQueryContext(this.config);
        try {
            this.resultSet = new XQResultSet(this, exp, dynamicContext, columnTypes);
        }
        catch (XPathException e) {
            if (e.getException() instanceof FileNotFoundException) {
                this.logger.error(Messages.getString("XQConnection.ERROR_0001_UNABLE_TO_READ", query));
            } else {
                this.logger.error(Messages.getString("XQConnection.ERROR_0002_XQUERY_EXCEPTION", query), (Throwable)e);
            }
        }
        catch (Throwable t) {
            this.logger.error(Messages.getErrorString("XQConnection.ERROR_0002_XQUERY_EXCEPTION", query), t);
        }
        this.lastQuery = query;
        return this.resultSet;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void clearWarnings() {
    }

    public IPentahoResultSet getResultSet() {
        return this.resultSet;
    }

    public boolean connect(Properties props) {
        String query;
        if (props != null && (query = props.getProperty("query")) != null && query.length() > 0) {
            try {
                this.executeQuery(query);
            }
            catch (XPathException e) {
                this.logger.error(e.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setFetchSize(int fetchSize) {
    }
}

