/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.xquery;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPeekable;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.plugin.services.connections.xquery.XQConnection;
import org.pentaho.platform.plugin.services.connections.xquery.XQMetaData;

public class XQResultSet
implements IPentahoResultSet,
IPeekable {
    protected static final Log logger = LogFactory.getLog(XQResultSet.class);
    protected XQueryExpression exp = null;
    protected DynamicQueryContext dynamicContext = null;
    protected XQMetaData metaData = null;
    protected static final String DELIM = ", ";
    protected static final String EMPTY_STR = "";
    protected Object[] peekRow;
    Iterator iter = null;
    protected String[] columnTypes = null;
    protected XQConnection connection;
    private List evaluatedList;

    public XQResultSet(XQConnection xqConnection, XQueryExpression exp, DynamicQueryContext dynamicContext, String[] columnTypes) throws XPathException {
        this.columnTypes = columnTypes;
        this.exp = exp;
        this.dynamicContext = dynamicContext;
        this.connection = xqConnection;
        this.init();
    }

    protected void init() throws XPathException {
        if (this.evaluatedList == null) {
            this.evaluatedList = this.evaluate();
        }
        if (this.metaData == null) {
            this.iter = this.evaluatedList.iterator();
            this.metaData = new XQMetaData(this.connection, this.iter);
        }
        this.iter = this.evaluatedList.iterator();
    }

    protected List evaluate() throws XPathException {
        SequenceIterator sequenceiterator = this.exp.iterator(this.dynamicContext);
        ArrayList<Object> rtn = new ArrayList<Object>(100);
        int rowCount = 0;
        int maxRows = this.connection != null ? this.connection.getMaxRows() : -1;
        Item item = null;
        while ((item = sequenceiterator.next()) != null && item != null && (maxRows < 0 || ++rowCount <= maxRows)) {
            rtn.add(Value.convert((Item)item));
        }
        return rtn;
    }

    public IPentahoMetaData getMetaData() {
        return this.metaData;
    }

    public Object[] peek() {
        if (this.peekRow == null) {
            this.peekRow = this.next();
        }
        return this.peekRow;
    }

    public Object[] next() {
        if (this.peekRow != null) {
            Object[] row = this.peekRow;
            this.peekRow = null;
            return row;
        }
        ListOrderedMap resultList = new ListOrderedMap();
        for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
            resultList.put(this.metaData.getColumnHeaders()[0][i], (Object)EMPTY_STR);
        }
        if (this.iter.hasNext()) {
            Object o = this.iter.next();
            this.decodeNode(o, (Map)resultList);
        }
        Object[] currentRow = new Object[resultList.size()];
        Iterator keyIter = resultList.keySet().iterator();
        int i = 0;
        while (keyIter.hasNext()) {
            currentRow[i] = resultList.get(keyIter.next());
            ++i;
        }
        boolean done = true;
        for (Object element : currentRow) {
            if (EMPTY_STR.equals(element)) continue;
            done = false;
        }
        if (done) {
            return null;
        }
        return currentRow;
    }

    protected void decodeNode(Object obj, Map retValue) {
        if (obj instanceof TinyNodeImpl) {
            Object value;
            AxisIterator aIter = ((TinyNodeImpl)obj).iterateAxis((byte)4);
            Item descendent = aIter.next();
            boolean processedChildren = false;
            int columnIndex = 0;
            while (descendent != null) {
                if (descendent instanceof TinyNodeImpl && ((TinyNodeImpl)descendent).getNodeKind() == 1) {
                    TinyNodeImpl descNode = (TinyNodeImpl)descendent;
                    value = retValue.get(descNode.getDisplayName());
                    if (value == null) {
                        value = EMPTY_STR;
                    }
                    if (!EMPTY_STR.equals(value)) {
                        value = value.toString() + DELIM;
                    }
                    if ((value = value.toString() + descNode.getStringValue()) != null && !value.equals(EMPTY_STR) && this.columnTypes != null && columnIndex >= 0 && columnIndex < this.columnTypes.length) {
                        String columnType = this.columnTypes[columnIndex].trim();
                        if (columnType.equals("java.math.BigDecimal")) {
                            value = new BigDecimal(value.toString());
                        } else if (columnType.equals("java.sql.Timestamp")) {
                            value = new Timestamp(Long.parseLong(value.toString()));
                        } else if (columnType.equals("java.sql.Date")) {
                            value = new Date(Long.parseLong(value.toString()));
                        } else if (columnType.equals("java.lang.Integer")) {
                            value = new Integer(Integer.parseInt(value.toString()));
                        } else if (columnType.equals("java.lang.Double")) {
                            value = new Double(Double.parseDouble(value.toString()));
                        } else if (columnType.equals("java.lang.Long")) {
                            value = new Long(Long.parseLong(value.toString()));
                        }
                    }
                    retValue.put(descNode.getDisplayName(), value);
                    processedChildren = true;
                    ++columnIndex;
                }
                descendent = aIter.next();
            }
            if (!processedChildren) {
                String key = ((TinyNodeImpl)obj).getDisplayName();
                value = ((TinyNodeImpl)obj).getStringValue();
                retValue.put(key, value);
            }
        } else {
            retValue.put("Default Column", obj.toString());
        }
    }

    public void close() {
    }

    public void closeConnection() {
    }

    public boolean isScrollable() {
        return false;
    }

    public Object getValueAt(int row, int column) {
        Object[] rowarr = this.getDataRow(row);
        if (rowarr != null && column >= 0 && column < rowarr.length) {
            return rowarr[column];
        }
        return null;
    }

    public int getRowCount() {
        return this.metaData.getRowCount();
    }

    public int getColumnCount() {
        return this.metaData.getColumnCount();
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPentahoResultSet memoryCopy() {
        try {
            IPentahoMetaData metadata = this.getMetaData();
            Object[][] columnHeaders = metadata.getColumnHeaders();
            MemoryMetaData cachedMetaData = new MemoryMetaData(columnHeaders, (Object[][])null);
            String[] columnTypeClones = new String[this.columnTypes.length];
            System.arraycopy(this.columnTypes, 0, columnTypeClones, 0, this.columnTypes.length);
            cachedMetaData.setColumnTypes(columnTypeClones);
            MemoryResultSet cachedResultSet = new MemoryResultSet((IPentahoMetaData)cachedMetaData);
            Object[] rowObjects = this.next();
            while (rowObjects != null) {
                cachedResultSet.addRow(rowObjects);
                rowObjects = this.next();
            }
            MemoryResultSet memoryResultSet = cachedResultSet;
            return memoryResultSet;
        }
        finally {
            this.close();
        }
    }

    public void beforeFirst() {
        try {
            this.init();
        }
        catch (XPathException e) {
            logger.error((Object)"Cannot initialize XQResultSet", (Throwable)e);
        }
    }

    public Object[] getDataColumn(int column) {
        if (column >= this.getColumnCount()) {
            return null;
        }
        this.beforeFirst();
        Object[] result = new Object[this.getRowCount()];
        int rowIndex = 0;
        Object[] rowData = this.next();
        while (rowData != null) {
            result[rowIndex] = rowData[column];
            ++rowIndex;
            rowData = this.next();
        }
        this.beforeFirst();
        return result;
    }

    public Object[] getDataRow(int row) {
        this.beforeFirst();
        int count = 0;
        while (count++ < row) {
            this.next();
        }
        Object[] dataRow = this.next();
        this.beforeFirst();
        return dataRow;
    }
}

