/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.FileBasedMetadataDomainRepository;
import org.pentaho.metadata.util.LocalizationUtil;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.engine.IFileFilter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFilter;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.metadata.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataDomainRepository
extends FileBasedMetadataDomainRepository {
    private static final String LEGACY_LOCATION = "__LEGACY_LOCATION_";
    protected final Log logger = LogFactory.getLog(MetadataDomainRepository.class);
    private static String LEGACY_XMI_FILENAME = "metadata.xmi";
    private static String LEGACY_XMI_FILE_EXTENSION = ".xmi";
    public static String PROPERTIES_FILE_EXTENSION = ".properties";
    public static final int[] ACCESS_TYPE_MAP = new int[]{0, 1, 2, 3, 4, 4};
    private static final String DOMAIN_FOLDER = "system/metadata/domains";

    public IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    protected File getDomainsFolder() {
        String domainsFolder = PentahoSystem.getApplicationContext().getSolutionPath(DOMAIN_FOLDER);
        File folder = new File(domainsFolder);
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDomainIds() {
        Map map = this.domains;
        synchronized (map) {
            super.reloadDomains();
            this.reloadLegacyDomains(false);
        }
        return super.getDomainIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadDomains() {
        Map map = this.domains;
        synchronized (map) {
            super.reloadDomains();
            this.reloadLegacyDomains(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomain(String domainId) {
        Map map = this.domains;
        synchronized (map) {
            Domain domain = (Domain)this.domains.get(domainId);
            if (domain.getProperty(LEGACY_LOCATION) != null) {
                this.removeLegacyDomain(domainId);
            } else {
                super.removeDomain(domainId);
            }
        }
    }

    public Domain getDomain(String id) {
        Domain domain = super.getDomain(id);
        if (domain == null) {
            this.reloadLegacyDomains(false);
            return super.getDomain(id);
        }
        return domain;
    }

    private void removeLegacyDomain(String domainId) {
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
        repo.removeSolutionFile(domainId);
        this.domains.remove(domainId);
    }

    private void reloadLegacyDomains(boolean overwrite) {
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
        Document doc = repo.getSolutionTree(1, new ISolutionFilter(){

            public boolean keepFile(ISolutionFile solutionFile, int actionOperation) {
                return solutionFile.isDirectory() || solutionFile.getExtension().equalsIgnoreCase("xmi") || solutionFile.getExtension().equalsIgnoreCase(".xmi");
            }
        });
        int allSuccess = 0;
        try {
            Element node;
            List nodes = doc.selectNodes("/tree/branch/branch/leaf[@isDir='false']");
            for (Object obj : nodes) {
                node = (Element)obj;
                Element pathNode = (Element)node.selectSingleNode("path");
                String path = pathNode.getText();
                int idx = path.indexOf(47, 1);
                if (!(path = path.substring(idx + 1)).endsWith(LEGACY_XMI_FILENAME) || !overwrite && this.domains.containsKey(path)) continue;
                allSuccess |= this.loadMetadata(path);
            }
            nodes = doc.selectNodes("/tree/branch/branch/branch/branch/leaf[@isDir='false']");
            for (Object obj : nodes) {
                node = (Element)obj;
                String dir = node.getParent().attributeValue("id");
                if (!dir.endsWith("/resources/metadata")) continue;
                Element pathNode = (Element)node.selectSingleNode("path");
                String path = pathNode.getText();
                int idx = path.indexOf(47, 1);
                path = path.substring(idx + 1);
                if (!overwrite && this.domains.containsKey(path)) continue;
                allSuccess |= this.loadMetadata(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int loadMetadata(String resourceName) {
        int result = 0;
        InputStream xmiInputStream = null;
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
        if (repo.resourceExists(resourceName, 1)) {
            try {
                xmiInputStream = repo.getResourceInputStream(resourceName, true, 1);
                Domain domain = new XmiParser().parseXmi(xmiInputStream);
                domain.setProperty(LEGACY_LOCATION, (Object)resourceName);
                domain.setId(resourceName);
                this.importLocalizations(domain, resourceName);
                this.domains.put(resourceName, domain);
            }
            catch (Throwable t) {
                this.logger.error((Object)Messages.getString("MetadataPublisher.ERROR_0001_COULD_NOT_LOAD", resourceName), t);
                throw new RuntimeException(Messages.getString("MetadataPublisher.ERROR_0001_COULD_NOT_LOAD"), t);
            }
            finally {
                if (xmiInputStream != null) {
                    try {
                        xmiInputStream.close();
                    }
                    catch (IOException ex) {
                        this.logger.error((Object)Messages.getString("MetadataPublisher.ERROR_0001_COULD_NOT_LOAD", resourceName), (Throwable)ex);
                        throw new RuntimeException(Messages.getString("MetadataPublisher.ERROR_0001_COULD_NOT_LOAD"), ex);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDomain(Domain domain, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        Map map = this.domains;
        synchronized (map) {
            if (domain.getId() == null) {
                throw new DomainIdNullException(org.pentaho.metadata.messages.Messages.getErrorString((String)"IMetadataDomainRepository.ERROR_0001_DOMAIN_ID_NULL", (Object[])new Object[0]));
            }
            if (!overwrite && this.domains.get(domain.getId()) != null) {
                throw new DomainAlreadyExistsException(org.pentaho.metadata.messages.Messages.getErrorString((String)"IMetadataDomainRepository.ERROR_0002_DOMAIN_OBJECT_EXISTS", (Object[])new Object[]{domain.getId()}));
            }
            if (domain.getProperty(LEGACY_LOCATION) != null) {
                this.storeLegacyDomain(domain, overwrite);
            } else {
                super.storeDomain(domain, overwrite);
            }
        }
    }

    private void storeLegacyDomain(Domain domain, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        if (domain.getId() == null) {
            throw new DomainIdNullException(org.pentaho.metadata.messages.Messages.getErrorString((String)"IMetadataDomainRepository.ERROR_0001_DOMAIN_ID_NULL", (Object[])new Object[0]));
        }
        if (!overwrite) {
            throw new DomainAlreadyExistsException(org.pentaho.metadata.messages.Messages.getErrorString((String)"IMetadataDomainRepository.ERROR_0002_DOMAIN_OBJECT_EXISTS", (Object[])new Object[]{domain.getId()}));
        }
        XmiParser parser = new XmiParser();
        String xmi = parser.generateXmi(domain);
        try {
            String domainId = domain.getId();
            int idx = domainId.lastIndexOf(47);
            String path = domainId.substring(0, idx);
            String fileName = domainId.substring(idx + 1);
            ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
            String solutionPath = PentahoSystem.getApplicationContext().getSolutionPath("");
            repo.addSolutionFile(solutionPath, path, fileName, xmi.getBytes(LocaleHelper.getSystemEncoding()), true);
            this.domains.put(domain.getId(), domain);
        }
        catch (Exception e) {
            throw new DomainStorageException(Messages.getErrorString("MetadataDomainRepository.ERROR_0006_FAILED_TO_STORE_LEGACY_DOMAIN", domain.getId()), e);
        }
    }

    protected ISolutionFile getFolder(String filename) throws DomainStorageException {
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
        ISolutionFile solutionFile = repo.getSolutionFile(filename, 1);
        if (solutionFile != null) {
            return solutionFile.retrieveParent();
        }
        return null;
    }

    protected String getLocaleFromPropertyFilename(String filename, String prefix) throws DomainStorageException {
        String locale = "";
        if (!StringUtils.isEmpty((String)filename)) {
            int startIndex = filename.lastIndexOf(47);
            startIndex = startIndex >= 1 ? ++startIndex : 0;
            int endIndex = filename.indexOf(PROPERTIES_FILE_EXTENSION);
            if (startIndex >= endIndex) {
                throw new DomainStorageException(Messages.getErrorString("MetadataDomainRepository.ERROR_0010_FAILED_TO_RESOLVE_LOCALE", filename), null);
            }
            locale = filename.substring(startIndex + prefix.length() + 1, endIndex);
        }
        return locale;
    }

    protected ISolutionFile[] getLocalePropertyFiles(String resourceName) throws DomainStorageException {
        try {
            int lastSlash = resourceName.lastIndexOf(47);
            String filenamePrefix = resourceName.substring(lastSlash > 0 ? lastSlash + 1 : 0, resourceName.indexOf(LEGACY_XMI_FILE_EXTENSION));
            ISolutionFile dir = this.getFolder(resourceName);
            PropertyFilesFilter filter = new PropertyFilesFilter(filenamePrefix);
            ISolutionFile[] fileNames = dir.listFiles((IFileFilter)filter);
            if (fileNames == null) {
                fileNames = new ISolutionFile[]{};
            }
            return fileNames;
        }
        catch (Exception e) {
            throw new DomainStorageException(Messages.getErrorString("MetadataDomainRepository.ERROR_0007_FAILED_TO_GET_LOCALIZATION_FILE_LIST", resourceName), e);
        }
    }

    protected void importLocalizations(Domain domain, String resourceName) throws DomainStorageException {
        ISolutionFile[] propertiesFiles = this.getLocalePropertyFiles(resourceName);
        if (propertiesFiles != null) {
            LocalizationUtil localizationUtil = new LocalizationUtil();
            String locale = null;
            String propertiesFileNamePrefix = this.getPropertiesFilePrefix(resourceName);
            ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
            for (ISolutionFile propertyFile : propertiesFiles) {
                InputStream inputStream = null;
                try {
                    inputStream = repo.getResourceInputStream(propertyFile.getSolutionPath().replaceFirst(String.valueOf('/'), "") + '/' + propertyFile.getFileName(), false, 1);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    if (properties.isEmpty()) {
                        String message = Messages.getErrorString("MetadataDomainRepository.ERROR_0008_EMPTY_LOCALIZATION_PROPERTY_FILE", propertyFile.getFileName());
                        DomainStorageException dse = new DomainStorageException(message, null);
                        throw dse;
                    }
                    locale = this.getLocaleFromPropertyFilename(propertyFile.getFileName(), propertiesFileNamePrefix);
                    if (this.logger.isDebugEnabled()) {
                        List messages = localizationUtil.analyzeImport(domain, properties, locale);
                        for (String message : messages) {
                            this.logger.debug((Object)message);
                        }
                    }
                    localizationUtil.importLocalizedProperties(domain, properties, locale);
                }
                catch (FileNotFoundException fnfe) {
                    throw new DomainStorageException(Messages.getErrorString("MetadataDomainRepository.ERROR_0009_EXCEPTION_READING_LOCALIZATION_PROPERTY_FILE", propertyFile.getFileName()), (Exception)fnfe);
                }
                catch (IOException ioe) {
                    throw new DomainStorageException(Messages.getErrorString("MetadataDomainRepository.ERROR_0009_EXCEPTION_READING_LOCALIZATION_PROPERTY_FILE", propertyFile.getFileName()), (Exception)ioe);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        throw new DomainStorageException(Messages.getErrorString("MetadataDomainRepository.ERROR_0009_EXCEPTION_READING_LOCALIZATION_PROPERTY_FILE", propertyFile.getFileName()), (Exception)ioe);
                    }
                }
            }
        }
    }

    protected String getPropertiesFilePrefix(String filename) throws DomainStorageException {
        int endIndex;
        int beginIndex = filename.lastIndexOf(47);
        if (beginIndex > 0) {
            ++beginIndex;
        }
        if ((endIndex = filename.indexOf(".xmi")) == 0) {
            return filename.substring(endIndex);
        }
        if (beginIndex >= endIndex) {
            throw new DomainStorageException(Messages.getErrorString("MetadataDomainRepository.ERROR_0011_FAILED_TO_RESOLVE_PREFIX_FOR_PROPERTY_FILE", filename), null);
        }
        return filename.substring(beginIndex, endIndex);
    }

    private class PropertyFilesFilter
    implements IFileFilter {
        private String propertiesFilePrefix = null;

        public PropertyFilesFilter(String propertiesFilePrefix) {
            this.propertiesFilePrefix = propertiesFilePrefix + "_";
        }

        public boolean accept(ISolutionFile iSolutionfile) {
            return iSolutionfile.getFileName().startsWith(this.propertiesFilePrefix) && iSolutionfile.getFileName().endsWith(PROPERTIES_FILE_EXTENSION);
        }
    }
}

