/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.util.ArrayList;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.security.RowLevelSecurity;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.plugin.services.metadata.MetadataAclHolder;
import org.pentaho.platform.plugin.services.metadata.MetadataDomainRepository;
import org.pentaho.platform.plugin.services.metadata.SessionAwareRowLevelSecurityHelper;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;

public class SecurityAwareMetadataDomainRepository
extends MetadataDomainRepository {
    public String generateRowLevelSecurityConstraint(LogicalModel model) {
        RowLevelSecurity rls = model.getRowLevelSecurity();
        if (rls == null || rls.getType() == RowLevelSecurity.Type.NONE) {
            return null;
        }
        Authentication auth = SecurityHelper.getAuthentication((IPentahoSession)this.getSession(), (boolean)true);
        if (auth == null) {
            this.logger.info((Object)Messages.getString((String)"SecurityAwareCwmSchemaFactory.INFO_AUTH_NULL_CONTINUE"));
            return "FALSE()";
        }
        String username = auth.getName();
        ArrayList<String> roles = new ArrayList<String>();
        for (GrantedAuthority role : auth.getAuthorities()) {
            roles.add(role.getAuthority());
        }
        SessionAwareRowLevelSecurityHelper helper = new SessionAwareRowLevelSecurityHelper();
        return helper.getOpenFormulaSecurityConstraint(rls, username, roles);
    }

    public boolean hasAccess(int accessType, IConcept aclHolder) {
        if (aclHolder != null) {
            MetadataAclHolder newHolder = new MetadataAclHolder(aclHolder);
            int mappedActionOperation = ACCESS_TYPE_MAP[accessType];
            return SecurityHelper.hasAccess((IAclHolder)newHolder, (int)mappedActionOperation, (IPentahoSession)this.getSession());
        }
        if (accessType == 5) {
            return SecurityHelper.isPentahoAdministrator((IPentahoSession)this.getSession());
        }
        return true;
    }
}

