/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.util.RowLevelSecurityHelper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.plugin.services.metadata.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAwareRowLevelSecurityHelper
extends RowLevelSecurityHelper {
    protected final Log logger = LogFactory.getLog(SessionAwareRowLevelSecurityHelper.class);

    protected String expandFunctions(String formula, String user, List<String> roles) {
        formula = super.expandFunctions(formula, user, roles);
        IPentahoSession session = PentahoSessionHolder.getSession();
        Pattern p = Pattern.compile("SESSION\\(\"(.*?)\"\\)");
        Matcher m = p.matcher(formula);
        StringBuffer sb = new StringBuffer(formula.length());
        while (m.find()) {
            String text = m.group(1);
            String value = null;
            if (session.getAttribute(text) == null) {
                this.logger.warn((Object)Messages.getString("SessionAwareRowLevelSecurityHelper.WARN_0001_NULL_ATTRIBUTE", text, user));
                return "FALSE()";
            }
            value = session.getAttribute(text).toString();
            m.appendReplacement(sb, Matcher.quoteReplacement(value.replaceAll("\"", "\"\"")));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

