/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionCachingMetadataDomainRepository
implements IMetadataDomainRepository,
ILogoutListener {
    private static final Log logger = LogFactory.getLog(SessionCachingMetadataDomainRepository.class);
    public static String CACHE_REGION = "metadata-domain-repository";
    private ICacheManager cacheManager;
    private IMetadataDomainRepository delegate;
    protected final CacheIteratorCallback REMOVE_ALL_CALLBACK = new CacheIteratorCallback(){

        public Boolean call(ICacheManager cacheManager, CacheKey key) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing domain from cache: " + key));
            }
            cacheManager.removeFromRegionCache(CACHE_REGION, (Object)key);
            return true;
        }
    };

    public SessionCachingMetadataDomainRepository(IMetadataDomainRepository delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.cacheManager = PentahoSystem.getCacheManager(null);
        if (this.cacheManager != null && !this.cacheManager.cacheEnabled(CACHE_REGION) && !this.cacheManager.addCacheRegion(CACHE_REGION)) {
            this.cacheManager = null;
        }
        if (this.cacheManager == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " (" + CACHE_REGION + ") cannot be initialized");
        }
        PentahoSystem.addLogoutListener((ILogoutListener)this);
    }

    protected void forAllKeys(CacheIteratorCallback callback) {
        block4: {
            try {
                Set cachedObjects = this.cacheManager.getAllKeysFromRegionCache(CACHE_REGION);
                if (cachedObjects != null) {
                    CacheKey key;
                    Object k;
                    Iterator i$ = cachedObjects.iterator();
                    while (!(!i$.hasNext() || (k = i$.next()) instanceof CacheKey && Boolean.FALSE.equals(callback.call(this.cacheManager, key = (CacheKey)k)))) {
                    }
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"", e);
            }
        }
    }

    protected void forAllKeysInSession(final IPentahoSession session, final CacheIteratorCallback callback) {
        this.forAllKeys(new CacheIteratorCallback(){

            public Boolean call(ICacheManager cacheManager, CacheKey key) {
                if ((session.getId() == null ? key.sessionId == null : session.getId().equals(key.sessionId)) && Boolean.FALSE.equals(callback.call(cacheManager, key))) {
                    return false;
                }
                return true;
            }
        });
    }

    public Domain getDomain(String id) {
        IPentahoSession session = PentahoSessionHolder.getSession();
        CacheKey key = new CacheKey(session.getId(), id);
        Domain domain = (Domain)this.cacheManager.getFromRegionCache(CACHE_REGION, (Object)key);
        if (domain != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found domain in cache: " + key));
            }
            return domain;
        }
        domain = this.delegate.getDomain(id);
        if (domain != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching domain by session: " + key));
            }
            this.cacheManager.putInRegionCache(CACHE_REGION, (Object)key, (Object)domain);
        }
        return domain;
    }

    private void purgeDomain(final String domainId) {
        this.forAllKeys(new CacheIteratorCallback(){

            public Boolean call(ICacheManager cacheManager, CacheKey key) {
                if (domainId == null ? key.domainId == null : domainId.equals(key.domainId)) {
                    cacheManager.removeFromRegionCache(CACHE_REGION, (Object)key);
                }
                return true;
            }
        });
    }

    public void reloadDomains() {
        this.forAllKeys(this.REMOVE_ALL_CALLBACK);
        this.delegate.reloadDomains();
    }

    public void flushDomains() {
        this.forAllKeys(this.REMOVE_ALL_CALLBACK);
        this.delegate.flushDomains();
    }

    protected void flushDomains(IPentahoSession session) {
        this.forAllKeysInSession(session, this.REMOVE_ALL_CALLBACK);
    }

    public void removeDomain(String domainId) {
        this.delegate.removeDomain(domainId);
        this.purgeDomain(domainId);
    }

    public void storeDomain(Domain domain, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        this.delegate.storeDomain(domain, overwrite);
        this.purgeDomain(domain.getId());
    }

    public void removeModel(String domainId, String modelId) throws DomainIdNullException, DomainStorageException {
        this.delegate.removeModel(domainId, modelId);
        this.purgeDomain(domainId);
    }

    public Set<String> getDomainIds() {
        return this.delegate.getDomainIds();
    }

    public String generateRowLevelSecurityConstraint(LogicalModel model) {
        return this.delegate.generateRowLevelSecurityConstraint(model);
    }

    public boolean hasAccess(int accessType, IConcept aclHolder) {
        return this.delegate.hasAccess(accessType, aclHolder);
    }

    public void onLogout(IPentahoSession session) {
        this.flushDomains(session);
    }

    protected static interface CacheIteratorCallback {
        public Boolean call(ICacheManager var1, CacheKey var2);
    }

    public static class CacheKey {
        public String sessionId;
        public String domainId;

        public CacheKey(String sessionId, String domainId) {
            this.sessionId = sessionId;
            this.domainId = domainId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.domainId != null ? !this.domainId.equals(cacheKey.domainId) : cacheKey.domainId != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(cacheKey.sessionId) : cacheKey.sessionId != null);
        }

        public int hashCode() {
            int result = this.sessionId != null ? this.sessionId.hashCode() : 0;
            result = 31 * result + (this.domainId != null ? this.domainId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "(" + this.sessionId + "," + this.domainId + ")";
        }
    }
}

