/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IContentGeneratorInfo;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.objfac.StandaloneObjectFactory;
import org.pentaho.ui.xul.IMenuCustomization;
import org.pentaho.ui.xul.XulOverlay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluginManager
implements IPluginManager {
    protected StandaloneObjectFactory objectFactory = new StandaloneObjectFactory();
    protected Map<String, IPlatformPlugin> registeredPlugins = new Hashtable<String, IPlatformPlugin>();
    protected Map<String, List<IContentGeneratorInfo>> contentGeneratorInfoByTypeMap = Collections.synchronizedMap(new HashMap());
    protected Map<String, IContentGeneratorInfo> contentGeneratorInfoByIdMap = Collections.synchronizedMap(new HashMap());
    protected Map<String, IContentInfo> contentTypeByExtension = Collections.synchronizedMap(new HashMap());
    protected List<XulOverlay> overlaysCache = Collections.synchronizedList(new ArrayList());
    protected List<IMenuCustomization> menuCustomizationsCache = Collections.synchronizedList(new ArrayList());

    public Set<String> getContentTypes() {
        return Collections.unmodifiableSet(this.contentTypeByExtension.keySet());
    }

    public List<XulOverlay> getOverlays() {
        return Collections.unmodifiableList(this.overlaysCache);
    }

    public IContentInfo getContentInfoFromExtension(String extension, IPentahoSession session) {
        return this.contentTypeByExtension.get(extension);
    }

    public List<IContentGeneratorInfo> getContentGeneratorInfoForType(String type, IPentahoSession session) {
        List<IContentGeneratorInfo> cgInfos = this.contentGeneratorInfoByTypeMap.get(type);
        return cgInfos == null ? null : Collections.unmodifiableList(this.contentGeneratorInfoByTypeMap.get(type));
    }

    public IContentGenerator getContentGenerator(String id, IPentahoSession session) throws ObjectFactoryException {
        IContentGeneratorInfo info = this.getContentGeneratorInfo(id, session);
        if (info == null) {
            return null;
        }
        return (IContentGenerator)this.objectFactory.get(IContentGenerator.class, id, session);
    }

    public IContentGeneratorInfo getContentGeneratorInfo(String id, IPentahoSession session) {
        IContentGeneratorInfo contentId = this.contentGeneratorInfoByIdMap.get(id);
        return contentId;
    }

    public IContentGeneratorInfo getDefaultContentGeneratorInfoForType(String type, IPentahoSession session) {
        List<IContentGeneratorInfo> contentIds = this.contentGeneratorInfoByTypeMap.get(type);
        if (!CollectionUtils.isEmpty(contentIds)) {
            IContentGeneratorInfo info = contentIds.get(0);
            return info;
        }
        return null;
    }

    public String getContentGeneratorIdForType(String type, IPentahoSession session) {
        List<IContentGeneratorInfo> contentIds = this.contentGeneratorInfoByTypeMap.get(type);
        if (!CollectionUtils.isEmpty(contentIds)) {
            IContentGeneratorInfo info = contentIds.get(0);
            return info.getId();
        }
        return null;
    }

    public String getContentGeneratorTitleForType(String type, IPentahoSession session) {
        List<IContentGeneratorInfo> contentIds = this.contentGeneratorInfoByTypeMap.get(type);
        if (!CollectionUtils.isEmpty(contentIds)) {
            IContentGeneratorInfo info = contentIds.get(0);
            return info.getTitle();
        }
        return null;
    }

    public String getContentGeneratorUrlForType(String type, IPentahoSession session) {
        List<IContentGeneratorInfo> contentIds = this.contentGeneratorInfoByTypeMap.get(type);
        if (!CollectionUtils.isEmpty(contentIds)) {
            IContentGeneratorInfo info = contentIds.get(0);
            return info.getUrl();
        }
        return null;
    }

    public IContentGenerator getContentGeneratorForType(String type, IPentahoSession session) throws ObjectFactoryException {
        List<IContentGeneratorInfo> contentGenerators = this.contentGeneratorInfoByTypeMap.get(type);
        if (!CollectionUtils.isEmpty(contentGenerators)) {
            String id = contentGenerators.get(0).getId();
            return (IContentGenerator)this.objectFactory.get(IContentGenerator.class, id, session);
        }
        return null;
    }

    public List<IMenuCustomization> getMenuCustomizations() {
        return Collections.unmodifiableList(this.menuCustomizationsCache);
    }

    public List<String> getRegisteredPlugins() {
        ArrayList<String> pluginIds = new ArrayList<String>(this.registeredPlugins.size());
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            pluginIds.add(plugin.getId());
        }
        return pluginIds;
    }

    public List<String> getExternalResourcesForContext(String context) {
        ArrayList<String> resources = new ArrayList<String>();
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            List pluginRes = plugin.getExternalResourcesForContext(context);
            if (pluginRes == null) continue;
            resources.addAll(pluginRes);
        }
        return resources;
    }
}

