/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.ui.IMenuProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.ui.xul.IMenuCustomization;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.containers.XulMenubar;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.util.MenuUtil;

public abstract class BaseMenuProvider
implements IMenuProvider {
    public abstract Object getMenuBar(String var1, String var2, IPentahoSession var3);

    public abstract Object getPopupMenu(String var1, String var2, IPentahoSession var3);

    protected abstract XulLoader getXulLoader();

    protected XulDomContainer getXulContainer(String documentPath, IPentahoSession session) {
        try {
            ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            InputStream in = repo.getResourceInputStream(documentPath, true, 1);
            SAXReader rdr = new SAXReader();
            Document doc = rdr.read(in);
            XulDomContainer container = this.getXulLoader().loadXul((Object)doc);
            return container;
        }
        catch (Exception e) {
            session.error(Messages.getErrorString("BaseMenuProvider.ERROR_0001_COULD_NOT_GET_MENU_CONTAINER"), (Throwable)e);
            return null;
        }
    }

    protected XulMenubar getXulMenubar(String id, String documentPath, IPentahoSession session) {
        XulDomContainer container = this.getXulContainer(documentPath, session);
        if (container == null) {
            return null;
        }
        List components = container.getDocumentRoot().getElementsByTagName("menubar");
        for (XulComponent component : components) {
            if (!(component instanceof XulMenubar) || !component.getId().equals(id)) continue;
            XulMenubar menubar = (XulMenubar)component;
            IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)session);
            List menuCustomizations = pluginManager.getMenuCustomizations();
            for (Object custom : menuCustomizations) {
                if (!(custom instanceof IMenuCustomization)) continue;
                IMenuCustomization item = (IMenuCustomization)custom;
                try {
                    MenuUtil.customizeMenu((XulMenubar)menubar, (IMenuCustomization)item, (XulLoader)this.getXulLoader());
                }
                catch (Exception e) {
                    session.error(Messages.getString("BaseMenuProvider.ERROR_0004_COULD_NOT_CUSTOMIZE_MENU", item.getId(), item.getLabel()), (Throwable)e);
                }
            }
            return menubar;
        }
        Logger.error((String)this.getClass().getName(), (String)Messages.getErrorString("BaseMenuProvider.ERROR_0002_COULD_NOT_GET_MENUBAR"));
        return null;
    }

    protected XulMenupopup getXulPopupMenu(String id, String documentPath, IPentahoSession session) {
        XulDomContainer container = this.getXulContainer(documentPath, session);
        if (container != null) {
            List components = container.getDocumentRoot().getElementsByTagName("menupopup");
            for (XulComponent component : components) {
                if (!component.getId().equals(id) || !(component instanceof XulMenupopup)) continue;
                return (XulMenupopup)component;
            }
        }
        Logger.error((String)this.getClass().getName(), (String)Messages.getErrorString("BaseMenuProvider.ERROR_0003_COULD_NOT_GET_POPUP_MENU"));
        return null;
    }
}

