/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IContentGeneratorInfo;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.IFileInfoGenerator;
import org.pentaho.platform.api.engine.IPentahoDefinableObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.IPluginLifecycleListener;
import org.pentaho.platform.api.engine.IPluginProvider;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFileMetaProvider;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PlatformPluginRegistrationException;
import org.pentaho.platform.api.engine.PluginBeanDefinition;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.api.engine.PluginLifecycleException;
import org.pentaho.platform.api.engine.PluginServiceDefinition;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.api.engine.ServiceInitializationException;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.FileInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.pluginmgr.AbstractPluginManager;
import org.pentaho.platform.plugin.services.pluginmgr.PlatformPlugin;
import org.pentaho.platform.plugin.services.pluginmgr.PluginClassLoader;
import org.pentaho.platform.plugin.services.pluginmgr.PluginMessageLogger;
import org.pentaho.platform.plugin.services.pluginmgr.servicemgr.ServiceConfig;
import org.pentaho.platform.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginManager
extends AbstractPluginManager {
    private static final String METAPROVIDER_KEY_PREFIX = "METAPROVIDER-";
    private Map<String, ClassLoader> classLoaderMap = Collections.synchronizedMap(new HashMap());

    private void unloadPlugins() {
        this.overlaysCache.clear();
        this.menuCustomizationsCache.clear();
        this.classLoaderMap.clear();
        this.contentGeneratorInfoByIdMap.clear();
        this.contentGeneratorInfoByTypeMap.clear();
        this.contentTypeByExtension.clear();
        this.objectFactory.init(null, null);
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            try {
                plugin.unLoaded();
            }
            catch (Throwable t) {
                String msg = Messages.getErrorString("PluginManager.ERROR_0014_PLUGIN_FAILED_TO_PROPERLY_UNLOAD", plugin.getId());
                Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                PluginMessageLogger.add(msg);
            }
        }
        this.registeredPlugins.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean reload(IPentahoSession session) {
        boolean anyErrors = false;
        IPluginProvider pluginProvider = (IPluginProvider)PentahoSystem.get(IPluginProvider.class, (IPentahoSession)session);
        List providedPlugins = null;
        try {
            Map map = this.registeredPlugins;
            synchronized (map) {
                this.unloadPlugins();
            }
            providedPlugins = pluginProvider.getPlugins(session);
        }
        catch (PlatformPluginRegistrationException e1) {
            String msg = Messages.getErrorString("PluginManager.ERROR_0012_PLUGIN_DISCOVERY_FAILED");
            Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)e1);
            PluginMessageLogger.add(msg);
            anyErrors = true;
        }
        this.objectFactory.init(null, null);
        List e1 = providedPlugins;
        synchronized (e1) {
            for (IPlatformPlugin plugin : providedPlugins) {
                try {
                    this.registerPlugin(plugin, session);
                    this.registeredPlugins.put(plugin.getId(), plugin);
                }
                catch (Throwable t) {
                    anyErrors = true;
                    String msg = Messages.getErrorString("PluginManager.ERROR_0011_FAILED_TO_REGISTER_PLUGIN", plugin.getId());
                    Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                    PluginMessageLogger.add(msg);
                }
            }
        }
        IServiceManager svcManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, null);
        try {
            svcManager.initServices();
        }
        catch (ServiceInitializationException e) {
            String msg = Messages.getErrorString("PluginManager.ERROR_0022_SERVICE_INITIALIZATION_FAILED");
            Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)e);
            PluginMessageLogger.add(msg);
        }
        return !anyErrors;
    }

    private static void bootStrapPlugin(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        Object listener = null;
        try {
            if (!StringUtils.isEmpty((String)plugin.getLifecycleListenerClassname())) {
                listener = loader.loadClass(plugin.getLifecycleListenerClassname()).newInstance();
            }
        }
        catch (Throwable t) {
            throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0017_COULD_NOT_LOAD_PLUGIN_LIFECYCLE_LISTENER", plugin.getId(), plugin.getLifecycleListenerClassname()), t);
        }
        if (listener != null) {
            if (!IPluginLifecycleListener.class.isAssignableFrom(listener.getClass())) {
                throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0016_PLUGIN_LIFECYCLE_LISTENER_WRONG_TYPE", plugin.getId(), plugin.getLifecycleListenerClassname()));
            }
            plugin.addLifecycleListener((IPluginLifecycleListener)listener);
        }
    }

    private void registerPlugin(IPlatformPlugin plugin, IPentahoSession session) throws PlatformPluginRegistrationException, PluginLifecycleException {
        if (StringUtils.isEmpty((String)plugin.getId())) {
            throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0026_PLUGIN_INVALID", plugin.getSourceDescription()));
        }
        if (this.registeredPlugins.containsKey(plugin.getId())) {
            throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0024_PLUGIN_ALREADY_LOADED_BY_SAME_NAME", plugin.getId()));
        }
        ClassLoader loader = this.setPluginClassLoader(plugin);
        DefaultPluginManager.bootStrapPlugin(plugin, loader);
        plugin.init();
        this.registerContentTypes(plugin, loader);
        this.registerContentGenerators(plugin, loader);
        this.overlaysCache.addAll(plugin.getOverlays());
        this.menuCustomizationsCache.addAll(plugin.getMenuCustomizations());
        this.registerBeans(plugin, loader, session);
        this.registerServices(plugin, loader);
        PluginMessageLogger.add(Messages.getString("PluginManager.PLUGIN_REGISTERED", plugin.getId()));
        try {
            plugin.loaded();
        }
        catch (Throwable t) {
            String msg = Messages.getErrorString("PluginManager.ERROR_0015_PLUGIN_LOADED_HANDLING_FAILED", plugin.getId());
            Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
            PluginMessageLogger.add(msg);
        }
    }

    private void registerContentTypes(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        for (IContentInfo info : plugin.getContentInfos()) {
            this.contentTypeByExtension.put(info.getExtension(), info);
            String metaProviderClass = (String)plugin.getMetaProviderMap().get(info.getExtension());
            if (StringUtils.isEmpty((String)metaProviderClass)) continue;
            Class<?> clazz = null;
            String defaultErrMsg = Messages.getErrorString("PluginManager.ERROR_0013_FAILED_TO_SET_CONTENT_TYPE_META_PROVIDER", metaProviderClass, info.getExtension());
            try {
                clazz = loader.loadClass(metaProviderClass);
            }
            catch (Exception e) {
                throw new PlatformPluginRegistrationException(defaultErrMsg, (Throwable)e);
            }
            if (!ISolutionFileMetaProvider.class.isAssignableFrom(clazz) && !IFileInfoGenerator.class.isAssignableFrom(clazz)) {
                throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0019_WRONG_TYPE_FOR_CONTENT_TYPE_META_PROVIDER", metaProviderClass, info.getExtension()));
            }
            this.objectFactory.defineObject(METAPROVIDER_KEY_PREFIX + info.getExtension(), metaProviderClass, IPentahoDefinableObjectFactory.Scope.LOCAL, loader);
            try {
                this.objectFactory.get(Object.class, METAPROVIDER_KEY_PREFIX + info.getExtension(), null);
            }
            catch (Exception e) {
                throw new PlatformPluginRegistrationException(defaultErrMsg, (Throwable)e);
            }
        }
    }

    private void registerBeans(IPlatformPlugin plugin, ClassLoader loader, IPentahoSession session) throws PlatformPluginRegistrationException {
        Iterator i$ = plugin.getBeans().iterator();
        while (i$.hasNext()) {
            PluginBeanDefinition def;
            def.setBeanId((def = (PluginBeanDefinition)i$.next()).getBeanId() == null ? def.getClassname() : def.getBeanId());
            this.registerClass(plugin, def.getBeanId(), def.getClassname(), loader);
        }
    }

    private void registerClass(IPlatformPlugin plugin, String id, String classname, ClassLoader loader) throws PlatformPluginRegistrationException {
        if (this.objectFactory.objectDefined(id)) {
            throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0018_BEAN_ALREADY_REGISTERED", id, plugin.getId()));
        }
        this.objectFactory.defineObject(id, classname, IPentahoDefinableObjectFactory.Scope.LOCAL, loader);
    }

    private void registerServices(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        IServiceManager svcManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, null);
        for (PluginServiceDefinition pws : plugin.getServices()) {
            for (ServiceConfig ws : this.createServiceConfigs(pws, plugin, loader)) {
                try {
                    svcManager.registerService((IServiceConfig)ws);
                }
                catch (ServiceException e) {
                    throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0025_SERVICE_REGISTRATION_FAILED", ws.getId(), plugin.getId()), (Throwable)e);
                }
            }
        }
    }

    private Collection<ServiceConfig> createServiceConfigs(PluginServiceDefinition pws, IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        ArrayList<ServiceConfig> services = new ArrayList<ServiceConfig>();
        if (pws.getTypes() == null || pws.getTypes().length < 1) {
            throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0023_SERVICE_TYPE_UNSPECIFIED", pws.getId()));
        }
        for (String type : pws.getTypes()) {
            String serviceId;
            String serviceClassName;
            ServiceConfig ws = new ServiceConfig();
            ws.setServiceType(type);
            ws.setTitle(pws.getTitle());
            ws.setDescription(pws.getDescription());
            String string = serviceClassName = StringUtils.isEmpty((String)pws.getServiceClass()) ? pws.getServiceBeanId() : pws.getServiceClass();
            if (!StringUtils.isEmpty((String)pws.getId())) {
                serviceId = pws.getId();
            } else {
                serviceId = serviceClassName;
                if (serviceClassName.indexOf(46) > 0) {
                    serviceId = serviceClassName.substring(serviceClassName.lastIndexOf(46) + 1);
                }
            }
            ws.setId(serviceId);
            String serviceClassKey = ws.getServiceType() + "-" + ws.getId() + "/" + serviceClassName;
            this.registerClass(plugin, serviceClassKey, serviceClassName, loader);
            if (!this.isBeanRegistered(serviceClassKey)) {
                throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0020_NO_SERVICE_CLASS_REGISTERED", serviceClassKey));
            }
            try {
                ws.setServiceClass(this.loadClass(serviceClassKey));
                ArrayList classes = new ArrayList();
                if (pws.getExtraClasses() != null) {
                    for (String extraClass : pws.getExtraClasses()) {
                        classes.add(this.loadClass(extraClass));
                    }
                }
                ws.setExtraClasses(classes);
            }
            catch (PluginBeanException e) {
                throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0021_SERVICE_CLASS_LOAD_FAILED", serviceClassKey), (Throwable)e);
            }
            services.add(ws);
        }
        return services;
    }

    private ClassLoader setPluginClassLoader(IPlatformPlugin plugin) throws PlatformPluginRegistrationException {
        ClassLoader loader = this.classLoaderMap.get(plugin.getId());
        if (loader == null) {
            String pluginDirPath = PentahoSystem.getApplicationContext().getSolutionPath("system/" + plugin.getSourceDescription());
            pluginDirPath = pluginDirPath.replace("//", "/");
            Logger.debug((Object)this, (String)("plugin dir for " + plugin.getId() + " is [" + pluginDirPath + "]"));
            File pluginDir = new File(pluginDirPath);
            if (!(pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canRead())) {
                throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0027_PLUGIN_DIR_UNAVAILABLE", pluginDir.getAbsolutePath()));
            }
            loader = new PluginClassLoader(pluginDir, this.getClass().getClassLoader());
            if (plugin.getLoaderType() == IPlatformPlugin.ClassLoaderType.OVERRIDING) {
                ((PluginClassLoader)loader).setOverrideLoad(true);
            }
            this.classLoaderMap.put(plugin.getId(), loader);
        }
        return loader;
    }

    public ClassLoader getClassLoader(IPlatformPlugin plugin) {
        return this.getClassLoader(plugin.getId());
    }

    public ClassLoader getClassLoader(String pluginId) {
        return this.classLoaderMap.get(pluginId);
    }

    private void registerContentGenerators(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        for (IContentGeneratorInfo cgInfo : plugin.getContentGenerators()) {
            Object tmpObject;
            String errorMsg = Messages.getString("PluginManager.USER_CONTENT_GENERATOR_NOT_REGISTERED", cgInfo.getId(), plugin.getId());
            try {
                Class<?> clazz = Class.forName(cgInfo.getClassname(), false, loader);
                this.objectFactory.defineObject(clazz.getSimpleName(), cgInfo.getClassname(), IPentahoDefinableObjectFactory.Scope.LOCAL, loader);
                this.objectFactory.defineObject(cgInfo.getId(), cgInfo.getClassname(), IPentahoDefinableObjectFactory.Scope.LOCAL, loader);
            }
            catch (Exception e) {
                throw new PlatformPluginRegistrationException(errorMsg, (Throwable)e);
            }
            try {
                tmpObject = this.objectFactory.get(Object.class, cgInfo.getId(), null);
            }
            catch (ObjectFactoryException e) {
                throw new PlatformPluginRegistrationException(errorMsg, (Throwable)e);
            }
            IContentGenerator cg = (IContentGenerator)tmpObject;
            if (cgInfo.getFileInfoGeneratorClassname() != null) {
                try {
                    this.objectFactory.defineObject(cgInfo.getType(), cgInfo.getFileInfoGeneratorClassname(), IPentahoDefinableObjectFactory.Scope.LOCAL, loader);
                }
                catch (Exception e) {
                    throw new PlatformPluginRegistrationException(Messages.getErrorString("PluginManager.ERROR_0013_FAILED_TO_CREATE_FILE_INFO_GENERATOR", cgInfo.getFileInfoGeneratorClassname(), cgInfo.getType()), (Throwable)e);
                }
            }
            this.contentGeneratorInfoByIdMap.put(cgInfo.getId(), cgInfo);
            ArrayList<IContentGeneratorInfo> generatorList = (ArrayList<IContentGeneratorInfo>)this.contentGeneratorInfoByTypeMap.get(cgInfo.getType());
            if (generatorList == null) {
                generatorList = new ArrayList<IContentGeneratorInfo>();
                this.contentGeneratorInfoByTypeMap.put(cgInfo.getType(), generatorList);
            }
            generatorList.add(cgInfo);
            PluginMessageLogger.add(Messages.getString("PluginManager.USER_CONTENT_GENERATOR_REGISTERED", cgInfo.getId(), plugin.getId()));
        }
    }

    public IPentahoObjectFactory getBeanFactory() {
        return this.objectFactory;
    }

    public Object getBean(String beanId) throws PluginBeanException {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        if (this.objectFactory.objectDefined(beanId)) {
            Object bean = null;
            try {
                bean = this.objectFactory.get(Object.class, beanId, null);
                return bean;
            }
            catch (Throwable ex) {
                throw new PluginBeanException(ex);
            }
        }
        throw new PluginBeanException(Messages.getString("PluginManager.WARN_CLASS_NOT_REGISTERED"));
    }

    public Class<?> loadClass(String beanId) throws PluginBeanException {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        if (this.objectFactory.objectDefined(beanId)) {
            try {
                return this.objectFactory.getImplementingClass(beanId);
            }
            catch (Throwable ex) {
                throw new PluginBeanException(ex);
            }
        }
        throw new PluginBeanException(Messages.getString("PluginManager.WARN_CLASS_NOT_REGISTERED", beanId));
    }

    public boolean isBeanRegistered(String beanId) {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        return this.objectFactory.objectDefined(beanId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAllPlugins() {
        Map map = this.registeredPlugins;
        synchronized (map) {
            this.unloadPlugins();
        }
    }

    public IFileInfo getFileInfo(String extension, IPentahoSession session, ISolutionFile solutionFile, InputStream in) {
        FileInfo fileInfo = null;
        String objectKey = METAPROVIDER_KEY_PREFIX + extension;
        try {
            Object metaProvider = null;
            if (this.objectFactory.objectDefined(objectKey)) {
                metaProvider = this.objectFactory.get(Object.class, objectKey, null);
            }
            if (metaProvider instanceof ISolutionFileMetaProvider) {
                ISolutionFileMetaProvider provider = (ISolutionFileMetaProvider)metaProvider;
                fileInfo = provider.getFileInfo(solutionFile, in);
            } else {
                fileInfo = DefaultPluginManager.getLegacyFileInfo((IFileInfoGenerator)metaProvider, session, solutionFile);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            fileInfo = null;
        }
        if (fileInfo == null) {
            fileInfo = new FileInfo();
            fileInfo.setTitle(solutionFile.getFileName());
            fileInfo.setDescription("failsafe: " + solutionFile.getFullPath());
            fileInfo.setDisplayType(solutionFile.getExtension());
        }
        return fileInfo;
    }

    private static IFileInfo getLegacyFileInfo(IFileInfoGenerator fileInfoGenerator, IPentahoSession session, ISolutionFile solutionFile) {
        IFileInfo fileInfo = null;
        try {
            String fullPath = solutionFile.getFullPath();
            String solution = solutionFile.getSolution();
            String fileName = solutionFile.getFileName();
            String path = solutionFile.getSolutionPath();
            IFileInfoGenerator.ContentType contentType = fileInfoGenerator.getContentType();
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            if (contentType == IFileInfoGenerator.ContentType.INPUTSTREAM) {
                InputStream in = repository.getResourceInputStream(fullPath, true, 1);
                fileInfo = fileInfoGenerator.getFileInfo(solution, path, fileName, in);
            } else if (contentType == IFileInfoGenerator.ContentType.DOM4JDOC) {
                Document doc = repository.getResourceAsDocument(fullPath, 1);
                fileInfo = fileInfoGenerator.getFileInfo(solution, path, fileName, doc);
            } else if (contentType == IFileInfoGenerator.ContentType.BYTES) {
                byte[] bytes = repository.getResourceAsBytes(fullPath, true, 1);
                fileInfo = fileInfoGenerator.getFileInfo(solution, path, fileName, bytes);
            } else if (contentType == IFileInfoGenerator.ContentType.STRING) {
                String str = repository.getResourceAsString(fullPath, 1);
                fileInfo = fileInfoGenerator.getFileInfo(solution, path, fileName, str);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return fileInfo;
    }

    public Object getPluginSetting(IPlatformPlugin plugin, String key, String defaultValue) {
        return this.getPluginSetting(plugin.getId(), key, defaultValue);
    }

    public Object getPluginSetting(String pluginId, String key, String defaultValue) {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        ClassLoader classLoader = this.classLoaderMap.get(pluginId);
        return resLoader.getPluginSetting(classLoader, key, defaultValue);
    }

    public IPlatformPlugin isResourceLoadable(String path) {
        PlatformPlugin p = new PlatformPlugin();
        p.setId(this.getServicePlugin(path));
        return p;
    }

    private String trimLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    protected boolean isRequested(String servicePath, String requestPath) {
        String[] servicePathElements;
        String[] requestPathElements = this.trimLeadingSlash(requestPath).split("/");
        if (requestPathElements.length < (servicePathElements = this.trimLeadingSlash(servicePath).split("/")).length) {
            return false;
        }
        for (int i = 0; i < servicePathElements.length; ++i) {
            if (requestPathElements[i].equals(servicePathElements[i])) continue;
            return false;
        }
        return true;
    }

    public String getServicePlugin(String path) {
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            String pluginId = this.getStaticResourcePluginId(plugin, path);
            if (pluginId != null) {
                return pluginId;
            }
            for (IContentGeneratorInfo contentGenerator : plugin.getContentGenerators()) {
                String cgId = contentGenerator.getId();
                if (!this.isRequested(cgId, path)) continue;
                return plugin.getId();
            }
        }
        return null;
    }

    private String getStaticResourcePluginId(IPlatformPlugin plugin, String path) {
        Map resourceMap = plugin.getStaticResourceMap();
        for (String url : resourceMap.keySet()) {
            if (!this.isRequested(url, path)) continue;
            return plugin.getId();
        }
        return null;
    }

    public boolean isStaticResource(String path) {
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            String pluginId = this.getStaticResourcePluginId(plugin, path);
            if (pluginId == null) continue;
            return true;
        }
        return false;
    }

    public InputStream getStaticResource(String path) {
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            Map resourceMap = plugin.getStaticResourceMap();
            for (String url : resourceMap.keySet()) {
                if (!this.isRequested(url, path)) continue;
                IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
                ClassLoader classLoader = this.classLoaderMap.get(plugin.getId());
                String resourcePath = path.replace(url, (CharSequence)resourceMap.get(url));
                return resLoader.getResourceAsStream(classLoader, resourcePath);
            }
        }
        return null;
    }
}

