/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.engine.IContentGeneratorInfo;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.IPluginLifecycleListener;
import org.pentaho.platform.api.engine.PluginBeanDefinition;
import org.pentaho.platform.api.engine.PluginLifecycleException;
import org.pentaho.platform.api.engine.PluginServiceDefinition;
import org.pentaho.ui.xul.IMenuCustomization;
import org.pentaho.ui.xul.XulOverlay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformPlugin
implements IPlatformPlugin,
IPentahoInitializer {
    private List<IContentGeneratorInfo> contentGenerators = new ArrayList<IContentGeneratorInfo>();
    private List<IContentInfo> contentInfos = new ArrayList<IContentInfo>();
    private List<XulOverlay> overlays = new ArrayList<XulOverlay>();
    private Collection<PluginBeanDefinition> beanDefinitions = new ArrayList<PluginBeanDefinition>();
    private Collection<PluginServiceDefinition> webserviceDefinitions = new ArrayList<PluginServiceDefinition>();
    private List<IPentahoInitializer> initializers = new ArrayList<IPentahoInitializer>();
    private Map<String, String> staticResourceMap = new HashMap<String, String>();
    private Map<String, String> metaProviderMap = new HashMap<String, String>();
    private List menuOverlays = new ArrayList();
    private String id;
    private String sourceDescription = "";
    private String lifecycleListenerClassname;
    private IPluginLifecycleListener lifecycleListener;
    private IPlatformPlugin.ClassLoaderType loaderType;
    private Map<String, List<String>> externalResources = new HashMap<String, List<String>>();

    public void init(IPentahoSession session) {
        for (IPentahoInitializer initializer : this.initializers) {
            initializer.init(session);
        }
    }

    public String getLifecycleListenerClassname() {
        return this.lifecycleListenerClassname;
    }

    public void setLifecycleListenerClassname(String lifecycleListenerClassname) {
        this.lifecycleListenerClassname = lifecycleListenerClassname;
    }

    public List<IContentGeneratorInfo> getContentGenerators() {
        return this.contentGenerators;
    }

    public List<IContentInfo> getContentInfos() {
        return this.contentInfos;
    }

    public String getId() {
        return this.id;
    }

    public List<XulOverlay> getOverlays() {
        return this.overlays;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addInitializer(IPentahoInitializer initializer) {
        this.initializers.add(initializer);
    }

    public void addContentGenerator(IContentGeneratorInfo contentGenerator) {
        this.contentGenerators.add(contentGenerator);
    }

    public void addContentInfo(IContentInfo contentInfo) {
        this.contentInfos.add(contentInfo);
    }

    public void addOverlay(XulOverlay overlay) {
        this.overlays.add(overlay);
    }

    public List<?> getMenuCustomizations() {
        return this.menuOverlays;
    }

    public void addMenuCustomization(IMenuCustomization customization) {
        this.menuOverlays.add(customization);
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public void setSourceDescription(String sourceDescription) {
        this.sourceDescription = sourceDescription;
    }

    public void addStaticResourcePath(String url, String localFolder) {
        this.staticResourceMap.put(url, localFolder);
    }

    public Map<String, String> getStaticResourceMap() {
        return this.staticResourceMap;
    }

    public Collection<PluginBeanDefinition> getBeans() {
        return Collections.unmodifiableCollection(this.beanDefinitions);
    }

    public Collection<PluginServiceDefinition> getServices() {
        return Collections.unmodifiableCollection(this.webserviceDefinitions);
    }

    public void addBean(PluginBeanDefinition beanDefinition) {
        this.beanDefinitions.add(beanDefinition);
    }

    public void addWebservice(PluginServiceDefinition serviceDefinition) {
        this.webserviceDefinitions.add(serviceDefinition);
    }

    public void init() throws PluginLifecycleException {
        if (this.lifecycleListener != null) {
            this.lifecycleListener.init();
        }
    }

    public void loaded() throws PluginLifecycleException {
        if (this.lifecycleListener != null) {
            this.lifecycleListener.loaded();
        }
    }

    public void unLoaded() throws PluginLifecycleException {
        if (this.lifecycleListener != null) {
            this.lifecycleListener.unLoaded();
        }
    }

    public void addLifecycleListener(IPluginLifecycleListener listener) {
        this.lifecycleListener = listener;
    }

    public Map<String, String> getMetaProviderMap() {
        return this.metaProviderMap;
    }

    public IPlatformPlugin.ClassLoaderType getLoaderType() {
        return this.loaderType;
    }

    public void setLoadertype(IPlatformPlugin.ClassLoaderType loaderType) {
        this.loaderType = loaderType;
    }

    public void addExternalResource(String context, String resource) {
        List<String> res = this.externalResources.get(context);
        if (res == null) {
            res = new ArrayList<String>();
            this.externalResources.put(context, res);
        }
        res.add(resource);
    }

    public List<String> getExternalResourcesForContext(String context) {
        List<String> res = this.externalResources.get(context);
        if (res == null) {
            res = new ArrayList<String>();
            this.externalResources.put(context, res);
        }
        return Collections.unmodifiableList(res);
    }
}

