/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr.servicemgr;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.api.engine.ServiceInitializationException;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.pluginmgr.servicemgr.IServiceTypeManager;
import org.pentaho.platform.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceManager
implements IServiceManager {
    public Map<String, IServiceTypeManager> serviceManagerMap = new HashMap<String, IServiceTypeManager>();

    public void setServiceTypeManagers(Collection<IServiceTypeManager> serviceTypeManagers) {
        for (IServiceTypeManager handler : serviceTypeManagers) {
            String type = handler.getSupportedServiceType();
            if (type == null) {
                throw new IllegalArgumentException(Messages.getErrorString("DefaultServiceManager.ERROR_0001_INVALID_SERVICE_TYPE"));
            }
            this.serviceManagerMap.put(type, handler);
            Logger.info((String)this.getClass().toString(), (String)Messages.getString("DefaultServiceManager.REGISTERED_SERVICE_TYPES", handler.getSupportedServiceType()));
        }
    }

    public void registerService(IServiceConfig config) throws ServiceException {
        DefaultServiceManager.validate(config);
        String type = config.getServiceType();
        IServiceTypeManager mgr = this.serviceManagerMap.get(type);
        if (mgr == null) {
            String availableTypes = StringUtils.join(this.serviceManagerMap.keySet().iterator(), (String)Messages.getString(","));
            throw new ServiceException(Messages.getErrorString("DefaultServiceManager.ERROR_0002_NO_SERVICE_MANAGER_FOR_TYPE", config.getId(), type.toString(), availableTypes));
        }
        mgr.registerService(config);
    }

    private static void validate(IServiceConfig config) {
        if (StringUtils.isEmpty((String)config.getId())) {
            throw new IllegalStateException(Messages.getErrorString("DefaultServiceManager.ERROR_0003_INVALID_SERVICE_CONFIG", "id"));
        }
        if (config.getServiceClass() == null) {
            throw new IllegalStateException(Messages.getErrorString("DefaultServiceManager.ERROR_0003_INVALID_SERVICE_CONFIG", "class"));
        }
        if (config.getServiceType() == null) {
            throw new IllegalStateException(Messages.getErrorString("DefaultServiceManager.ERROR_0003_INVALID_SERVICE_CONFIG", "type"));
        }
    }

    public Object getServiceBean(String serviceType, String serviceId) throws ServiceException {
        return this.serviceManagerMap.get(serviceType).getServiceBean(serviceId);
    }

    public IServiceConfig getServiceConfig(String serviceType, String serviceId) {
        return this.serviceManagerMap.get(serviceType).getServiceConfig(serviceId);
    }

    public void initServices() throws ServiceInitializationException {
        for (IServiceTypeManager handler : this.serviceManagerMap.values()) {
            handler.initServices();
        }
    }
}

