/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class JdbcUserRoleListService
extends JdbcDaoSupport
implements IUserRoleListService {
    public static final String DEF_ALL_AUTHORITIES_QUERY = "SELECT distinct(authority) as authority FROM authorities";
    public static final String DEF_ALL_USERNAMES_QUERY = "SELECT distinct(username) as username FROM users";
    public static final String DEF_ALL_USERNAMES_IN_ROLE_QUERY = "SELECT distinct(username) as username FROM authorities where authority = ?";
    protected MappingSqlQuery allAuthoritiesMapping;
    protected MappingSqlQuery allUsernamesMapping;
    protected MappingSqlQuery allUsernamesInRoleMapping;
    private String allAuthoritiesQuery = "SELECT distinct(authority) as authority FROM authorities";
    private String allUsernamesQuery = "SELECT distinct(username) as username FROM users";
    private String allUsernamesInRoleQuery = "SELECT distinct(username) as username FROM authorities where authority = ?";
    private UserDetailsService userDetailsService;
    private String rolePrefix;

    public JdbcUserRoleListService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setAllAuthoritiesQuery(String queryString) {
        this.allAuthoritiesQuery = queryString;
    }

    public String getAllAuthoritiesQuery() {
        return this.allAuthoritiesQuery;
    }

    public void setAllUsernamesInRoleQuery(String queryString) {
        this.allUsernamesInRoleQuery = queryString;
    }

    public String getAllUsernamesInRoleQuery() {
        return this.allUsernamesInRoleQuery;
    }

    public void setAllUsernamesQuery(String queryString) {
        this.allUsernamesQuery = queryString;
    }

    public String getAllUsernamesQuery() {
        return this.allUsernamesQuery;
    }

    public GrantedAuthority[] getAllAuthorities() throws DataAccessException {
        List allAuths = this.allAuthoritiesMapping.execute();
        if (allAuths.size() == 0) {
            GrantedAuthority[] rtn = new GrantedAuthority[]{};
            return rtn;
        }
        GrantedAuthority[] arrayAuths = new GrantedAuthority[]{};
        return allAuths.toArray(arrayAuths);
    }

    public String[] getAllUsernames() throws DataAccessException {
        List allUserNames = this.allUsernamesMapping.execute();
        if (allUserNames.size() == 0) {
            String[] rtn = new String[]{};
            return rtn;
        }
        String[] arrayUserNames = new String[]{};
        return allUserNames.toArray(arrayUserNames);
    }

    public String[] getUsernamesInRole(GrantedAuthority authority) {
        List allUserNames = this.allUsernamesInRoleMapping.execute(authority.getAuthority());
        if (allUserNames.size() == 0) {
            String[] rtn = new String[]{};
            return rtn;
        }
        String[] arrayUserNames = new String[]{};
        return allUserNames.toArray(arrayUserNames);
    }

    protected void initDao() throws ApplicationContextException {
        this.initMappingSqlQueries();
    }

    protected void initMappingSqlQueries() {
        this.allAuthoritiesMapping = new AllAuthoritiesMapping(this.getDataSource());
        this.allUsernamesInRoleMapping = new AllUserNamesInRoleMapping(this.getDataSource());
        this.allUsernamesMapping = new AllUserNamesMapping(this.getDataSource());
    }

    public GrantedAuthority[] getAuthoritiesForUser(String userName) throws UsernameNotFoundException, DataAccessException {
        UserDetails user = this.userDetailsService.loadUserByUsername(userName);
        return user.getAuthorities();
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    protected class AllAuthoritiesMapping
    extends MappingSqlQuery {
        protected AllAuthoritiesMapping(DataSource ds) {
            super(ds, JdbcUserRoleListService.this.allAuthoritiesQuery);
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            return new GrantedAuthorityImpl((null != JdbcUserRoleListService.this.rolePrefix ? JdbcUserRoleListService.this.rolePrefix : "") + rs.getString(1));
        }
    }

    protected class AllUserNamesInRoleMapping
    extends MappingSqlQuery {
        protected AllUserNamesInRoleMapping(DataSource ds) {
            super(ds, JdbcUserRoleListService.this.allUsernamesInRoleQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            return rs.getString(1);
        }
    }

    protected class AllUserNamesMapping
    extends MappingSqlQuery {
        protected AllUserNamesMapping(DataSource ds) {
            super(ds, JdbcUserRoleListService.this.allUsernamesQuery);
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            return rs.getString(1);
        }
    }
}

