/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.plugin.services.security.userrole.ldap.search.LdapSearch;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.ldap.LdapUserDetailsService;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLdapUserRoleListService
implements IUserRoleListService,
InitializingBean {
    private LdapSearch allUsernamesSearch;
    private LdapSearch allAuthoritiesSearch;
    private LdapSearch usernamesInRoleSearch;
    private Comparator<GrantedAuthority> grantedAuthorityComparator;
    private Comparator<String> usernameComparator;
    private LdapUserDetailsService userDetailsService;

    public DefaultLdapUserRoleListService() {
    }

    public DefaultLdapUserRoleListService(Comparator<String> usernameComparator, Comparator<GrantedAuthority> grantedAuthorityComparator) {
        this.usernameComparator = usernameComparator;
        this.grantedAuthorityComparator = grantedAuthorityComparator;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public GrantedAuthority[] getAllAuthorities() {
        List results = this.allAuthoritiesSearch.search(new Object[0]);
        if (null != this.grantedAuthorityComparator) {
            Collections.sort(results, this.grantedAuthorityComparator);
        }
        return results.toArray(new GrantedAuthority[0]);
    }

    public String[] getAllUsernames() {
        List results = this.allUsernamesSearch.search(new Object[0]);
        if (null != this.usernameComparator) {
            Collections.sort(results, this.usernameComparator);
        }
        return results.toArray(new String[0]);
    }

    public String[] getUsernamesInRole(GrantedAuthority authority) {
        List results = this.usernamesInRoleSearch.search(new Object[]{authority});
        if (null != this.usernameComparator) {
            Collections.sort(results, this.usernameComparator);
        }
        return results.toArray(new String[0]);
    }

    public GrantedAuthority[] getAuthoritiesForUser(String username) {
        UserDetails user = this.userDetailsService.loadUserByUsername(username);
        List<GrantedAuthority> results = Arrays.asList(user.getAuthorities());
        if (null != this.grantedAuthorityComparator) {
            Collections.sort(results, this.grantedAuthorityComparator);
        }
        return results.toArray(new GrantedAuthority[0]);
    }

    public void setAllUsernamesSearch(LdapSearch allUsernamesSearch) {
        this.allUsernamesSearch = allUsernamesSearch;
    }

    public void setAllAuthoritiesSearch(LdapSearch allAuthoritiesSearch) {
        this.allAuthoritiesSearch = allAuthoritiesSearch;
    }

    public void setUsernamesInRoleSearch(LdapSearch usernamesInRoleSearch) {
        this.usernamesInRoleSearch = usernamesInRoleSearch;
    }

    public void setUserDetailsService(LdapUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setGrantedAuthorityComparator(Comparator<GrantedAuthority> grantedAuthorityComparator) {
        Assert.notNull(grantedAuthorityComparator);
        this.grantedAuthorityComparator = grantedAuthorityComparator;
    }

    public void setUsernameComparator(Comparator<String> usernameComparator) {
        Assert.notNull(usernameComparator);
        this.usernameComparator = usernameComparator;
    }
}

