/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.ldap.LdapUserDetailsMapper;

public class RolePreprocessingMapper
extends LdapUserDetailsMapper
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(RolePreprocessingMapper.class);
    private String tokenName = "cn";

    public RolePreprocessingMapper() {
    }

    public RolePreprocessingMapper(String tokenName) {
        this.tokenName = tokenName;
    }

    protected GrantedAuthority createAuthority(Object role) {
        Object newRole = this.preprocessRole(role);
        return super.createAuthority(newRole);
    }

    protected Object preprocessRole(Object role) {
        String COMPONENT_SEPARATOR = ",";
        String NAME_VALUE_PAIR_SEPARATOR = "=";
        if (role instanceof String) {
            String[] tokens;
            String roleString = (String)role;
            for (String rdnString : tokens = roleString.split(",")) {
                String[] rdnTokens = rdnString.split("=");
                if (!rdnTokens[0].trim().equals(this.tokenName)) continue;
                return rdnTokens[1].trim();
            }
            if (logger.isWarnEnabled()) {
                logger.warn((Object)Messages.getString("RolePreprocessingMapper.WARN_TOKEN_NOT_FOUND", this.tokenName));
            }
            return null;
        }
        return role;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

