/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionizingLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator,
InitializingBean {
    private Set<LdapAuthoritiesPopulator> populators;

    public GrantedAuthority[] getGrantedAuthorities(DirContextOperations userData, String username) {
        HashSet<GrantedAuthority> allAuthorities = new HashSet<GrantedAuthority>();
        for (LdapAuthoritiesPopulator populator : this.populators) {
            GrantedAuthority[] auths = populator.getGrantedAuthorities(userData, username);
            if (null == auths || auths.length <= 0) continue;
            allAuthorities.addAll(Arrays.asList(auths));
        }
        return allAuthorities.toArray(new GrantedAuthority[0]);
    }

    public void setPopulators(Set<LdapAuthoritiesPopulator> populators) {
        this.populators = populators;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.populators, (String)Messages.getString("UnionizingLdapAuthoritiesPopulator.ERROR_0001_POPULATOR_NULL"));
    }
}

