/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.plugin.services.security.userrole.ldap.search.LdapSearch;
import org.pentaho.platform.plugin.services.security.userrole.ldap.search.LdapSearchParams;
import org.pentaho.platform.plugin.services.security.userrole.ldap.search.LdapSearchParamsFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ldap.core.ContextSource;
import org.springframework.util.Assert;

public class GenericLdapSearch
implements LdapSearch,
InitializingBean {
    private static final Log logger = LogFactory.getLog(GenericLdapSearch.class);
    private LdapSearchParamsFactory paramsFactory;
    private Transformer resultsTransformer;
    private Transformer filterArgsTransformer;
    private ContextSource contextSource;

    public GenericLdapSearch(ContextSource contextSource, LdapSearchParamsFactory paramsFactory) {
        this(contextSource, paramsFactory, null, null);
    }

    public GenericLdapSearch(ContextSource contextSource, LdapSearchParamsFactory paramsFactory, Transformer resultsTransformer) {
        this(contextSource, paramsFactory, resultsTransformer, null);
    }

    public GenericLdapSearch(ContextSource contextSource, LdapSearchParamsFactory paramsFactory, Transformer resultsTransformer, Transformer filterArgsTransformer) {
        this.contextSource = contextSource;
        this.paramsFactory = paramsFactory;
        this.resultsTransformer = resultsTransformer;
        this.filterArgsTransformer = filterArgsTransformer;
    }

    public List search(Object[] filterArgs) {
        HashSet<SearchResult> results;
        block8: {
            Object[] transformedArgs = filterArgs;
            if (null != this.filterArgsTransformer) {
                transformedArgs = (Object[])this.filterArgsTransformer.transform((Object)filterArgs);
            }
            LdapSearchParams params = this.paramsFactory.createParams(transformedArgs);
            results = new HashSet<SearchResult>();
            NamingEnumeration<SearchResult> matches = null;
            try {
                matches = this.contextSource.getReadOnlyContext().search(params.getBase(), params.getFilter(), params.getFilterArgs(), params.getSearchControls());
            }
            catch (NamingException e1) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"Directory search failed", (Throwable)e1);
                }
                return new ArrayList(results);
            }
            try {
                while (matches.hasMore()) {
                    SearchResult result = matches.next();
                    if (null != this.resultsTransformer) {
                        results.addAll((Collection)this.resultsTransformer.transform((Object)result));
                        continue;
                    }
                    results.add(result);
                }
            }
            catch (NamingException e) {
                if (!logger.isErrorEnabled()) break block8;
                logger.error((Object)"Enumerating directory search results failed", (Throwable)e);
            }
        }
        return new ArrayList(results);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.contextSource);
        Assert.notNull((Object)this.paramsFactory);
    }
}

