/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap.transform;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.springframework.security.GrantedAuthority;
import org.springframework.util.Assert;

public class GrantedAuthorityToString
implements Transformer {
    private static final Log logger = LogFactory.getLog(GrantedAuthorityToString.class);
    private String rolePrefix = "ROLE_";

    public Object transform(Object obj) {
        if (logger.isDebugEnabled()) {
            String input = obj instanceof Object[] ? Arrays.asList((Object[])obj).toString() : obj.toString();
            logger.debug((Object)Messages.getString("GrantedAuthorityToString.DEBUG_INPUT_TO_TRANSFORM", input));
        }
        Object[] transformed = obj;
        if (obj instanceof GrantedAuthority) {
            transformed = this.transformItem(obj);
        } else if (obj instanceof Collection) {
            transformed = new HashSet();
            Set authSet = (Set)transformed;
            Iterator iter = ((Collection)obj).iterator();
            while (iter.hasNext()) {
                authSet.add(this.transformItem(iter.next()));
            }
        } else if (obj instanceof Object[]) {
            Object[] objArray;
            transformed = new HashSet();
            Set authSet = (Set)transformed;
            for (Object element : objArray = (Object[])obj) {
                authSet.add(this.transformItem(element));
            }
            transformed = authSet.toArray();
        }
        return transformed;
    }

    protected Object transformItem(Object obj) {
        Object transformed = obj;
        if (obj instanceof GrantedAuthority) {
            String auth = ((GrantedAuthority)obj).getAuthority();
            if (auth.startsWith(this.rolePrefix)) {
                auth = auth.substring(this.rolePrefix.length());
            }
            transformed = auth;
        }
        return transformed;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.hasLength((String)rolePrefix);
        this.rolePrefix = rolePrefix;
    }
}

