/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.memory;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.security.userrole.memory.UserRoleListEnhancedUserMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryUserRoleListService
implements IUserRoleListService,
InitializingBean {
    private Comparator<GrantedAuthority> grantedAuthorityComparator;
    private Comparator<String> usernameComparator;
    private GrantedAuthority[] allAuthorities;
    private UserRoleListEnhancedUserMap userRoleListEnhancedUserMap;
    private UserDetailsService userDetailsService;

    public GrantedAuthority[] getAllAuthorities() {
        List<GrantedAuthority> results = Arrays.asList(this.allAuthorities);
        if (null != this.grantedAuthorityComparator) {
            Collections.sort(results, this.grantedAuthorityComparator);
        }
        return results.toArray(new GrantedAuthority[0]);
    }

    public String[] getAllUsernames() {
        List<String> results = Arrays.asList(this.userRoleListEnhancedUserMap.getAllUsers());
        if (null != this.usernameComparator) {
            Collections.sort(results, this.usernameComparator);
        }
        return results.toArray(new String[0]);
    }

    public String[] getUsernamesInRole(GrantedAuthority authority) {
        List<String> results = Arrays.asList(this.userRoleListEnhancedUserMap.getUserNamesInRole(authority));
        if (null != this.usernameComparator) {
            Collections.sort(results, this.usernameComparator);
        }
        return results.toArray(new String[0]);
    }

    public void setAllAuthorities(GrantedAuthority[] allAuthorities) {
        this.allAuthorities = allAuthorities;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.userRoleListEnhancedUserMap), (String)Messages.getErrorString("InMemoryUserRoleListService.ERROR_0001_PROPERTY_LIST_NOT_SPECIFIED"));
        Assert.notNull((Object)this.allAuthorities, (String)Messages.getString("InMemoryUserRoleListService.ERROR_0002_ALL_AUTHORITIES_NOT_SPECIFIED"));
        Assert.notNull((Object)this.userDetailsService, (String)Messages.getString("InMemoryUserRoleListService.ERROR_0003_USERDETAILSSERVICE_NOT_SPECIFIED"));
    }

    public GrantedAuthority[] getAuthoritiesForUser(String username) throws UsernameNotFoundException {
        UserDetails user = this.userDetailsService.loadUserByUsername(username);
        List<GrantedAuthority> results = Arrays.asList(user.getAuthorities());
        if (null != this.grantedAuthorityComparator) {
            Collections.sort(results, this.grantedAuthorityComparator);
        }
        return results.toArray(new GrantedAuthority[0]);
    }

    public void setUserRoleListEnhancedUserMap(UserRoleListEnhancedUserMap userRoleListEnhancedUserMap) {
        this.userRoleListEnhancedUserMap = userRoleListEnhancedUserMap;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public UserRoleListEnhancedUserMap getUserRoleListEnhancedUserMap() {
        return this.userRoleListEnhancedUserMap;
    }

    public void setGrantedAuthorityComparator(Comparator<GrantedAuthority> grantedAuthorityComparator) {
        Assert.notNull(grantedAuthorityComparator);
        this.grantedAuthorityComparator = grantedAuthorityComparator;
    }

    public void setUsernameComparator(Comparator<String> usernameComparator) {
        Assert.notNull(usernameComparator);
        this.usernameComparator = usernameComparator;
    }
}

