/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.memory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.memory.UserMap;

public class UserRoleListEnhancedUserMap
extends UserMap {
    private final Map userRoleListEnhanceduserMap = new HashMap();
    private final Map rolesToUsersMap = new HashMap();

    public void addUser(UserDetails user) throws IllegalArgumentException {
        GrantedAuthority[] auths;
        super.addUser(user);
        this.userRoleListEnhanceduserMap.put(user.getUsername().toLowerCase(), user);
        for (GrantedAuthority anAuthority : auths = user.getAuthorities()) {
            TreeSet<String> userListForAuthority = (TreeSet<String>)this.rolesToUsersMap.get(anAuthority);
            if (userListForAuthority == null) {
                userListForAuthority = new TreeSet<String>();
                this.rolesToUsersMap.put(anAuthority, userListForAuthority);
            }
            userListForAuthority.add(user.getUsername());
        }
    }

    public GrantedAuthority[] getAllAuthorities() {
        GrantedAuthority[] typ = new GrantedAuthority[]{};
        Set authoritiesSet = this.rolesToUsersMap.keySet();
        return authoritiesSet.toArray(typ);
    }

    public String[] getAllUsers() {
        String[] rtn = new String[this.userRoleListEnhanceduserMap.size()];
        Iterator it = this.userRoleListEnhanceduserMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            rtn[i] = ((UserDetails)it.next()).getUsername();
            ++i;
        }
        return rtn;
    }

    public String[] getUserNamesInRole(GrantedAuthority authority) {
        Set userListForAuthority = (Set)this.rolesToUsersMap.get(authority);
        String[] typ = new String[]{};
        if (userListForAuthority != null) {
            return userListForAuthority.toArray(typ);
        }
        return typ;
    }

    public void setUsers(Map users) {
        super.setUsers(users);
        Iterator iter = users.values().iterator();
        while (iter.hasNext()) {
            this.addUser((UserDetails)iter.next());
        }
    }
}

