/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.versionchecker;

import java.util.Map;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.VersionInfo;
import org.pentaho.versionchecker.IVersionCheckDataProvider;

public class PentahoVersionCheckDataProvider
implements IVersionCheckDataProvider {
    protected static final VersionInfo versionInfo;
    protected int versionRequestFlags = 40;

    public void setVersionRequestFlags(int flags) {
        this.versionRequestFlags = flags;
    }

    public String getApplicationID() {
        return versionInfo == null ? null : versionInfo.getProductID();
    }

    public String getApplicationVersion() {
        return versionInfo == null ? null : versionInfo.getVersionNumber();
    }

    public String getBaseURL() {
        return null;
    }

    public Map getExtraInformation() {
        return null;
    }

    protected int computeOSMask() {
        try {
            String os = System.getProperty("os.name");
            if (os != null) {
                if ((os = os.toLowerCase()).indexOf("windows") >= 0) {
                    return 128;
                }
                if (os.indexOf("mac") >= 0) {
                    return 256;
                }
                if (os.indexOf("linux") >= 0) {
                    return 512;
                }
                return 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public int getDepth() {
        int depth = this.versionRequestFlags + this.computeOSMask();
        return depth;
    }

    static {
        IVersionHelper versionHelper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, null);
        versionInfo = versionHelper != null ? VersionHelper.getVersionInfo(versionHelper.getClass()) : VersionHelper.getVersionInfo(PentahoSystem.class);
    }
}

