/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.versionchecker;

import java.util.ArrayList;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.versionchecker.PentahoVersionCheckDataProvider;
import org.pentaho.versionchecker.IVersionCheckDataProvider;
import org.pentaho.versionchecker.IVersionCheckErrorHandler;
import org.pentaho.versionchecker.IVersionCheckResultHandler;
import org.pentaho.versionchecker.VersionChecker;

public class PentahoVersionCheckHelper {
    protected boolean ignoreExistingUpdates = false;
    protected ArrayList resultList = new ArrayList();
    protected int versionRequestFlags = -1;

    public void setVersionRequestFlags(int versionRequestFlags) {
        this.versionRequestFlags = versionRequestFlags;
    }

    public void setIgnoreExistingUpdates(boolean ignoreExistingUpdates) {
        this.ignoreExistingUpdates = ignoreExistingUpdates;
    }

    public ArrayList getResults() {
        return this.resultList;
    }

    public void performUpdate() {
        IVersionCheckResultHandler resultHandler = new IVersionCheckResultHandler(){

            public void processResults(String results) {
                PentahoVersionCheckHelper.this.resultList.add(results);
            }
        };
        IVersionCheckErrorHandler errorHandler = new IVersionCheckErrorHandler(){

            public void handleException(Exception e) {
                PentahoVersionCheckHelper.this.resultList.add("<vercheck><error><![CDATA[" + e.getMessage() + "]]></error></vercheck>");
            }
        };
        IVersionCheckDataProvider dataProvider = (IVersionCheckDataProvider)PentahoSystem.get(IVersionCheckDataProvider.class, (String)"IVersionCheckDataProvider", null);
        if (dataProvider == null) {
            dataProvider = new PentahoVersionCheckDataProvider();
        }
        if (this.versionRequestFlags != -1) {
            dataProvider.setVersionRequestFlags(this.versionRequestFlags);
        }
        VersionChecker vc = new VersionChecker();
        vc.setDataProvider(dataProvider);
        vc.addResultHandler(resultHandler);
        vc.addErrorHandler(errorHandler);
        vc.performCheck(this.ignoreExistingUpdates);
    }
}

