/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.versionchecker;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class PentahoVersionCheckReflectHelper {
    public static boolean isVersionCheckerAvailable() {
        try {
            Class.forName("org.pentaho.versionchecker.VersionChecker");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static List performVersionCheck(boolean ignoreExistingUpdates, int versionRequestFlags) {
        if (PentahoVersionCheckReflectHelper.isVersionCheckerAvailable()) {
            try {
                Class<?> helperClass = Class.forName("org.pentaho.platform.plugin.services.versionchecker.PentahoVersionCheckHelper");
                Object helper = helperClass.getConstructors()[0].newInstance(new Object[0]);
                Method setIgnoreExistingUpdatesMethod = helperClass.getDeclaredMethod("setIgnoreExistingUpdates", Boolean.TYPE);
                setIgnoreExistingUpdatesMethod.invoke(helper, new Boolean(ignoreExistingUpdates));
                Method setVersionRequestFlagsMethod = helperClass.getDeclaredMethod("setVersionRequestFlags", Integer.TYPE);
                setVersionRequestFlagsMethod.invoke(helper, new Integer(versionRequestFlags));
                Method performUpdateMethod = helperClass.getDeclaredMethod("performUpdate", new Class[0]);
                performUpdateMethod.invoke(helper, new Object[0]);
                Method getResultsMethod = helperClass.getDeclaredMethod("getResults", new Class[0]);
                List results = (List)getResultsMethod.invoke(helper, new Object[0]);
                return results;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String logVersionCheck(List results, Log logger) {
        String output = null;
        if (results != null && results.size() > 0) {
            String result = results.get(0).toString();
            try {
                Document doc = XmlDom4JHelper.getDocFromString((String)result, (EntityResolver)new PentahoEntityResolver());
                if (doc != null) {
                    List nodes = doc.selectNodes("//update");
                    for (Element updateElement : nodes) {
                        String title = updateElement.attributeValue("title");
                        String version = updateElement.attributeValue("version");
                        String type = updateElement.attributeValue("type");
                        String downloadurl = XmlDom4JHelper.getNodeText((String)"downloadurl", (Node)updateElement);
                        if (downloadurl != null) {
                            downloadurl = downloadurl.trim();
                        }
                        logger.info((Object)Messages.getString("VersionCheck.UPDATE_MESSAGE", title, version, type, downloadurl));
                    }
                    nodes = doc.selectNodes("//error");
                    for (Element errorElement : nodes) {
                        String message = errorElement.getText();
                        logger.info((Object)Messages.getString("VersionCheck.ERROR_MESSAGE", message));
                    }
                }
                output = result;
            }
            catch (Exception e) {
                output = "<vercheck><error><[!CDATA[" + Messages.getString("VersionCheck.ERROR_MESSAGE", e.getMessage()) + "]]></error></vercheck>";
            }
        } else {
            output = "<vercheck><error><[!CDATA[" + Messages.getString("VersionCheck.NO_RESULT_MESSAGE") + "]]></error></vercheck>";
        }
        return output;
    }
}

