/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.webservices;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.webservices.AxisUtil;
import org.pentaho.platform.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAxisConfigurator
extends PentahoBase
implements AxisConfigurator {
    private static final long serialVersionUID = 1931282897052453845L;
    protected AxisConfiguration axisConfig = null;
    protected IPentahoSession session;
    protected boolean loaded = false;
    private Map<String, IServiceConfig> services = new HashMap<String, IServiceConfig>();

    public abstract Log getLogger();

    public abstract void addService(IServiceConfig var1);

    public AbstractAxisConfigurator() {
        this.init();
    }

    public void reloadServices() throws AxisFault {
        this.unloadServices();
        this.loadServices();
    }

    public void unloadServices() throws AxisFault {
        Set<String> keys = this.services.keySet();
        ArrayList<String> removed = new ArrayList<String>();
        for (String key : keys) {
            IServiceConfig wrapper = this.services.get(key);
            String serviceName = wrapper.getServiceClass().getSimpleName();
            this.axisConfig.removeService(serviceName);
            removed.add(serviceName);
        }
        for (String serviceName : removed) {
            this.services.remove(serviceName);
        }
        this.loaded = false;
    }

    public IServiceConfig getWebServiceDefinition(String name) {
        return this.services.get(name);
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        if (this.axisConfig != null) {
            return this.axisConfig;
        }
        try {
            this.axisConfig = new AxisConfiguration();
            InputStream in = this.getConfigXml();
            AxisConfigBuilder builder = new AxisConfigBuilder(in, this.axisConfig, null);
            builder.populateConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw AxisFault.makeFault((Throwable)e);
        }
        this.axisConfig.setConfigurator((AxisConfigurator)this);
        return this.axisConfig;
    }

    public abstract InputStream getConfigXml();

    public abstract boolean setEnabled(String var1, boolean var2) throws AxisFault;

    public abstract void init();

    protected abstract void addServiceEndPoints(AxisService var1);

    protected abstract void addTransports(AxisService var1);

    protected abstract List<IServiceConfig> getWebServiceDefinitions();

    public void loadServices() {
        if (this.loaded) {
            return;
        }
        List<IServiceConfig> wsDfns = this.getWebServiceDefinitions();
        for (IServiceConfig wsDef : wsDfns) {
            try {
                this.loadService(wsDef);
            }
            catch (Exception e) {
                Logger.error((String)((Object)((Object)this)).getClass().getName(), (String)Messages.getErrorString("AbstractAxisConfigurator.ERROR_0001_COULD_NOT_LOAD_SERVICE", wsDef.getId()), (Throwable)e);
            }
        }
        this.loaded = true;
    }

    protected void loadService(IServiceConfig wsDef) throws Exception {
        String serviceId = wsDef.getId();
        AxisService axisService = AxisUtil.createService(wsDef, this.getAxisConfiguration());
        this.addTransports(axisService);
        this.addServiceEndPoints(axisService);
        Parameter wsDefParam = new Parameter();
        wsDefParam.setName("wsDefParam");
        wsDefParam.setValue((Object)wsDef);
        axisService.addParameter(wsDefParam);
        this.services.put(serviceId, wsDef);
        this.axisConfig.addService(axisService);
        this.axisConfig.startService(axisService.getName());
        axisService.setActive(wsDef.isEnabled());
    }

    public void engageGlobalModules() throws AxisFault {
    }

    public void cleanup() {
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }
}

