/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.webservices;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.webservices.AbstractAxisConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemSolutionAxisConfigurator
extends AbstractAxisConfigurator {
    private static final long serialVersionUID = -4219285702722007821L;
    private static final Log logger = LogFactory.getLog(SystemSolutionAxisConfigurator.class);
    protected List<IServiceConfig> wsDfns = new ArrayList<IServiceConfig>();

    @Override
    public Log getLogger() {
        return logger;
    }

    @Override
    public void init() {
    }

    public static String getAxisConfigPath() {
        return "system/axis/axis2_config.xml";
    }

    @Override
    public InputStream getConfigXml() {
        try {
            ISolutionRepository solutionRepo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.session);
            byte[] configBytes = solutionRepo.getResourceAsBytes(SystemSolutionAxisConfigurator.getAxisConfigPath(), false, 1);
            ByteArrayInputStream in = new ByteArrayInputStream(configBytes);
            return in;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("SystemSolutionAxisConfigurator.ERROR_0001_BAD_CONFIG_FILE", SystemSolutionAxisConfigurator.getAxisConfigPath()), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean setEnabled(String name, boolean enabled) throws AxisFault {
        return true;
    }

    @Override
    public void addService(IServiceConfig ws) {
        this.wsDfns.add(ws);
    }

    @Override
    protected List<IServiceConfig> getWebServiceDefinitions() {
        return this.wsDfns;
    }

    @Override
    protected void addTransports(AxisService axisService) {
    }

    @Override
    protected void addServiceEndPoints(AxisService axisService) {
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        String endPoint1 = requestContext.getContextPath() + "content/ws-run/" + axisService.getName();
        axisService.setEPRs(new String[]{endPoint1});
    }
}

