/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.webservices.content;

import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.MessageContextBuilder;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;
import org.pentaho.platform.plugin.services.pluginmgr.servicemgr.AxisWebServiceManager;
import org.pentaho.platform.plugin.services.webservices.messages.Messages;

public abstract class AbstractAxisServiceContentGenerator
extends SimpleContentGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContent(OutputStream out) throws Exception {
        AxisConfiguration axisConfiguration = AxisWebServiceManager.currentAxisConfiguration;
        if (axisConfiguration == null) {
            String message = Messages.getErrorString("WebServiceContentGenerator.ERROR_0001_AXIS_CONFIG_IS_NULL");
            this.getLogger().error((Object)message);
            out.write(message.getBytes());
            return;
        }
        this.createContent(axisConfiguration, AxisWebServiceManager.currentAxisConfigContext, out);
    }

    public abstract void createContent(AxisConfiguration var1, ConfigurationContext var2, OutputStream var3) throws Exception;

    protected void processAxisFault(MessageContext msgContext, OutputStream out, Throwable e) {
        boolean http;
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
        boolean bl = http = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE) != null;
        if (http) {
            HttpServletResponse res = (HttpServletResponse)pathParams.getParameter("httpresponse");
            if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                res.setStatus(202);
            } else {
                Integer code;
                AxisBindingMessage fault;
                String status = (String)msgContext.getProperty("axis2.http.response.state");
                if (status == null) {
                    res.setStatus(500);
                } else {
                    res.setStatus(Integer.parseInt(status));
                }
                AxisBindingOperation axisBindingOperation = (AxisBindingOperation)msgContext.getProperty("AxisBindingOperation");
                if (axisBindingOperation != null && (fault = axisBindingOperation.getFault((String)msgContext.getProperty("faultName"))) != null && (code = (Integer)fault.getProperty("whttp:code")) != null) {
                    res.setStatus(code.intValue());
                }
            }
        }
        try {
            this.handleFault(msgContext, out, http, e);
        }
        catch (AxisFault axisFault) {
            String message = Messages.getErrorString("WebServiceContentGenerator.ERROR_0003_PROCESSING_FAULT");
            this.getLogger().error((Object)message, (Throwable)axisFault);
        }
    }

    protected void handleFault(MessageContext msgContext, OutputStream out, boolean http, Throwable e) throws AxisFault {
        HttpServletResponse response;
        msgContext.setProperty("TRANSPORT_OUT", (Object)out);
        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
        HttpServletResponse httpServletResponse = response = http ? (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE) : null;
        if (response != null) {
            SOAPFaultCode code = faultContext.getEnvelope().getBody().getFault().getCode();
            OMElement valueElement = null;
            if (code != null) {
                valueElement = code.getFirstChildWithName(new QName("http://www.w3.org/2003/05/soap-envelope", "Value"));
            }
            if (valueElement != null && "Sender".equals(valueElement.getTextAsQName().getLocalPart()) && !msgContext.isDoingREST()) {
                response.setStatus(400);
            }
        }
        AxisEngine.sendFault((MessageContext)faultContext);
    }
}

