/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.hsqldb;

import java.io.IOException;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.Server;
import org.hsqldb.ServerConfiguration;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.HsqlProperties;
import org.pentaho.platform.web.hsqldb.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDatabaseStarterBean {
    private static final Log logger = LogFactory.getLog(HsqlDatabaseStarterBean.class);
    private Server hsqlServer;
    private int port = 9001;
    private Map<String, String> databases = new LinkedHashMap<String, String>();
    private boolean allowFailoverToDefaultPort;

    protected boolean checkPort() {
        if (this.port < 0 || this.port > 65535) {
            if (this.allowFailoverToDefaultPort) {
                logger.error((Object)Messages.getErrorString("HsqlDatabaseStarterBean.ERROR_0004_INVALID_PORT"));
                this.port = 9001;
            } else {
                return this.logFailure("HsqlDatabaseStarterBean.ERROR_0004_INVALID_PORT");
            }
        }
        try {
            ServerSocket sock = new ServerSocket(this.port);
            sock.close();
        }
        catch (IOException ex1) {
            if (this.port == 9001) {
                return this.logFailure("HsqlDatabaseStarterBean.ERROR_0006_DEFAULT_PORT_IN_USE");
            }
            if (this.allowFailoverToDefaultPort) {
                logger.error((Object)Messages.getErrorString("HsqlDatabaseStarterBean.ERROR_0005_SPECIFIED_PORT_IN_USE", Integer.toString(this.port)));
                this.port = 9001;
                try {
                    ServerSocket sock = new ServerSocket(this.port);
                    sock.close();
                }
                catch (IOException ex2) {
                    return this.logFailure("HsqlDatabaseStarterBean.ERROR_0006_DEFAULT_PORT_IN_USE");
                }
            }
            return this.logFailure("HsqlDatabaseStarterBean.ERROR_0008_SPECIFIED_PORT_IN_USE_NO_FAILOVER", Integer.toString(this.port));
        }
        return true;
    }

    protected HsqlProperties getServerProperties(String[] args) {
        String propsPath = FileUtil.canonicalOrAbsolutePath((String)"server");
        HsqlProperties fileProps = ServerConfiguration.getPropertiesFromFile((String)propsPath);
        HsqlProperties props = fileProps == null ? new HsqlProperties() : fileProps;
        HsqlProperties stringProps = null;
        try {
            stringProps = HsqlProperties.argArrayToProps((String[])args, (String)"server");
            props.addProperties(stringProps);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            logger.error((Object)Messages.getErrorString("HsqlDatabaseStarterBean.ERROR_0001_INVALID_PARAMETERS"));
            ex.printStackTrace();
            logger.warn((Object)Messages.getString("HsqlDatabaseStarterBean.WARN_NO_DATABASES"));
            return null;
        }
        return props;
    }

    protected Server getNewHSQLDBServer() {
        return new Server();
    }

    public boolean start() {
        HsqlProperties props;
        if (!this.checkPort()) {
            return false;
        }
        ArrayList<String> startupArguments = this.getStartupArguments();
        String[] args = startupArguments.toArray(new String[0]);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Assembled parameters");
            for (int i = 0; i < args.length; ++i) {
                logger.trace((Object)String.format("  args[%d]=%s", i, args[i]));
            }
        }
        if ((props = this.getServerProperties(args)) == null) {
            return false;
        }
        this.hsqlServer = this.getNewHSQLDBServer();
        try {
            this.hsqlServer.setProperties(props);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("HsqlDatabaseStarterBean.ERROR_0002_INVALID_CONFIGURATION"));
            e.printStackTrace();
            logger.warn((Object)Messages.getString("HsqlDatabaseStarterBean.WARN_NO_DATABASES"));
            return false;
        }
        this.hsqlServer.start();
        return this.hsqlServer.getState() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        if (this.hsqlServer != null) {
            try {
                logger.debug((Object)"Stopping embedded hsqldb databases");
                logger.debug((Object)"Signaling connection close...");
                this.hsqlServer.signalCloseAllServerConnections();
                logger.debug((Object)"Stopping server listener threads..");
                this.hsqlServer.stop();
                logger.debug((Object)"Waiting for embedded server to complete shut down tasks...");
                for (int times = 0; this.hsqlServer.getState() != 16 && times < 100; ++times) {
                    try {
                        Thread.sleep(times + 100);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.hsqlServer.getState() != 16) {
                    logger.error((Object)Messages.getErrorString("HsqlDatabaseStarterBean.ERROR_0003_DID_NOT_STOP"));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.hsqlServer = null;
            }
        }
        return true;
    }

    private boolean logFailure(String errorId) {
        logger.error((Object)Messages.getErrorString(errorId));
        logger.warn((Object)Messages.getString("HsqlDatabaseStarterBean.WARN_NO_DATABASES"));
        return false;
    }

    private boolean logFailure(String errorId, String param) {
        logger.error((Object)Messages.getErrorString(errorId, param));
        logger.warn((Object)Messages.getString("HsqlDatabaseStarterBean.WARN_NO_DATABASES"));
        return false;
    }

    protected ArrayList<String> getStartupArguments() {
        ArrayList<String> rtnArgsList = new ArrayList<String>();
        if (this.port != 9001) {
            rtnArgsList.add("-port");
            rtnArgsList.add(Integer.toString(this.port));
        }
        rtnArgsList.add("-no_system_exit");
        rtnArgsList.add("true");
        int idx = 0;
        for (Map.Entry<String, String> entry : this.databases.entrySet()) {
            rtnArgsList.add("-database." + idx);
            rtnArgsList.add(entry.getValue());
            rtnArgsList.add("-dbname." + idx);
            rtnArgsList.add(entry.getKey());
            logger.debug((Object)MessageFormat.format("Hsqldb database {0} configured to start with name {1}", entry.getValue(), entry.getKey()));
            ++idx;
        }
        return rtnArgsList;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public int getPort() {
        return this.port;
    }

    public Map<String, String> getDatabases() {
        return this.databases;
    }

    public void setDatabases(Map<String, String> databases) {
        this.databases = databases;
    }

    public void setAllowPortFailover(boolean value) {
        this.allowFailoverToDefaultPort = value;
    }

    public boolean getAllowPortFailover() {
        return this.allowFailoverToDefaultPort;
    }
}

