/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IContentOutputHandler;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IOutputDef;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.HttpContentItem;
import org.pentaho.platform.web.http.messages.Messages;

public class HttpOutputHandler
implements IOutputHandler,
IMimeTypeListener {
    private static final Log logger = LogFactory.getLog(HttpOutputHandler.class);
    private HttpServletResponse response;
    protected IContentItem outputContent;
    private IContentItem feedbackContent;
    boolean allowFeedback;
    @Deprecated
    private boolean contentGenerated;
    private IPentahoSession session;
    private IMimeTypeListener mimeTypeListener;
    protected IRuntimeContext runtimeContext;
    private int outputType = 3;
    private OutputStream destinationOutputStream;
    private boolean responseExpected;

    public HttpOutputHandler(HttpServletResponse response, OutputStream outputStream, boolean allowFeedback) {
        this.response = response;
        this.destinationOutputStream = outputStream;
        this.outputContent = new HttpContentItem(this.destinationOutputStream, this);
        ((HttpContentItem)this.outputContent).setMimeTypeListener(this);
        this.feedbackContent = new HttpContentItem(this.destinationOutputStream, this);
        this.allowFeedback = allowFeedback;
        this.contentGenerated = false;
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public void setOutputPreference(int outputType) {
        this.outputType = outputType;
    }

    public int getOutputPreference() {
        return this.outputType;
    }

    public void setMimeType(String mimeType) {
        if (this.mimeTypeListener != null) {
            this.mimeTypeListener.setMimeType(mimeType);
        }
        this.response.setContentType(mimeType);
    }

    public void setName(String name) {
        if (this.mimeTypeListener != null) {
            this.mimeTypeListener.setName(name);
        }
    }

    @Deprecated
    public boolean contentDone() {
        return this.contentGenerated;
    }

    public boolean allowFeedback() {
        return this.allowFeedback;
    }

    public Map getOutputDefs() {
        return null;
    }

    public IOutputDef getOutputDef(String name) {
        return null;
    }

    public IContentItem getFeedbackContentItem() {
        if (this.allowFeedback) {
            this.contentGenerated = true;
            this.responseExpected = true;
            return this.feedbackContent;
        }
        return null;
    }

    public IContentItem getOutputContentItem(String objectName, String contentName, String solution, String instanceId, String mimeType) {
        if (objectName.equals("response") && contentName.equals("content")) {
            if (mimeType != null) {
                this.outputContent.setMimeType(mimeType);
            }
            this.contentGenerated = true;
            this.responseExpected = true;
            return this.outputContent;
        }
        IContentOutputHandler output = null;
        if (contentName != null && contentName.indexOf(":") == -1) {
            output = PentahoSystem.getOutputDestinationFromContentRef((String)(objectName + ":" + contentName), (IPentahoSession)this.session);
        } else {
            output = PentahoSystem.getOutputDestinationFromContentRef((String)contentName, (IPentahoSession)this.session);
            if (output == null) {
                output = PentahoSystem.getOutputDestinationFromContentRef((String)(objectName + ":" + contentName), (IPentahoSession)this.session);
            }
        }
        if (output != null) {
            output.setInstanceId(instanceId);
            output.setMimeType(mimeType);
            output.setSolutionName(solution);
            return output.getFileOutputContentItem();
        }
        return null;
    }

    public IContentItem getOutputContentItem(String objectName, String contentName, String title, String url, String solution, String instanceId, String mimeType) {
        return this.getOutputContentItem(objectName, contentName, solution, instanceId, mimeType);
    }

    public void setContentItem(IContentItem content, String objectName, String contentName) {
        if (objectName.equals("response") && contentName.equals("content")) {
            this.setMimeType(content.getMimeType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutput(String name, Object value) {
        block25: {
            if (value == null) {
                logger.warn((Object)Messages.getString("HttpOutputHandler.WARN_0001_VALUE_IS_NULL"));
                return;
            }
            this.responseExpected = true;
            if ("redirect".equalsIgnoreCase(name)) {
                try {
                    this.response.sendRedirect(value.toString());
                }
                catch (IOException ioe) {
                    logger.error((Object)Messages.getString("HttpOutputHandler.ERROR_0001_REDIRECT_FAILED", value.toString()), (Throwable)ioe);
                }
            } else if ("header".equalsIgnoreCase(name)) {
                try {
                    if (value instanceof Map) {
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            this.response.addHeader(entry.getKey().toString(), entry.getValue().toString());
                        }
                        break block25;
                    }
                    String strVal = value.toString();
                    int i = strVal.indexOf(61);
                    String headerName = strVal.substring(0, i);
                    String headerValue = strVal.substring(i + 1);
                    this.response.addHeader(headerName, headerValue);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.error((Object)e.getLocalizedMessage());
                }
            } else if ("content".equalsIgnoreCase(name)) {
                try {
                    if (value instanceof IContentItem) {
                        IContentItem content = (IContentItem)value;
                        InputStream inStr = content.getInputStream();
                        if (inStr == null) break block25;
                        if (this.response.getContentType() == null || !this.response.getContentType().equalsIgnoreCase(content.getMimeType())) {
                            this.setMimeType(content.getMimeType());
                        }
                        try {
                            int inCnt = 0;
                            byte[] buf = new byte[4096];
                            while (-1 != (inCnt = inStr.read(buf))) {
                                this.destinationOutputStream.write(buf, 0, inCnt);
                            }
                        }
                        finally {
                            try {
                                inStr.close();
                            }
                            catch (IOException ignored) {}
                        }
                        this.contentGenerated = true;
                        break block25;
                    }
                    if (this.response.getContentType() == null) {
                        this.setMimeType("text/html");
                    }
                    this.destinationOutputStream.write(value.toString().getBytes());
                    this.contentGenerated = true;
                }
                catch (IOException ioe) {
                    logger.error(null, (Throwable)ioe);
                }
            }
        }
    }

    public IMimeTypeListener getMimeTypeListener() {
        return this.mimeTypeListener;
    }

    public void setMimeTypeListener(IMimeTypeListener mimeTypeListener) {
        this.mimeTypeListener = mimeTypeListener;
    }

    public IContentItem getOutputContent() {
        return this.getOutputContentItem("response", "content", null, null, null);
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }

    public void setRuntimeContext(IRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public boolean isWritable() {
        return false;
    }
}

