/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.ITempFileDeleter;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.session.PentahoHttpSession;

public class PentahoHttpSessionHelper {
    private static final String[] DEFAULT_LOCATIONS = new String[]{"/eclipse/workspace/pentaho-solutions", "/eclipse/workspace/pentaho-samples/solutions/test-solution"};

    public static IPentahoSession getPentahoSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String localeOverride = (String)session.getAttribute("locale_override");
        if (!StringUtils.isEmpty((String)localeOverride)) {
            String UNDERSCORE = "_";
            Locale locale = null;
            String[] tokens = localeOverride.split("_");
            locale = tokens.length == 3 ? new Locale(tokens[0], tokens[1], tokens[2]) : (tokens.length == 2 ? new Locale(tokens[0], tokens[1]) : new Locale(tokens[0]));
            LocaleHelper.setLocaleOverride((Locale)locale);
        } else {
            LocaleHelper.setLocaleOverride(null);
        }
        Object userSession = (IPentahoSession)session.getAttribute("pentaho-session");
        LocaleHelper.setLocale((Locale)request.getLocale());
        if (userSession != null) {
            return userSession;
        }
        userSession = new PentahoHttpSession(request.getRemoteUser(), request.getSession(), request.getLocale(), (IPentahoSession)userSession);
        ITempFileDeleter deleter = (ITempFileDeleter)PentahoSystem.get(ITempFileDeleter.class, (IPentahoSession)userSession);
        if (deleter != null) {
            userSession.setAttribute("PENTAHO_TMP_DELETER", (Object)deleter);
        }
        LocaleHelper.setLocale((Locale)request.getLocale());
        session.setAttribute("pentaho-session", userSession);
        return userSession;
    }

    public static String getSolutionPath(ServletContext context) {
        File pentahoSolutions;
        String rootPath = context.getInitParameter("solution-path");
        if (StringUtils.isNotBlank((String)rootPath) && (pentahoSolutions = new File(rootPath)).exists() && pentahoSolutions.isDirectory()) {
            return rootPath;
        }
        for (String element : DEFAULT_LOCATIONS) {
            pentahoSolutions = new File(element);
            if (!pentahoSolutions.exists() || !pentahoSolutions.isDirectory()) continue;
            try {
                return pentahoSolutions.getCanonicalPath();
            }
            catch (IOException e) {
                return pentahoSolutions.getAbsolutePath();
            }
        }
        for (File file = new File(context.getRealPath("")); file != null; file = file.getParentFile()) {
            if (!file.exists() || !file.isDirectory() || !(pentahoSolutions = new File(file.getAbsolutePath() + File.separator + "pentaho-solutions")).exists() || !pentahoSolutions.isDirectory()) continue;
            try {
                return pentahoSolutions.getCanonicalPath();
            }
            catch (IOException e) {
                return pentahoSolutions.getAbsolutePath();
            }
        }
        return null;
    }
}

