/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public class PreAuthenticatedSessionHolder {
    private final Map<String, SessionAuthenticationTuple> sessionMap = Collections.synchronizedMap(new HashMap());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "PreAuthenticationSessionHolder-Eviction");
            t.setDaemon(true);
            return t;
        }
    });
    private ScheduledFuture<?> scheduleHandle;
    private int TTL = 600000;
    private int evictionInterval = 60;

    public PreAuthenticatedSessionHolder(int ttl, int evictionInterval) {
        this.TTL = ttl * 1000;
        this.evictionInterval = evictionInterval;
        this.initializeEvictionSchedule();
    }

    public PreAuthenticatedSessionHolder() {
        this.initializeEvictionSchedule();
    }

    private void initializeEvictionSchedule() {
        Runnable sessionCleaner = new Runnable(){

            public void run() {
                for (Map.Entry entry : PreAuthenticatedSessionHolder.this.sessionMap.entrySet()) {
                    if (((SessionAuthenticationTuple)entry.getValue()).entryTime.getTime() + (long)PreAuthenticatedSessionHolder.this.TTL >= new Date().getTime()) continue;
                    PreAuthenticatedSessionHolder.this.sessionMap.remove(entry.getKey());
                }
            }
        };
        this.scheduleHandle = this.scheduler.scheduleWithFixedDelay(sessionCleaner, this.evictionInterval, this.evictionInterval, TimeUnit.SECONDS);
    }

    public String captureSession() {
        SessionAuthenticationTuple tuple = new SessionAuthenticationTuple();
        tuple.session = PentahoSessionHolder.getSession();
        tuple.auth = SecurityContextHolder.getContext().getAuthentication();
        tuple.entryTime = new Date();
        String hash = DigestUtils.md5Hex((byte[])tuple.session.getId().getBytes());
        this.sessionMap.put(hash, tuple);
        return hash;
    }

    public boolean restoreSession(String hash) {
        SessionAuthenticationTuple tuple = this.sessionMap.get(hash);
        if (tuple == null) {
            return false;
        }
        SecurityContextHolder.getContext().setAuthentication(tuple.auth);
        PentahoSessionHolder.setSession((IPentahoSession)tuple.session);
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() {
        if (!this.scheduler.isShutdown()) {
            try {
                this.scheduleHandle.cancel(true);
                this.scheduler.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class SessionAuthenticationTuple {
        IPentahoSession session;
        Authentication auth;
        Date entryTime;

        private SessionAuthenticationTuple() {
        }
    }
}

