/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http;

import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IUITemplater;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.ui.IMenuProvider;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.services.actionsequence.ActionResource;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.messages.Messages;

public class WebTemplateHelper
implements IUITemplater {
    private static String footerTemplate = null;
    private static final String FOOTER_TEMPLATE_FILENAME = "template-footer.html";
    private String headerContent = "";

    public void setHeaderContent(String headerContent) {
        this.headerContent = headerContent;
    }

    public String processTemplate(String template, String title, String content, IPentahoSession session) {
        template = this.processTemplate(template, title, session);
        template = template.replaceFirst("\\{content\\}", content);
        return template;
    }

    public String processTemplate(String template, String title, IPentahoSession session) {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
        if (footerTemplate == null) {
            footerTemplate = this.getTemplate(FOOTER_TEMPLATE_FILENAME, session);
        }
        template = template.replaceAll("\\{menu\\}", this.getMenuHtml(session));
        template = template.replaceFirst("\\{footer\\}", footerTemplate);
        template = template.replaceAll("\\{title\\}", title);
        template = template.replaceAll("\\{home\\}", Messages.getString("UI.USER_HOME"));
        template = template.replaceAll("\\{navigate\\}", Messages.getString("UI.USER_NAVIGATE"));
        template = template.replaceAll("\\{solutions\\}", Messages.getString("UI.USER_SOLUTIONS"));
        template = template.replaceAll("\\{file-cache\\}", Messages.getString("UI.USER_FILE_CACHE"));
        template = template.replaceAll("\\{new-content\\}", Messages.getString("UI.USER_NEW_CONTENT"));
        template = template.replaceAll("\\{file\\}", Messages.getString("UI.USER_FILE"));
        template = template.replaceAll("\\{view\\}", Messages.getString("UI.USER_VIEW"));
        template = template.replaceAll("\\{nightly\\}", Messages.getString("UI.USER_NIGHTLY"));
        template = template.replaceAll("\\{tracker\\}", Messages.getString("UI.USER_TRACKER"));
        template = template.replaceAll("\\{new-report\\}", Messages.getString("UI.USER_NEW_REPORT"));
        template = template.replaceAll("\\{new-view", Messages.getString("UI.USER_NEW_PIVOT"));
        template = template.replaceAll("\\{admin\\}", Messages.getString("UI.USER_ADMIN"));
        template = template.replaceAll("\\{about\\}", Messages.getString("UI.USER_ABOUT"));
        template = template.replaceAll("\\{pentaho.org\\}", Messages.getString("UI.USER_PENTAHO.COM"));
        template = template.replaceAll("\\{close\\}", Messages.getString("UI.USER_CLOSE"));
        template = template.replaceAll("\\{forums\\}", Messages.getString("UI.USER_FORUMS"));
        template = template.replaceAll("\\{demos\\}", Messages.getString("UI.USER_DEMOS"));
        template = template.replaceAll("\\{downloads\\}", Messages.getString("UI.USER_DOWNLOADS"));
        template = template.replaceAll("text/html; charset=utf-8", "text/html; charset=" + LocaleHelper.getSystemEncoding());
        template = template.replaceAll("\\{text-direction\\}", LocaleHelper.getTextDirection());
        template = template.replaceAll("\\{logout\\}", Messages.getString("UI.USER_LOGOUT"));
        template = template.replaceAll("\\{portal\\}", Messages.getString("UI.USER_PORTAL"));
        if (PentahoSystem.getObjectFactory().objectDefined(IVersionHelper.class.getSimpleName())) {
            IVersionHelper versionHelper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, (IPentahoSession)session);
            template = template.replaceAll("\\{version\\}", "Version: " + versionHelper.getVersionInformation(PentahoSystem.class));
        }
        template = template.replaceAll("\\{system\\}", PentahoSystem.getSystemName());
        template = template.replaceAll("\\{isLoggedIn\\}", session.isAuthenticated() ? "true" : "false");
        template = template.replaceAll("\\{background-alert\\}", session.getBackgroundExecutionAlert() ? "true" : "false");
        template = template.replaceAll("\\{header-content\\}", this.headerContent);
        template = template.replaceAll("\\{body-tag\\}", "");
        template = template.replaceAll("\\{isAdmin\\}", SecurityHelper.isPentahoAdministrator((IPentahoSession)session) ? "true" : "false");
        template = template.replaceAll("\\{repository-name\\}", repository.getRepositoryName());
        template = template.replaceAll("\\{copyright\\}", Messages.getString("UI.USER_COPYRIGHT"));
        return template;
    }

    public String getTemplate(String templateName, IPentahoSession session) {
        ActionResource resource = new ActionResource("", 1, "text/xml", "system/custom/" + templateName);
        String template = null;
        try {
            template = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session)).getResourceAsString((IActionSequenceResource)resource, 1);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (template == null) {
            return Messages.getString("UI.ERROR_0001_BAD_TEMPLATE", resource.getAddress());
        }
        return template;
    }

    public String[] breakTemplate(String templateName, String title, IPentahoSession session) {
        String template = this.getTemplate(templateName, session);
        return this.breakTemplateString(template, title, session);
    }

    public String[] breakTemplateString(String template, String title, IPentahoSession session) {
        String token = "{content}";
        int index = (template = this.processTemplate(template, title, session)).indexOf(token);
        if (index == -1) {
            return new String[]{template};
        }
        String[] sections = new String[]{template.substring(0, index), template.substring(index + token.length())};
        return sections;
    }

    public String getMenuHtml(IPentahoSession session) {
        IMenuProvider menuProvider = (IMenuProvider)PentahoSystem.get(IMenuProvider.class, (IPentahoSession)session);
        if (menuProvider != null) {
            return menuProvider.getMenuBar("menu", "system/ui/menubar.xul", session).toString();
        }
        Logger.error((String)WebTemplateHelper.class.getName(), (String)Messages.getString("WebTemplateHelper.ERROR_0001_COULD_NOT_CREATE_MENUBAR"));
        return "";
    }
}

