/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.context;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.PentahoHttpSessionHelper;
import org.pentaho.platform.web.http.context.WebApplicationContext;
import org.pentaho.platform.web.http.messages.Messages;

public class SolutionContextListener
implements ServletContextListener {
    protected static String solutionPath;
    protected static String contextPath;
    private static final String DEFAULT_SPRING_CONFIG_FILE_NAME = "pentahoObjects.spring.xml";

    public void contextInitialized(ServletContextEvent event) {
        Locale[] locales;
        String textDirection;
        ServletContext context = event.getServletContext();
        String encoding = context.getInitParameter("encoding");
        if (encoding != null) {
            LocaleHelper.setSystemEncoding((String)encoding);
        }
        if ((textDirection = context.getInitParameter("text-direction")) != null) {
            LocaleHelper.setTextDirection((String)textDirection);
        }
        String localeLanguage = context.getInitParameter("locale-language");
        String localeCountry = context.getInitParameter("locale-country");
        boolean localeSet = false;
        if (localeLanguage != null && !"".equals(localeLanguage) && localeCountry != null && !"".equals(localeCountry) && (locales = Locale.getAvailableLocales()) != null) {
            for (Locale element : locales) {
                if (!element.getLanguage().equals(localeLanguage) || !element.getCountry().equals(localeCountry)) continue;
                LocaleHelper.setLocale((Locale)element);
                localeSet = true;
                break;
            }
        }
        if (!localeSet) {
            LocaleHelper.setLocale((Locale)Locale.getDefault());
        }
        LocaleHelper.setDefaultLocale((Locale)LocaleHelper.getLocale());
        Logger.info((String)SolutionContextListener.class.getName(), (String)Messages.getString("SolutionContextListener.INFO_INITIALIZING"));
        Logger.info((String)SolutionContextListener.class.getName(), (String)(Messages.getString("SolutionContextListener.INFO_SERVLET_CONTEXT") + context));
        contextPath = context.getRealPath("");
        Logger.info((String)SolutionContextListener.class.getName(), (String)(Messages.getString("SolutionContextListener.INFO_CONTEXT_PATH") + contextPath));
        solutionPath = PentahoHttpSessionHelper.getSolutionPath(context);
        if (StringUtils.isEmpty((String)solutionPath)) {
            String errorMsg = Messages.getErrorString("SolutionContextListener.ERROR_0001_NO_ROOT_PATH");
            Logger.error((String)this.getClass().getName(), (String)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        Logger.info((String)this.getClass().getName(), (String)(Messages.getString("SolutionContextListener.INFO_ROOT_PATH") + solutionPath));
        String fullyQualifiedServerUrl = context.getInitParameter("fully-qualified-server-url");
        if (fullyQualifiedServerUrl == null) {
            fullyQualifiedServerUrl = "http://localhost:8080/pentaho/";
        }
        WebApplicationContext applicationContext = new WebApplicationContext(solutionPath, fullyQualifiedServerUrl, context.getRealPath(""), context);
        Properties props = new Properties();
        Enumeration initParmNames = context.getInitParameterNames();
        while (initParmNames.hasMoreElements()) {
            String initParmName = (String)initParmNames.nextElement();
            props.setProperty(initParmName, context.getInitParameter(initParmName));
        }
        applicationContext.setProperties(props);
        this.setSystemCfgFile(context);
        this.setObjectFactory(context);
        boolean initOk = PentahoSystem.init((IApplicationContext)applicationContext);
        this.showInitializationMessage(initOk, fullyQualifiedServerUrl);
    }

    private void setObjectFactory(ServletContext context) {
        IPentahoObjectFactory pentahoObjectFactory;
        String SYSTEM_FOLDER = "/system";
        String pentahoObjectFactoryClassName = context.getInitParameter("pentahoObjectFactory");
        String pentahoObjectFactoryConfigFile = context.getInitParameter("pentahoObjectFactoryCfgFile");
        if (StringUtils.isEmpty((String)pentahoObjectFactoryConfigFile)) {
            pentahoObjectFactoryConfigFile = solutionPath + "/system" + "/" + DEFAULT_SPRING_CONFIG_FILE_NAME;
        } else if (-1 == pentahoObjectFactoryConfigFile.indexOf("/")) {
            pentahoObjectFactoryConfigFile = solutionPath + "/system" + "/" + pentahoObjectFactoryConfigFile;
        }
        try {
            Class<?> classObject = Class.forName(pentahoObjectFactoryClassName);
            pentahoObjectFactory = (IPentahoObjectFactory)classObject.newInstance();
        }
        catch (Exception e) {
            String msg = Messages.getErrorString("SolutionContextListener.ERROR_0002_BAD_OBJECT_FACTORY", pentahoObjectFactoryClassName);
            throw new RuntimeException(msg, e);
        }
        pentahoObjectFactory.init(pentahoObjectFactoryConfigFile, (Object)context);
        PentahoSystem.setObjectFactory((IPentahoObjectFactory)pentahoObjectFactory);
    }

    private void setSystemCfgFile(ServletContext context) {
        String webSpecifiedSysCfgPath;
        String jvmSpecifiedSysCfgPath = System.getProperty("PENTAHO_SYS_CFG_PATH");
        if (StringUtils.isBlank((String)jvmSpecifiedSysCfgPath) && StringUtils.isNotBlank((String)(webSpecifiedSysCfgPath = context.getInitParameter("pentaho-system-cfg")))) {
            System.setProperty("PENTAHO_SYS_CFG_PATH", webSpecifiedSysCfgPath);
        }
    }

    public void showInitializationMessage(boolean initOk, String fullyQualifiedServerUrl) {
        if (PentahoSystem.getObjectFactory().objectDefined(IVersionHelper.class.getSimpleName())) {
            IVersionHelper helper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, null);
            if (initOk) {
                System.out.println(Messages.getString("SolutionContextListener.INFO_SYSTEM_READY", "(" + helper.getVersionInformation(PentahoSystem.class) + ")", fullyQualifiedServerUrl, solutionPath));
            } else {
                System.err.println(Messages.getString("SolutionContextListener.INFO_SYSTEM_NOT_READY", "(" + helper.getVersionInformation(PentahoSystem.class) + ")", fullyQualifiedServerUrl, solutionPath));
            }
        }
    }

    protected String getContextPath() {
        return contextPath;
    }

    protected String getRootPath() {
        return solutionPath;
    }

    public void contextDestroyed(ServletContextEvent event) {
        PentahoSystem.shutdown();
        if (LocaleHelper.getLocale() == null) {
            LocaleHelper.setLocale((Locale)Locale.getDefault());
        }
        Logger.info((String)SolutionContextListener.class.getName(), (String)Messages.getString("SolutionContextListener.INFO_SYSTEM_EXITING"));
    }
}

