/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;

public class ProxyTrustingFilter
implements Filter {
    FilterConfig filterConfig;
    String[] trustedIpAddrs = null;
    private Map<String, Pattern> ipPatterns = new HashMap<String, Pattern>();
    private static final Log logger = LogFactory.getLog(ProxyTrustingFilter.class);

    public Log getLogger() {
        return logger;
    }

    public void init(FilterConfig filterConfiguration) throws ServletException {
        this.filterConfig = filterConfiguration;
        this.trustedIpAddrs = null;
        String hostStr = this.filterConfig.getInitParameter("TrustedIpAddrs");
        if (hostStr != null) {
            StringTokenizer st = new StringTokenizer(hostStr, ",");
            ArrayList<String> addrs = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (tok.length() <= 0) continue;
                addrs.add(tok);
            }
            if (addrs.size() > 0) {
                this.trustedIpAddrs = addrs.toArray(new String[0]);
            }
        }
    }

    boolean isTrusted(String addr) {
        if (this.trustedIpAddrs != null) {
            for (String element : this.trustedIpAddrs) {
                Matcher matcher;
                if (element.equals(addr)) {
                    return true;
                }
                Pattern pat = this.ipPatterns.get(element);
                if (pat == null) {
                    try {
                        pat = Pattern.compile(element);
                        this.ipPatterns.put(element, pat);
                    }
                    catch (PatternSyntaxException ignored) {
                        continue;
                    }
                }
                if (!(matcher = pat.matcher(addr)).find()) continue;
                return true;
            }
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String name;
        HttpServletRequest req;
        String remoteHost;
        if (this.trustedIpAddrs != null && request instanceof HttpServletRequest && this.isTrusted(remoteHost = (req = (HttpServletRequest)request).getRemoteAddr()) && (name = request.getParameter("_TRUST_USER_")) != null && name.length() > 0) {
            IPentahoSession userSession = null;
            boolean reset = false;
            IPentahoSession existingSession = (IPentahoSession)req.getSession().getAttribute("pentaho-session");
            if (!(existingSession == null || existingSession.getName() != null && name.equals(existingSession.getName()))) {
                reset = true;
            }
            IUserDetailsRoleListService userDetailsRoleListService = PentahoSystem.getUserDetailsRoleListService();
            if (reset || existingSession == null && userDetailsRoleListService != null) {
                HttpSession httpSession = req.getSession();
                userSession = userDetailsRoleListService.getEffectiveUserSession(name, null);
                if (existingSession != null) {
                    this.copyAttributesBetweenSessions(userSession, existingSession);
                    userSession = existingSession;
                }
                Authentication auth = (Authentication)userSession.getAttribute("SECURITY_PRINCIPAL");
                httpSession.setAttribute("pentaho-session", (Object)userSession);
                SecurityContext authWrapper = new SecurityContext(){
                    private static final long serialVersionUID = 1L;
                    private Authentication authentication;

                    public Authentication getAuthentication() {
                        return this.authentication;
                    }

                    public void setAuthentication(Authentication authentication) {
                        this.authentication = authentication;
                    }
                };
                authWrapper.setAuthentication(auth);
                httpSession.setAttribute("SPRING_SECURITY_CONTEXT", (Object)authWrapper);
                PentahoSessionHolder.setSession((IPentahoSession)userSession);
            }
        }
        chain.doFilter(request, response);
    }

    private void copyAttributesBetweenSessions(IPentahoSession from, IPentahoSession to) {
        Iterator it = to.getAttributeNames();
        while (it.hasNext()) {
            to.removeAttribute((String)it.next());
        }
        it = from.getAttributeNames();
        while (it.hasNext()) {
            String attrName = (String)it.next();
            to.setAttribute(attrName, from.getAttribute(attrName));
        }
    }

    public void destroy() {
    }

    public static void main(String[] args) {
    }
}

