/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.request;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.web.http.PentahoHttpSessionHelper;

public class PentahoHttpRequestListener
implements ServletRequestListener {
    protected final Log logger = LogFactory.getLog(PentahoHttpRequestListener.class);

    public void requestDestroyed(ServletRequestEvent sre) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("unbinding session " + PentahoSessionHolder.getSession() + " from request: " + sre.getServletRequest()));
        }
        PentahoSessionHolder.removeSession();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        if (!(sre.getServletRequest() instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
        IPentahoSession session = PentahoHttpSessionHelper.getPentahoSession(request);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("binding session " + session + " to request " + sre.getServletRequest()));
        }
        PentahoSessionHolder.setSession((IPentahoSession)PentahoHttpSessionHelper.getPentahoSession(request));
    }
}

