/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.web.http.messages.Messages;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.security.ui.WebAuthenticationDetails;
import org.springframework.util.Assert;

public class RequestParameterAuthenticationFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RequestParameterAuthenticationFilter.class);
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationManager authenticationManager;
    private boolean ignoreFailure = false;
    private static final String DefaultUserNameParameter = "userid";
    private static final String DefaultPasswordParameter = "password";
    private String userNameParameter = "userid";
    private String passwordParameter = "password";

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)Messages.getErrorString("RequestParameterAuthenticationFilter.ERROR_0001_AUTHMGR_REQUIRED"));
        Assert.notNull((Object)this.authenticationEntryPoint, (String)Messages.getErrorString("RequestParameterAuthenticationFilter.ERROR_0002_AUTHM_ENTRYPT_REQUIRED"));
        Assert.hasText((String)this.userNameParameter, (String)Messages.getString("RequestParameterAuthenticationFilter.ERROR_0003_USER_NAME_PARAMETER_MISSING"));
        Assert.hasText((String)this.passwordParameter, (String)Messages.getString("RequestParameterAuthenticationFilter.ERROR_0004_PASSWORD_PARAMETER_MISSING"));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication existingAuth;
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException(Messages.getErrorString("RequestParameterAuthenticationFilter.ERROR_0005_HTTP_SERVLET_REQUEST_REQUIRED"));
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException(Messages.getErrorString("RequestParameterAuthenticationFilter.ERROR_0006_HTTP_SERVLET_RESPONSE_REQUIRED"));
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String username = httpRequest.getParameter(this.userNameParameter);
        String password = httpRequest.getParameter(this.passwordParameter);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getString("RequestParameterAuthenticationFilter.DEBUG_AUTH_USERID", username));
        }
        if (!(username == null || password == null || (existingAuth = SecurityContextHolder.getContext().getAuthentication()) != null && existingAuth.getName().equals(username) && existingAuth.isAuthenticated())) {
            Authentication authResult;
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            authRequest.setDetails((Object)new WebAuthenticationDetails(httpRequest));
            try {
                authResult = this.authenticationManager.authenticate((Authentication)authRequest);
            }
            catch (AuthenticationException failed) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getString("RequestParameterAuthenticationFilter.DEBUG_AUTHENTICATION_REQUEST", username, failed.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(null);
                if (this.ignoreFailure) {
                    chain.doFilter(request, response);
                } else {
                    this.authenticationEntryPoint.commence(request, response, failed);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getString("RequestParameterAuthenticationFilter.DEBUG_AUTH_SUCCESS", authResult.toString()));
            }
            SecurityContextHolder.getContext().setAuthentication(authResult);
        }
        chain.doFilter(request, response);
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public String getUserNameParameter() {
        return this.userNameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setUserNameParameter(String value) {
        this.userNameParameter = value;
    }

    public void setPasswordParameter(String value) {
        this.passwordParameter = value;
    }
}

