/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.web.http.PentahoHttpSessionHelper;
import org.springframework.security.context.SecurityContextHolder;

public class SecurityStartupFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(SecurityStartupFilter.class);
    public static String anonymousUser;
    private boolean injectAnonymous = true;

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        IPentahoSession userSession = this.getPentahoSession(request);
        String user = request.getRemoteUser();
        if (user != null) {
            Principal principal;
            boolean wasAnonymous = false;
            if (!userSession.isAuthenticated() || this.isAnonymous(userSession)) {
                if (this.isAnonymous(userSession)) {
                    wasAnonymous = true;
                }
                userSession.setAuthenticated(user);
            }
            if ((principal = SecurityHelper.getPrincipal((IPentahoSession)userSession)) == null || wasAnonymous) {
                principal = SecurityContextHolder.getContext().getAuthentication();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)principal);
                }
                SecurityHelper.setPrincipal((Principal)principal, (IPentahoSession)userSession);
                try {
                    PentahoSessionParameterProvider sessionParameters = new PentahoSessionParameterProvider(userSession);
                    PentahoSystem.sessionStartup((IPentahoSession)userSession, (IParameterProvider)sessionParameters);
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            filterChain.doFilter((ServletRequest)request, servletResponse);
        } else {
            if (this.injectAnonymous) {
                userSession.setAuthenticated(this.getAnonymousUser());
            }
            filterChain.doFilter((ServletRequest)request, servletResponse);
        }
    }

    protected IPentahoSession getPentahoSession(HttpServletRequest request) {
        return PentahoHttpSessionHelper.getPentahoSession(request);
    }

    public void setInjectAnonymous(boolean injectAnonymous) {
        this.injectAnonymous = injectAnonymous;
    }

    protected String getAnonymousUser() {
        if (anonymousUser == null) {
            anonymousUser = PentahoSystem.getSystemSetting((String)"anonymous-authentication/anonymous-user", (String)"anonymousUser");
        }
        return anonymousUser;
    }

    protected boolean isAnonymous(IPentahoSession pentahoSession) {
        return this.getAnonymousUser().equals(pentahoSession.getName());
    }
}

