/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.session;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.messages.Messages;

public class PentahoHttpSessionListener
implements HttpSessionListener {
    private static final boolean debug = true;
    private static final Map<String, String[]> sessionMap = new HashMap<String, String[]>();

    public void sessionCreated(HttpSessionEvent event) {
        LocaleHelper.setLocale((Locale)Locale.getDefault());
        String sessionId = event.getSession().getId();
        Logger.debug((Object)this, (String)Messages.getString("HttpSessionListener.DEBUG_SESSION_CREATED", sessionId));
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        try {
            if (session != null) {
                String sessionId = event.getSession().getId();
                Object obj = session.getAttribute("pentaho-session-context");
                if (obj != null) {
                    IPentahoSession userSession = (IPentahoSession)obj;
                    userSession.destroy();
                } else {
                    String[] info = PentahoHttpSessionListener.getSessionInfo(sessionId);
                    if (info != null) {
                        String instanceId = info[5];
                        String userId = info[3];
                        String activityId = info[1];
                        String objectType = info[2];
                        String processId = info[0];
                        String messageType = "session_end";
                        String message = "http ";
                        String value = "";
                        long startTime = Long.parseLong(info[4]);
                        long endTime = new Date().getTime();
                        AuditHelper.audit((String)instanceId, (String)userId, (String)activityId, (String)objectType, (String)processId, (String)messageType, (String)message, (String)value, (float)((endTime - startTime) / 1000L), null);
                    }
                }
            }
        }
        catch (Throwable e) {
            Logger.error((Object)this, (String)Messages.getErrorString("HttpSessionListener.ERROR_0001_ERROR_DESTROYING_SESSION"), (Throwable)e);
        }
    }

    public static void registerHttpSession(String sessionId, String processId, String activityId, String objectName, String userName, String id, long start) {
        sessionMap.put(id, new String[]{processId, activityId, objectName, userName, new Long(start).toString(), sessionId});
    }

    public static void deregisterHttpSession(String id) {
        sessionMap.remove(id);
    }

    private static String[] getSessionInfo(String id) {
        return sessionMap.get(id);
    }
}

