/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.refactor;

import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.web.http.messages.Messages;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;

public class SolutionManagerUIComponent
extends XmlComponent {
    private static final long serialVersionUID = 5322450732426274853L;
    private static final Log logger = LogFactory.getLog(SolutionManagerUIComponent.class);
    private static final String PATH_STR = "path";
    private static final String EMPTY_STR = "";
    private static final String BASE_URL_STR = "baseUrl";
    private IPentahoSession session = null;

    public SolutionManagerUIComponent(IPentahoUrlFactory urlFactory, List messages, IPentahoSession session) {
        super(urlFactory, messages, null);
        this.session = session;
        this.setXsl("text/xml", "copy.xsl");
    }

    public Document doGetSolutionStructure() {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.session);
        Document doc = repository.getSolutionStructure(60);
        return doc;
    }

    public Document doFileUpload() {
        String baseUrl = PentahoSystem.getApplicationContext().getSolutionPath(EMPTY_STR);
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.session);
        String path = this.getParameter(PATH_STR, null);
        IParameterProvider request = (IParameterProvider)this.getParameterProviders().get("request");
        HttpServletRequest httpRequest = ((HttpRequestParameterProvider)request).getRequest();
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest)) {
            return this.doGetSolutionStructure();
        }
        ServletFileUpload uploader = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        try {
            List fileList = uploader.parseRequest(httpRequest);
            for (FileItem fi : fileList) {
                if (fi.isFormField()) continue;
                File tempFileRef = new File(fi.getName());
                repository.addSolutionFile(baseUrl, path, tempFileRef.getName(), fi.get(), true);
                logger.info((Object)(Messages.getString("SolutionManagerUIComponent.INFO_0001_FILE_SAVED") + path + "/" + tempFileRef.getName()));
            }
        }
        catch (FileUploadException e) {
            logger.error((Object)e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.doGetSolutionStructure();
    }

    public Document getXmlContent() {
        this.setXslProperty(BASE_URL_STR, this.urlFactory.getDisplayUrlBuilder().getUrl());
        return this.doFileUpload();
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }
}

