/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.refactor;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IScheduledJob;
import org.pentaho.platform.api.engine.ISubscriptionScheduler;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.engine.SubscriptionSchedulerException;
import org.pentaho.platform.api.repository.ISchedule;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.repository.ISubscribeContent;
import org.pentaho.platform.api.repository.ISubscription;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.api.repository.SubscriptionAdminException;
import org.pentaho.platform.api.repository.SubscriptionRepositoryCheckedException;
import org.pentaho.platform.api.util.PentahoCheckedChainedException;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SolutionCompare;
import org.pentaho.platform.repository.subscription.Schedule;
import org.pentaho.platform.repository.subscription.SubscribeContent;
import org.pentaho.platform.repository.subscription.SubscriptionHelper;
import org.pentaho.platform.repository.subscription.SubscriptionRepositoryHelper;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.util.client.PublisherUtil;
import org.pentaho.platform.web.http.messages.Messages;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionAdminUIComponent
extends XmlComponent {
    private static final long serialVersionUID = 2963902264708970015L;
    public static final String SCHEDULER_ACTION = "schedulerAction";
    public static final String NODE_SUBSCRIPTION_ADMIN = "subscriptionAdmin";
    public static final String NODE_CMD_RESULT = "commandResult";
    public static final String NODE_EXCEPTION = "exception";
    public static final String NODE_PARAM_ERRORS = "paramErrors";
    public static final String NODE_PARAM_MISSING = "paramMissing";
    public static final String NODE_CONTENT = "content";
    public static final String NODE_SCHEDULER_STATUS = "schedulerStatus";
    public static final String NODE_RESULT_MSG = "message";
    public static final String NODE_RESULT_TYPE = "result";
    public static final String NODE_RETURN_URL = "returnURL";
    public static final String NODE_RETURN_PARAM = "returnParam";
    public static final String NODE_STATUS_OK = "OK";
    public static final String NODE_STATUS_ERROR = "ERROR";
    public static final String NODE_STATUS_WARNING = "WARNING";
    public static final String NODE_STATUS_INFO = "INFO";
    public static final String ACTION_JOB_DO_PAUSE = "doPauseJob";
    public static final String ACTION_JOB_DO_RESUME = "doResumeJob";
    public static final String ACTION_JOB_DO_DELETE = "doDeleteJob";
    public static final String ACTION_JOB_DO_EXECUTE = "doExecuteJob";
    public static final String ACTION_JOB_DO_SCHEDULE = "doScheduleJob";
    public static final String ACTION_SCHEDULER_DO_RESUME = "doResumeScheduler";
    public static final String ACTION_SCHEDULER_DO_SUSPEND = "doSuspendScheduler";
    public static final String ACTION_SCHEDULE_SHOW_DETAILS = "scheduleDetails";
    public static final String ACTION_SCHEDULE_SHOW_ADD = "addSchedule";
    public static final String ACTION_SCHEDULE_DO_ADD = "doAddSchedule";
    public static final String ACTION_SCHEDULE_DO_ADD_CONTENT = "doAddContentForSchedule";
    public static final String ACTION_SCHEDULE_SHOW_ADD_CONTENT = "addContentForSchedule";
    public static final String ACTION_SCHEDULE_SHOW_EDIT = "editSchedule";
    public static final String ACTION_SCHEDULE_DO_EDIT = "doEditSchedule";
    public static final String ACTION_SCHEDULE_DO_DELETE = "doDeleteSchedule";
    public static final String ACTION_SCHEDULE_DO_DELETE_CONTENT = "doDeleteContentForSchedule";
    public static final String ACTION_SCHEDULE_SHOW_LIST = "listSchedules";
    public static final String ACTION_ADD_SCHEDULE_AND_CONTENT = "doAddScheduleAndContent";
    public static final String ACTION_ADD_SCHEDULE_WITHOUT_CONTENT = "doAddScheduleWithoutContent";
    public static final String ACTION_EDIT_SCHEDULE_AND_CONTENT = "doEditScheduleAndContent";
    public static final String ACTION_EDIT_SCHEDULE_WITHOUT_CONTENT = "doEditScheduleWithoutContent";
    public static final String ACTION_DELETE_SCHEDULE_CONTENT_AND_SUBSCRIPTION = "doDeleteScheduleContentAndSubscription";
    public static final String ACTION_SCHEDULE_ALL_JOBS = "scheduleAll";
    public static final String ACTION_CONTENT_SHOW_LIST = "listContent";
    public static final String ACTION_CONTENT_SHOW_EDIT = "editContent";
    public static final String ACTION_CONTENT_DO_EDIT = "doEditContent";
    public static final String ACTION_CONTENT_SHOW_ADD = "addContent";
    public static final String ACTION_CONTENT_SHOW_ADD_SCHEDULE = "addScheduleForContent";
    public static final String ACTION_CONTENT_DO_ADD_SCHEDULE = "doAddScheduleForContent";
    public static final String ACTION_CONTENT_DO_SET = "doSetContent";
    public static final String ACTION_CONTENT_DO_ADD = "doAddContent";
    public static final String ACTION_CONTENT_DO_DELETE = "doDeleteContent";
    public static final String ACTION_SUBSCRIPTION_SHOW_LIST = "listSubscriptions";
    public static final String ACTION_SUBSCRIPTION_DO_DELETE = "doDeleteSubscription";
    public static final String ACTION_SHOW_IMPORT = "showImport";
    public static final String ACTION_DO_IMPORT = "doImport";
    private ISubscriptionScheduler scheduler = (ISubscriptionScheduler)PentahoSystem.get(ISubscriptionScheduler.class, (IPentahoSession)this.getSession());
    private ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getSession());
    private static final Map<String, String> PARAM_NAME_TO_FRIENDLY_NAME = new HashMap<String, String>();
    private static final Log logger;
    private static final String PublishConfigFile = "publisher_config.xml";

    public SubscriptionAdminUIComponent(IPentahoUrlFactory urlFactory, List messages) throws SubscriptionAdminException {
        super(urlFactory, messages, null);
        if (this.subscriptionRepository == null) {
            this.error(Messages.getErrorString("PentahoSystem.ERROR_0003_SUBSCRIPTION_REPOSITORY_NOT_INITIALIZED"));
            throw new SubscriptionAdminException(Messages.getErrorString("PentahoSystem.ERROR_0003_SUBSCRIPTION_REPOSITORY_NOT_INITIALIZED"));
        }
        this.setXsl("text/html", "SubscriptionAdmin.xsl");
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }

    public Document getXmlContent() {
        this.setXslProperty("baseUrl", this.urlFactory.getDisplayUrlBuilder().getUrl());
        String schedulerActionStr = this.getParameter(SCHEDULER_ACTION, ACTION_SCHEDULE_SHOW_LIST);
        try {
            if (ACTION_ADD_SCHEDULE_AND_CONTENT.equals(schedulerActionStr)) {
                return this.doAddScheduleAndContent();
            }
            if (ACTION_ADD_SCHEDULE_WITHOUT_CONTENT.equals(schedulerActionStr)) {
                return this.doAddScheduleWithoutContent();
            }
            if (ACTION_EDIT_SCHEDULE_AND_CONTENT.equals(schedulerActionStr)) {
                return this.doEditScheduleAndContent();
            }
            if (ACTION_EDIT_SCHEDULE_WITHOUT_CONTENT.equals(schedulerActionStr)) {
                return this.doEditScheduleWithoutContent();
            }
            if (ACTION_DELETE_SCHEDULE_CONTENT_AND_SUBSCRIPTION.equals(schedulerActionStr)) {
                return this.doDeleteScheduleContentAndSubscription();
            }
            if (ACTION_SCHEDULE_SHOW_LIST.equals(schedulerActionStr)) {
                return this.showAdminPageUI(null);
            }
            if (ACTION_SCHEDULE_SHOW_EDIT.equals(schedulerActionStr)) {
                return this.showEditScheduleUI(null);
            }
            if (ACTION_SCHEDULE_DO_EDIT.equals(schedulerActionStr)) {
                if (this.getParameter("editDelete", null) != null) {
                    return this.doDeleteSchedule();
                }
                if (this.getParameter("editAdd", null) != null) {
                    return this.doAddSchedule();
                }
                return this.doEditSchedule();
            }
            if (ACTION_SCHEDULE_DO_DELETE.equals(schedulerActionStr)) {
                return this.doDeleteSchedule();
            }
            if (ACTION_SCHEDULE_SHOW_ADD.equals(schedulerActionStr)) {
                return this.showAddScheduleUI(null);
            }
            if (ACTION_SCHEDULE_DO_ADD.equals(schedulerActionStr)) {
                return this.doAddSchedule();
            }
            if (ACTION_SCHEDULE_SHOW_ADD_CONTENT.equals(schedulerActionStr)) {
                return this.showAddContentForScheduleUI();
            }
            if (ACTION_SCHEDULE_DO_DELETE_CONTENT.equals(schedulerActionStr)) {
                return this.doDeleteContentForSchedule();
            }
            if (ACTION_SCHEDULE_DO_ADD_CONTENT.equals(schedulerActionStr)) {
                return this.doAddContentForSchedule();
            }
            if (ACTION_SCHEDULE_SHOW_DETAILS.equals(schedulerActionStr)) {
                return this.showCommandResultUI(this.getInfoMessage("TODO: Implement scheduleDetails"), NODE_STATUS_INFO);
            }
            if (ACTION_JOB_DO_SCHEDULE.equals(schedulerActionStr)) {
                return this.doScheduleJob();
            }
            if (ACTION_SCHEDULE_ALL_JOBS.equals(schedulerActionStr)) {
                return this.doScheduleAllJobs();
            }
            if (ACTION_CONTENT_SHOW_EDIT.equals(schedulerActionStr)) {
                return this.showEditContentUI(null);
            }
            if (ACTION_CONTENT_DO_EDIT.equals(schedulerActionStr)) {
                if (this.getParameter("editDelete", null) != null) {
                    return this.doDeleteContent();
                }
                if (this.getParameter("editAdd", null) != null) {
                    return this.doSetContent();
                }
                return this.doEditContent();
            }
            if (ACTION_CONTENT_DO_DELETE.equals(schedulerActionStr)) {
                return this.doDeleteContent();
            }
            if (ACTION_CONTENT_DO_SET.equals(schedulerActionStr)) {
                return this.doSetContent();
            }
            if (ACTION_CONTENT_DO_ADD.equals(schedulerActionStr)) {
                return this.doAddContent();
            }
            if (ACTION_CONTENT_SHOW_ADD.equals(schedulerActionStr)) {
                return this.showAddContentUI(null);
            }
            if (ACTION_CONTENT_SHOW_ADD_SCHEDULE.equals(schedulerActionStr)) {
                return this.showAddScheduleForContentUI();
            }
            if (ACTION_CONTENT_DO_ADD_SCHEDULE.equals(schedulerActionStr)) {
                return this.doAddScheduleForContent();
            }
            if (ACTION_JOB_DO_EXECUTE.equals(schedulerActionStr)) {
                return this.doJobAction(ACTION_JOB_DO_EXECUTE);
            }
            if (ACTION_JOB_DO_DELETE.equals(schedulerActionStr)) {
                return this.doJobAction(ACTION_JOB_DO_DELETE);
            }
            if (ACTION_JOB_DO_PAUSE.equals(schedulerActionStr)) {
                return this.doJobAction(ACTION_JOB_DO_PAUSE);
            }
            if (ACTION_JOB_DO_RESUME.equals(schedulerActionStr)) {
                return this.doJobAction(ACTION_JOB_DO_RESUME);
            }
            if (ACTION_SCHEDULER_DO_RESUME.equals(schedulerActionStr)) {
                return this.doResumeScheduler();
            }
            if (ACTION_SCHEDULER_DO_SUSPEND.equals(schedulerActionStr)) {
                return this.doPauseScheduler();
            }
            if (ACTION_SUBSCRIPTION_SHOW_LIST.equals(schedulerActionStr)) {
                return this.showSubscriptionsPageUI(null);
            }
            if (ACTION_SUBSCRIPTION_DO_DELETE.equals(schedulerActionStr)) {
                return this.doDeleteSubscription();
            }
            if (ACTION_SHOW_IMPORT.equals(schedulerActionStr)) {
                return this.showImportUI();
            }
            if (ACTION_DO_IMPORT.equals(schedulerActionStr)) {
                return this.doImport();
            }
        }
        catch (ParameterValidationException e) {
            logger.error((Object)e.getMessage());
            Element errorEl = this.getErrorMessage(e.getMessage());
            return this.getDocument(NODE_EXCEPTION, errorEl);
        }
        catch (CronStringException e) {
            logger.error((Object)e.getMessage());
            Element errorEl = this.getErrorMessage(e.getMessage());
            return this.getDocument(NODE_EXCEPTION, errorEl);
        }
        catch (SubscriptionRepositoryCheckedException e) {
            logger.error((Object)e.getMessage());
            Element errorEl = this.getErrorMessage(e.getMessage());
            return this.getDocument(NODE_EXCEPTION, errorEl);
        }
        catch (SubscriptionSchedulerException e) {
            logger.error((Object)e.getMessage());
            Element errorEl = this.getErrorMessage(e.getMessage());
            return this.getDocument(NODE_EXCEPTION, errorEl);
        }
        catch (Exception e) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.UNABLE_TO_COMPLETE_REQUEST", e.getLocalizedMessage())), NODE_STATUS_ERROR);
        }
        Document document = this.showCommandResultUI(this.getInfoMessage(Messages.getString("SubscriptionAdminUIComponent.INVALID_COMMAND", schedulerActionStr)), NODE_STATUS_ERROR);
        document.getRootElement().add(this.getReturnParams());
        return document;
    }

    private void doListSchedules(Element root) throws Exception {
        Element job;
        IScheduledJob schedJob;
        root = root.addElement(ACTION_SCHEDULE_SHOW_LIST);
        ISubscriptionScheduler subScheduler = (ISubscriptionScheduler)PentahoSystem.get(ISubscriptionScheduler.class, (IPentahoSession)this.getSession());
        List schedList = this.subscriptionRepository.getSchedules();
        Map jobMap = subScheduler.getScheduledJobMap();
        Element scheduledJobs = root.addElement("scheduledJobs");
        Element unScheduledJobs = root.addElement("unScheduledJobs");
        Element extraScheduledJobs = root.addElement("extraScheduledJobs");
        int pauseCounter = 0;
        int errorCounter = 0;
        for (int i = 0; i < schedList.size(); ++i) {
            ISchedule sched = (ISchedule)schedList.get(i);
            schedJob = (IScheduledJob)jobMap.remove(sched.getScheduleReference());
            if (schedJob != null) {
                int jobState = schedJob.getExecutionState();
                if (jobState == 1) {
                    ++pauseCounter;
                } else if (jobState != 0) {
                    ++errorCounter;
                }
            }
            job = schedJob == null ? unScheduledJobs.addElement("job") : scheduledJobs.addElement("job");
            try {
                this.getJob(sched, schedJob, job);
                continue;
            }
            catch (ActionInfo.ActionInfoParseException e) {
                root.add(this.getInfoMessage(e.getMessage()));
            }
        }
        for (Map.Entry entry : jobMap.entrySet()) {
            schedJob = (IScheduledJob)entry.getValue();
            job = extraScheduledJobs.addElement("job");
            job.addElement("schedRef").addText(entry.getKey().toString());
            job.addElement("desc").addText(schedJob.getDescription());
            if (schedJob != null) {
                job.addAttribute("triggerState", Integer.toString(schedJob.getExecutionState()));
                Date date = schedJob.getNextTriggerTime();
                job.addElement("nextFireTime").addText(date == null ? Messages.getString("SubscriptionAdminUIComponent.USER_NEVER") : date.toString());
                date = schedJob.getLastTriggerTime();
                job.addElement("prevFireTime").addText(date == null ? Messages.getString("SubscriptionAdminUIComponent.USER_NEVER") : date.toString());
                job.addElement("jobId").addText(schedJob.getUniqueId());
                String errorMsg = schedJob.getErrorMessage();
                if (errorMsg == null) continue;
                job.addElement("errorMsg").addText(errorMsg);
                continue;
            }
            job.addAttribute("triggerState", Integer.toString(-1));
        }
        if (schedList.size() == 0) {
            root.add(this.getInfoMessage(Messages.getString("SubscriptionAdminUIComponent.USER_NO_SUBSCRIPTIONS_DEFINED")));
        } else if (scheduledJobs.elements().size() == 0) {
            root.remove(scheduledJobs);
        }
        if (errorCounter > 0) {
            root.add(this.getErrorMessage(errorCounter + Messages.getString("SubscriptionAdminUIComponent.USER_SCHEDULED_JOBS_ARE_IN_ERROR_STATE")));
        }
        if (pauseCounter > 0) {
            root.add(this.getWarningMessage(pauseCounter + Messages.getString("SubscriptionAdminUIComponent.USER_SCHEDULED_JOBS_ARE_PAUSED")));
        }
        if (unScheduledJobs.elements().size() == 0) {
            root.remove(unScheduledJobs);
        } else {
            root.add(this.getWarningMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SUBSCRIPTIONS_NOT_SCHEDULED")));
        }
        if (extraScheduledJobs.elements().size() == 0) {
            root.remove(extraScheduledJobs);
        } else {
            root.add(this.getWarningMessage(Messages.getString("SubscriptionAdminUIComponent.SUBSCRIPTION_JOBS_WITHOUT_SUBSCRIPTION")));
        }
    }

    private Element getSubscriptions(List<ISubscription> subList, boolean schedules) {
        Element ele = this.getCollectionElement("subscriptions", subList);
        if (subList != null) {
            for (int i = 0; i < subList.size(); ++i) {
                ele.add(this.getSubscription(subList.get(i), schedules));
            }
        }
        return ele;
    }

    private Element getSubscription(ISubscription sub, boolean schedules) {
        Element ele = DocumentHelper.createElement((String)"subscription");
        ele.addAttribute("subscriptionId", sub.getId());
        ele.addElement("actionRef").addText(sub.getContent().getActionReference());
        ele.addElement("title").addText(sub.getTitle());
        ele.addElement("user").addText(sub.getUser());
        if (schedules) {
            ele.add(this.getSchedules(sub.getSchedules()));
        }
        return ele;
    }

    private void getJob(ISchedule sched, IScheduledJob schedJob, Element job) throws ActionInfo.ActionInfoParseException {
        job.addElement("schedId").addText(sched.getId());
        job.addElement("schedRef").addText(sched.getScheduleReference());
        job.addElement("title").addText(sched.getTitle());
        job.addElement("desc").addText(sched.getDescription());
        job.addElement("group").addText(sched.getGroup());
        if (sched.isCronSchedule()) {
            job.addElement("cron").addText(sched.getCronString());
        } else if (sched.isRepeatSchedule()) {
            if (null != sched.getRepeatCount()) {
                job.addElement("repeat-count").addText(Integer.toString(sched.getRepeatCount()));
            }
            job.addElement("repeat-time-millisecs").addText(Integer.toString(sched.getRepeatInterval()));
        } else {
            throw new IllegalStateException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0104_INCOMPLETE_SCHEDULE", sched.getId()));
        }
        DateFormat fmt = SubscriptionHelper.getDateTimeFormatter();
        Date d = sched.getStartDate();
        if (null != d) {
            job.addElement("start-date").addText(Long.toString(d.getTime()));
        }
        if (null != (d = sched.getEndDate())) {
            job.addElement("end-date").addText(Long.toString(d.getTime()));
        }
        job.addAttribute("subscriberCount", Integer.toString(this.subscriptionRepository.getSubscriptionsForSchedule(sched).size()));
        Element content = job.addElement(NODE_CONTENT);
        List scList = this.subscriptionRepository.getContentBySchedule(sched);
        this.addContent(content, scList);
        if (schedJob != null) {
            int jobState = schedJob.getExecutionState();
            job.addAttribute("triggerState", Integer.toString(jobState));
            Date date = schedJob.getNextTriggerTime();
            job.addElement("nextFireTime").addText(date == null ? Messages.getString("SubscriptionAdminUIComponent.USER_NEVER") : date.toString());
            date = sched.getLastTrigger();
            job.addElement("prevFireTime").addText(date == null || date.getTime() == 0L ? Messages.getString("SubscriptionAdminUIComponent.USER_NEVER") : date.toString());
            job.addElement("jobId").addText(sched.getScheduleReference());
            String errorMsg = schedJob.getErrorMessage();
            if (errorMsg != null) {
                job.addElement("errorMsg").addText(errorMsg);
            }
        } else {
            job.addAttribute("triggerState", Integer.toString(-1));
        }
    }

    private void addContent(Element contentEl, List<ISubscribeContent> scList) throws ActionInfo.ActionInfoParseException {
        for (ISubscribeContent content : scList) {
            ActionInfo actionInfo = ActionInfo.parseActionString((String)content.getActionReference());
            if (null == actionInfo) {
                throw new ActionInfo.ActionInfoParseException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0103_FAILED_PARSE_SOLUTION_REPOSITORY", content.getActionReference()));
            }
            Element actionEl = contentEl.addElement("action");
            actionEl.addAttribute("solution", actionInfo.getSolutionName());
            actionEl.addAttribute("path", actionInfo.getPath());
            actionEl.addAttribute("action", actionInfo.getActionName());
        }
    }

    private void doListContent(Element ele) {
        List contentList = this.subscriptionRepository.getAllContent();
        if (contentList.size() == 0) {
            ele.add(this.getInfoMessage(Messages.getString("SubscriptionAdminUIComponent.USER_NO_SUBSCRIPTION_CONTENT")));
        } else {
            ele = ele.addElement(ACTION_CONTENT_SHOW_LIST);
            ele.addAttribute("count", String.valueOf(contentList.size()));
            for (int i = 0; i < contentList.size(); ++i) {
                this.getSubscriptionContent((ISubscribeContent)contentList.get(i), ele.addElement(NODE_CONTENT));
            }
        }
    }

    private void getSubscriptionContent(ISubscribeContent content, Element ele) {
        ele.addElement("actionRef").addText(content.getActionReference());
        ele.addAttribute("contentId", content.getId());
        ele.addElement("type").addText(content.getType());
    }

    private void doGetSchedulerStatus(Element root) {
        root = root.addElement(NODE_SCHEDULER_STATUS);
        ISubscriptionScheduler subScheduler = (ISubscriptionScheduler)PentahoSystem.get(ISubscriptionScheduler.class, (IPentahoSession)this.getSession());
        int schedulerState = 3;
        try {
            schedulerState = subScheduler.getSchedulerState();
        }
        catch (Throwable t) {
            root.add(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_GETTING_SCHEDULER_STATUS") + t.getLocalizedMessage()));
        }
        root.addAttribute("state", String.valueOf(schedulerState));
    }

    Element validateCronExpression(String cronExpr) {
        if (cronExpr == null || cronExpr.length() == 0) {
            return this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.CRON_EXPRESSION_EMPTY"));
        }
        try {
            this.scheduler.getCronSummary(cronExpr);
        }
        catch (Throwable t) {
            return this.getException(Messages.getString("SubscriptionAdminUIComponent.INVALID_CRON_EXPRESSION") + cronExpr, t);
        }
        return null;
    }

    Element validateRepeatSpec(Integer repeatCount, Integer repeatInterval) {
        if (null == repeatCount || null == repeatInterval) {
            StringBuilder sb = new StringBuilder();
            if (null == repeatCount || repeatCount < 0) {
                sb.append(Messages.getString("SubscriptionAdminUIComponent.INVALID_REPEAT_COUNT_IN_REPEAT_SCHEDULE"));
            }
            if (null == repeatInterval || repeatInterval < 0) {
                sb.append(Messages.getString("SubscriptionAdminUIComponent.INVALID_REPEAT_INTERVAL_IN_REPEAT_SCHEDULE"));
            }
            return this.getErrorMessage(sb.toString());
        }
        return null;
    }

    private void validateCronExpressionEx(String cronExpr) throws CronStringException {
        if (StringUtils.isEmpty((String)cronExpr)) {
            throw new CronStringException(Messages.getString("SubscriptionAdminUIComponent.CRON_EXPRESSION_EMPTY"));
        }
        try {
            this.scheduler.getCronSummary(cronExpr);
        }
        catch (Exception e) {
            throw new CronStringException(Messages.getString("SubscriptionAdminUIComponent.INVALID_CRON_EXPRESSION") + cronExpr, e);
        }
    }

    Document showAdminPageUI(Element ele) {
        Document document = this.getDocument(NODE_SUBSCRIPTION_ADMIN, ele);
        Element root = document.getRootElement();
        try {
            this.doListSchedules(root);
            this.doListContent(root);
            this.doGetSchedulerStatus(root);
            root.add(this.getReturnURL());
        }
        catch (Throwable t) {
            root.add(this.getException(Messages.getString("SubscriptionAdminUIComponent.EXCEPTION_BUILDING_ADMIN_PAGE"), t));
        }
        return document;
    }

    Document showEditScheduleUI(Element ele) {
        IScheduledJob schedJob;
        Element errorEle = this.validateParameters(new String[]{"schedId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String schedId = this.getParameter("schedId", null);
        ISchedule sched = this.subscriptionRepository.getSchedule(schedId);
        if (sched == null) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.SCHEDULE_NOT_FOUND", this.getParameter("schedRef", schedId))), NODE_STATUS_ERROR);
        }
        Document document = this.getDocument(ACTION_SCHEDULE_SHOW_EDIT, ele);
        Element root = document.getRootElement();
        root.add(this.getReturnURL());
        ISubscriptionScheduler subScheduler = (ISubscriptionScheduler)PentahoSystem.get(ISubscriptionScheduler.class, (IPentahoSession)this.getSession());
        try {
            schedJob = subScheduler.getScheduledJob(sched.getScheduleReference());
        }
        catch (SubscriptionSchedulerException e) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.SCHEDULE_NOT_FOUND", sched.getScheduleReference())), NODE_STATUS_ERROR);
        }
        try {
            this.getJob(sched, schedJob, root);
        }
        catch (ActionInfo.ActionInfoParseException e) {
            return this.showCommandResultUI(this.getErrorMessage(e.getMessage()), NODE_STATUS_ERROR);
        }
        List subList = this.subscriptionRepository.getSubscriptionsForSchedule(sched);
        root.add(this.getSubscriptions(subList, true));
        List contentList = this.subscriptionRepository.getContentBySchedule(sched);
        root = root.addElement(ACTION_CONTENT_SHOW_LIST);
        root.addAttribute("count", String.valueOf(contentList.size()));
        for (int i = 0; i < contentList.size(); ++i) {
            Element tmpEle = root.addElement(NODE_CONTENT);
            tmpEle.addElement("schedId").addText(sched.getId());
            tmpEle.addElement("schedRef").addText(sched.getScheduleReference());
            this.getSubscriptionContent((ISubscribeContent)((SubscribeContent)contentList.get(i)), tmpEle);
        }
        return document;
    }

    Document doEditSchedule() throws Exception {
        ISchedule sched;
        Element errorEle = this.validateParameters(new String[]{"schedId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String schedId = this.getParameter("schedId", null);
        String cronExpr = this.getParameter("cron", null);
        String[] paramNames = new String[]{"title", "schedRef", "desc", "cron", "group"};
        if (cronExpr != null) {
            // empty if block
        }
        try {
            sched = this.subscriptionRepository.editCronSchedule(schedId, this.getParameter("title", null), this.getParameter("schedRef", null), this.getParameter("desc", null), cronExpr, this.getParameter("group", null), null, null);
        }
        catch (Throwable t) {
            Document document = this.showEditScheduleUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_EDITING_SCHEDULE", this.getParameter("schedRef", schedId)), t));
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_MODIFIED_SCHEDULE", sched.getScheduleReference())), NODE_STATUS_OK);
    }

    private Document doEditScheduleWithoutContent() throws ParameterValidationException, CronStringException, SubscriptionRepositoryCheckedException {
        Integer repeatInterval;
        String[] paramNames = new String[]{"schedId", "title", "group"};
        this.validateParametersEx(paramNames, true);
        String schedId = this.getParameter("schedId", null);
        String cronExpr = this.getParameter("cron", null);
        String strRepeatInterval = this.getParameter("repeat-time-millisecs", null);
        String strRepeatCount = this.getParameter("repeat-count", null);
        String schedRef = this.getParameter("schedRef", null);
        String title = this.getParameter("title", null);
        String desc = this.getParameter("desc", null);
        String group = this.getParameter("group", null);
        String strStartDate = this.getParameter("start-date-time", null);
        String strEndDate = this.getParameter("end-date-time", null);
        if (null != cronExpr) {
            this.validateCronExpressionEx(cronExpr);
        } else if (null == strRepeatInterval) {
            throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0102_INVALID_SCHEDULE_PARAM"));
        }
        Integer repeatCount = null != strRepeatCount ? Integer.valueOf(Integer.parseInt(strRepeatCount)) : null;
        Integer n = repeatInterval = null != strRepeatInterval ? Integer.valueOf(Integer.parseInt(strRepeatInterval)) : null;
        assert (repeatInterval == null || repeatInterval >= 0) : Messages.getString("SubscriptionAdminUIComponent.INVALID_REPEAT_INTERVAL", strRepeatInterval);
        DateFormat fmt = SubscriptionHelper.getDateTimeFormatter();
        Date startDate = null;
        if (strStartDate != null) {
            try {
                startDate = new Date(Long.parseLong(strStartDate));
            }
            catch (NumberFormatException ex) {
                try {
                    startDate = fmt.parse(strStartDate);
                }
                catch (ParseException e) {
                    throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0100_INVALID_START_DATE_PARAM", strStartDate));
                }
            }
        }
        Date endDate = null;
        if (strEndDate != null) {
            try {
                endDate = new Date(Long.parseLong(strEndDate));
            }
            catch (NumberFormatException ex) {
                try {
                    endDate = fmt.parse(strEndDate);
                }
                catch (ParseException e) {
                    throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0100_INVALID_END_DATE_PARAM", strEndDate));
                }
            }
        }
        SubscriptionRepositoryHelper.editScheduleWithoutContent((ISubscriptionRepository)this.subscriptionRepository, (String)schedId, (String)title, (String)schedRef, (String)desc, (String)cronExpr, (Integer)repeatCount, (Integer)repeatInterval, (String)group, (Date)startDate, (Date)endDate);
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_MODIFIED_SCHEDULE", schedRef)), NODE_STATUS_OK);
    }

    Document showAddScheduleUI(Element ele) {
        Document document = this.getDocument(ACTION_SCHEDULE_SHOW_ADD, ele);
        document.getRootElement().add(this.getReturnURL());
        return document;
    }

    Document doAddSchedule() {
        String[] paramNames = new String[]{"title", "schedRef", "desc", "cron", "group"};
        Element errorEle = this.validateParameters(paramNames, true, null);
        if (errorEle != null) {
            Document document = this.showAddScheduleUI(errorEle);
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        String cronExpr = this.getParameter("cron", null);
        errorEle = this.validateCronExpression(cronExpr);
        if (errorEle != null) {
            Document document = this.showAddScheduleUI(errorEle);
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        String schedRef = this.getParameter("schedRef", null);
        try {
            this.subscriptionRepository.addCronSchedule(this.getParameter("title", null), schedRef, this.getParameter("desc", null), cronExpr, this.getParameter("group", null), null, null);
        }
        catch (Throwable t) {
            Document document = this.showAddScheduleUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_ADDING_SCHEDULE", schedRef), t));
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_ADDED_SCHEDULE", schedRef)), NODE_STATUS_OK);
    }

    Document doAddScheduleWithoutContent() throws ParameterValidationException, CronStringException, SubscriptionRepositoryCheckedException, SubscriptionSchedulerException {
        String[] paramNames = new String[]{"title", "schedRef", "desc", "group"};
        this.validateParametersEx(paramNames, true);
        String cronExpr = this.getParameter("cron", null);
        String strRepeatInterval = this.getParameter("repeat-time-millisecs", null);
        String strRepeatCount = this.getParameter("repeat-count", null);
        String schedRef = this.getParameter("schedRef", null);
        String title = this.getParameter("title", null);
        String desc = this.getParameter("desc", null);
        String group = this.getParameter("group", null);
        String strStartDate = this.getParameter("start-date-time", null);
        String strEndDate = this.getParameter("end-date-time", null);
        if (null != cronExpr) {
            this.validateCronExpressionEx(cronExpr);
        } else if (null == strRepeatInterval) {
            throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0102_INVALID_SCHEDULE_PARAM"));
        }
        Integer repeatCount = null != strRepeatCount ? Integer.valueOf(Integer.parseInt(strRepeatCount)) : null;
        Integer repeatInterval = null != strRepeatInterval ? Integer.valueOf(Integer.parseInt(strRepeatInterval)) : null;
        DateFormat fmt = SubscriptionHelper.getDateTimeFormatter();
        Date startDate = null;
        if (strStartDate != null) {
            try {
                startDate = new Date(Long.parseLong(strStartDate));
            }
            catch (NumberFormatException ex) {
                try {
                    startDate = fmt.parse(strStartDate);
                }
                catch (ParseException e) {
                    throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0100_INVALID_START_DATE_PARAM", strStartDate), e);
                }
            }
        }
        Date endDate = null;
        if (strEndDate != null) {
            try {
                endDate = new Date(Long.parseLong(strEndDate));
            }
            catch (NumberFormatException ex) {
                try {
                    endDate = fmt.parse(strEndDate);
                }
                catch (ParseException e) {
                    throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0100_INVALID_END_DATE_PARAM", strEndDate), e);
                }
            }
        }
        SubscriptionRepositoryHelper.addScheduleWithoutContent((ISubscriptionRepository)this.subscriptionRepository, (String)title, (String)schedRef, (String)desc, (String)cronExpr, (Integer)repeatCount, (Integer)repeatInterval, (String)group, (Date)startDate, (Date)endDate);
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_ADDED_SCHEDULE", schedRef)), NODE_STATUS_OK);
    }

    Document showAddContentForScheduleUI() {
        Element errorEle = this.validateParameters(new String[]{"schedId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String schedId = this.getParameter("schedId", null);
        ISchedule sched = this.subscriptionRepository.getSchedule(schedId);
        if (sched == null) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_SCHEDULE_NOT_FOUND", this.getParameter("schedRef", schedId))), NODE_STATUS_ERROR);
        }
        List contentList = this.subscriptionRepository.getContentBySchedule(sched);
        HashSet<String> currentContent = new HashSet<String>();
        for (int i = 0; i < contentList.size(); ++i) {
            currentContent.add(((SubscribeContent)contentList.get(i)).getActionReference());
        }
        Document document = this.getDocument(ACTION_SCHEDULE_SHOW_ADD_CONTENT, null);
        Element root = document.getRootElement();
        root.add(this.getReturnURL());
        root.add(this.createTextElement("schedId", schedId));
        root.add(this.createTextElement("schedRef", sched.getScheduleReference()));
        List allContentList = this.subscriptionRepository.getAllContent();
        Element ele = this.getCollectionElement(ACTION_CONTENT_SHOW_LIST, allContentList);
        for (int i = 0; i < allContentList.size(); ++i) {
            Element tmpEle = ele.addElement(NODE_CONTENT);
            SubscribeContent subContent = (SubscribeContent)allContentList.get(i);
            this.getSubscriptionContent((ISubscribeContent)subContent, tmpEle);
            tmpEle.addAttribute("selected", currentContent.contains(subContent.getActionReference()) ? "true" : "false");
        }
        root.add(ele);
        return document;
    }

    private Document doAddScheduleAndContent() throws ParameterValidationException, CronStringException, SubscriptionRepositoryCheckedException, SubscriptionSchedulerException {
        String[] paramNames = new String[]{"title", "schedRef", "group", "actionRefs"};
        this.validateParametersEx(paramNames, true);
        String cronExpr = this.getParameter("cron", null);
        String strRepeatInterval = this.getParameter("repeat-time-millisecs", null);
        String strRepeatCount = this.getParameter("repeat-count", null);
        String schedRef = this.getParameter("schedRef", null);
        String[] actionRefs = this.getParameterAsArray("actionRefs");
        String title = this.getParameter("title", null);
        String desc = this.getParameter("desc", null);
        String group = this.getParameter("group", null);
        String strStartDate = this.getParameter("start-date-time", null);
        String strEndDate = this.getParameter("end-date-time", null);
        if (null != cronExpr) {
            this.validateCronExpressionEx(cronExpr);
        } else if (null == strRepeatInterval) {
            throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0102_INVALID_SCHEDULE_PARAM"));
        }
        Integer repeatCount = null != strRepeatCount ? Integer.valueOf(Integer.parseInt(strRepeatCount)) : null;
        Integer repeatInterval = null != strRepeatInterval ? Integer.valueOf(Integer.parseInt(strRepeatInterval)) : null;
        DateFormat fmt = SubscriptionHelper.getDateTimeFormatter();
        Date startDate = null;
        if (strStartDate != null) {
            try {
                startDate = new Date(Long.parseLong(strStartDate));
            }
            catch (NumberFormatException ex) {
                try {
                    startDate = fmt.parse(strStartDate);
                }
                catch (ParseException e) {
                    throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0100_INVALID_START_DATE_PARAM", strStartDate), e);
                }
            }
        }
        Date endDate = null;
        if (strEndDate != null) {
            try {
                endDate = new Date(Long.parseLong(strEndDate));
            }
            catch (NumberFormatException ex) {
                try {
                    endDate = fmt.parse(strEndDate);
                }
                catch (ParseException e) {
                    throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0100_INVALID_END_DATE_PARAM", strEndDate), e);
                }
            }
        }
        SubscriptionRepositoryHelper.addScheduleAndContent((ISubscriptionRepository)this.subscriptionRepository, (String)title, (String)schedRef, (String)desc, (String)cronExpr, (Integer)repeatCount, (Integer)repeatInterval, (String)group, (Date)startDate, (Date)endDate, (String[])actionRefs);
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SCHEDULED", schedRef)), NODE_STATUS_OK);
    }

    private Document doEditScheduleAndContent() throws ParameterValidationException, CronStringException, SubscriptionRepositoryCheckedException {
        Integer repeatInterval;
        String[] paramNames = new String[]{"schedId", "actionRefs", "title", "group"};
        this.validateParametersEx(paramNames, true);
        String schedId = this.getParameter("schedId", null);
        String cronExpr = this.getParameter("cron", null);
        String strRepeatInterval = this.getParameter("repeat-time-millisecs", null);
        String strRepeatCount = this.getParameter("repeat-count", null);
        String schedRef = this.getParameter("schedRef", null);
        String[] actionRefs = this.getParameterAsArray("actionRefs");
        String title = this.getParameter("title", null);
        String desc = this.getParameter("desc", null);
        String group = this.getParameter("group", null);
        String strStartDate = this.getParameter("start-date-time", null);
        String strEndDate = this.getParameter("end-date-time", null);
        if (null != cronExpr) {
            this.validateCronExpressionEx(cronExpr);
        } else if (null == strRepeatInterval) {
            throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0102_INVALID_SCHEDULE_PARAM"));
        }
        Integer repeatCount = null != strRepeatCount ? Integer.valueOf(Integer.parseInt(strRepeatCount)) : null;
        Integer n = repeatInterval = null != strRepeatInterval ? Integer.valueOf(Integer.parseInt(strRepeatInterval)) : null;
        assert (repeatInterval == null || repeatInterval >= 0) : Messages.getString("SubscriptionAdminUIComponent.INVALID_REPEAT_INTERVAL", strRepeatInterval);
        DateFormat fmt = SubscriptionHelper.getDateTimeFormatter();
        Date startDate = null;
        if (strStartDate != null) {
            try {
                startDate = new Date(Long.parseLong(strStartDate));
            }
            catch (NumberFormatException ex) {
                try {
                    startDate = fmt.parse(strStartDate);
                }
                catch (ParseException e) {
                    throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0100_INVALID_START_DATE_PARAM", strStartDate), e);
                }
            }
        }
        Date endDate = null;
        if (strEndDate != null) {
            try {
                endDate = new Date(Long.parseLong(strEndDate));
            }
            catch (NumberFormatException ex) {
                try {
                    endDate = fmt.parse(strEndDate);
                }
                catch (ParseException e) {
                    throw new ParameterValidationException(Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0100_INVALID_END_DATE_PARAM", strEndDate), e);
                }
            }
        }
        SubscriptionRepositoryHelper.editScheduleAndContent((ISubscriptionRepository)this.subscriptionRepository, (String)schedId, (String)title, (String)schedRef, (String)desc, (String)cronExpr, (Integer)repeatCount, (Integer)repeatInterval, (String)group, (Date)startDate, (Date)endDate, (String[])actionRefs);
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_MODIFIED_SCHEDULE", schedRef)), NODE_STATUS_OK);
    }

    Document doAddContentForSchedule() {
        Element errorEle = this.validateParameters(new String[]{"schedId", "contentId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String schedId = this.getParameter("schedId", null);
        ISchedule sched = this.subscriptionRepository.getSchedule(schedId);
        if (sched == null) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_SCHEDULE_NOT_FOUND", this.getParameter("schedRef", schedId))), NODE_STATUS_ERROR);
        }
        String[] contentArray = this.getParameterAsArray("contentId");
        try {
            this.subscriptionRepository.setContentForSchedule(contentArray, schedId);
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_SETTING_CONTENT_FOR_SCHEDULE", this.getParameter("schedRef", schedId)), t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SET_CONTENT_FOR_SCHEDULE", this.getParameter("schedRef", schedId))), NODE_STATUS_OK);
    }

    Document doDeleteSchedule() throws SubscriptionRepositoryCheckedException {
        Element errorEle = this.validateParameters(new String[]{"schedId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String schedId = this.getParameter("schedId", null);
        this.subscriptionRepository.deleteScheduleById(schedId);
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_DELETED_SCHEDULE", this.getParameter("schedRef", schedId))), NODE_STATUS_OK);
    }

    Document doScheduleJob() {
        Element errorEle = this.validateParameters(new String[]{"schedId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String schedId = this.getParameter("schedId", null);
        try {
            ISchedule sched = this.subscriptionRepository.getSchedule(schedId);
            if (sched == null) {
                return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_SCHEDULE_NOT_FOUND", schedId)), NODE_STATUS_ERROR);
            }
            errorEle = sched.isCronSchedule() ? this.validateCronExpression(sched.getCronString()) : (sched.isRepeatSchedule() ? this.validateRepeatSpec(sched.getRepeatCount(), sched.getRepeatInterval()) : this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.INCOMPLETE_SCHEDULE", sched.getId())));
            if (errorEle != null) {
                Document document = this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
                document.getRootElement().add(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_CANNOT_START_SCHEDULE")));
                return document;
            }
            if (this.scheduler.syncSchedule(null, sched) == null) {
                return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_UNABLE_TO_SCHEDULE_JOB", sched.getScheduleReference())), NODE_STATUS_ERROR);
            }
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_SCHEDULING", this.getParameter("schedRef", schedId)), t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SCHEDULED", this.getParameter("schedRef", schedId))), NODE_STATUS_OK);
    }

    Document doScheduleAllJobs() {
        try {
            List errorMessages = this.subscriptionRepository.syncSchedules();
            if (errorMessages.size() > 0) {
                Document document = this.showCommandResultUI(this.getWarningMessage(Messages.getString("SubscriptionAdminUIComponent.WARNING_NOT_ALL_SCHEDULES_STARTED")), NODE_STATUS_WARNING);
                Element root = document.getRootElement();
                for (int i = 0; i < errorMessages.size(); ++i) {
                    root.add(this.getWarningMessage(errorMessages.get(i).toString()));
                }
                return document;
            }
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_SYNCHRONIZING_SCHEDULES"), t), NODE_STATUS_ERROR);
        }
        return this.showAdminPageUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SYNCHRONIZE_COMPLETE")));
    }

    Document doJobAction(String command) {
        Element errorEle = this.validateParameters(new String[]{"jobId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String jobId = this.getParameter("jobId", null);
        String okMessage = "";
        try {
            if (ACTION_JOB_DO_PAUSE.equals(command)) {
                this.scheduler.pauseJob(jobId);
                okMessage = Messages.getString("SubscriptionAdminUIComponent.USER_PAUSED_JOB");
            } else if (ACTION_JOB_DO_RESUME.equals(command)) {
                this.scheduler.resumeJob(jobId);
                okMessage = Messages.getString("SubscriptionAdminUIComponent.USER_RESUMED_JOB");
            } else if (ACTION_JOB_DO_DELETE.equals(command)) {
                this.scheduler.deleteJob(jobId);
                okMessage = Messages.getString("SubscriptionAdminUIComponent.USER_DELETED_JOB");
            } else if (ACTION_JOB_DO_EXECUTE.equals(command)) {
                this.scheduler.executeJob(jobId);
                okMessage = Messages.getString("SubscriptionAdminUIComponent.USER_SUBMITTED_JOB");
            }
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException("", t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(okMessage + this.getParameter("schedRef", jobId)), NODE_STATUS_OK);
    }

    Document doResumeScheduler() {
        try {
            this.scheduler.resumeScheduler();
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_RESUMING_SCHEDULER"), t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SCHEDULER_RESUMED")), NODE_STATUS_OK);
    }

    Document doPauseScheduler() {
        try {
            this.scheduler.pauseScheduler();
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_PAUSING_SCHEDULER"), t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_PAUSED_SCHEDULER")), NODE_STATUS_OK);
    }

    Document showEditContentUI(Element ele) throws Exception {
        Element errorEle = this.validateParameters(new String[]{"contentId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String contentId = this.getParameter("contentId", null);
        ISubscribeContent subContent = this.subscriptionRepository.getContentById(contentId);
        if (subContent == null) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_CONTENT_NOT_FOUND", this.getParameter("actionRef", contentId))), NODE_STATUS_ERROR);
        }
        Document document = this.getDocument(ACTION_CONTENT_SHOW_EDIT, ele);
        Element root = document.getRootElement();
        this.getSubscriptionContent(subContent, root);
        root.add(this.getReturnURL());
        List schedulelist = subContent.getSchedules();
        ele = this.getCollectionElement("schedules", schedulelist);
        for (int i = 0; i < schedulelist.size(); ++i) {
            Element tmpEle = this.getSchedule((Schedule)schedulelist.get(i));
            tmpEle.addElement("contentId").addText(contentId);
            tmpEle.addElement("actionRef").addText(this.getParameter("actionRef", contentId));
            ele.add(tmpEle);
        }
        root.add(ele);
        return document;
    }

    private Element getSchedule(Schedule sched) {
        Element ele = DocumentHelper.createElement((String)"schedule");
        ele.addElement("schedId").addText(sched.getId());
        ele.addElement("schedRef").addText(sched.getScheduleReference());
        ele.addElement("title").addText(sched.getTitle());
        ele.addElement("desc").addText(sched.getDescription());
        ele.addElement("group").addText(sched.getGroup());
        return ele;
    }

    private Element getSchedules(List schedList) {
        Element ele = this.getCollectionElement("schedules", schedList);
        int listSize = schedList == null ? 0 : schedList.size();
        for (int i = 0; i < listSize; ++i) {
            ele.add(this.getSchedule((Schedule)schedList.get(i)));
        }
        return ele;
    }

    private Element getCollectionElement(String name, Collection c) {
        Element ele = DocumentHelper.createElement((String)name);
        if (c == null) {
            ele.addAttribute("count", "0");
        } else {
            ele.addAttribute("count", String.valueOf(c.size()));
        }
        return ele;
    }

    Document doEditContent() throws Exception {
        ISubscribeContent subContent;
        Element errorEle = this.validateParameters(new String[]{"contentId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String contentId = this.getParameter("contentId", null);
        String[] paramNames = new String[]{"actionRef", "type"};
        try {
            subContent = this.subscriptionRepository.editContent(contentId, this.getParameter("actionRef", null), this.getParameter("type", null));
        }
        catch (Throwable t) {
            Document document = this.showEditContentUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_EDITING_CONTENT", this.getParameter("actionRef", contentId)), t));
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_MODIFIED_CONTENT", subContent.getActionReference())), NODE_STATUS_OK);
    }

    Document showAddContentUI(Element ele) {
        Document document = this.getDocument(ACTION_CONTENT_SHOW_ADD, ele);
        document.getRootElement().add(this.getReturnURL());
        List contentList = this.subscriptionRepository.getAllContent();
        HashSet<String> currentContent = new HashSet<String>();
        for (int i = 0; i < contentList.size(); ++i) {
            currentContent.add(((SubscribeContent)contentList.get(i)).getActionReference());
        }
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
        String[] actionSequences = repository.getAllActionSequences(1);
        Arrays.sort(actionSequences, new SolutionCompare());
        ele = DocumentHelper.createElement((String)ACTION_CONTENT_SHOW_LIST);
        ele.addAttribute("count", String.valueOf(actionSequences.length));
        String lastFolder = null;
        Element folderEle = null;
        for (String s : actionSequences) {
            String currentFolder = this.getFolder(s);
            if (!currentFolder.equals(lastFolder)) {
                folderEle = DocumentHelper.createElement((String)"folder");
                folderEle.addAttribute("name", currentFolder);
                ele.add(folderEle);
                lastFolder = currentFolder;
            }
            Element tmpEle = DocumentHelper.createElement((String)NODE_CONTENT).addText(this.getFile(s));
            tmpEle.addAttribute("selected", currentContent.contains(s) ? "true" : "false");
            folderEle.add(tmpEle);
        }
        document.getRootElement().add(ele);
        System.out.println(document.asXML());
        return document;
    }

    protected String getFolder(String fullPath) {
        int idx = fullPath.lastIndexOf("/");
        if (idx > 0) {
            return fullPath.substring(0, idx);
        }
        return "";
    }

    protected String getFile(String fullPath) {
        int idx = fullPath.lastIndexOf("/");
        if (idx > 0) {
            return fullPath.substring(idx + 1);
        }
        return fullPath;
    }

    Document doAddContent() {
        String[] paramNames = new String[]{"actionRef"};
        Element errorEle = this.validateParameters(paramNames, true, null);
        if (errorEle != null) {
            Document document = this.showAddContentUI(errorEle);
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        String[] actionRef = this.getParameterAsArray("actionRef");
        try {
            this.subscriptionRepository.addContent(actionRef);
        }
        catch (Throwable t) {
            Document document = this.showAddContentUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_SETTING_CONTENT"), t));
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SET_SUBSCRIPTION_CONTENT")), NODE_STATUS_OK);
    }

    Document doSetContent() {
        String[] paramNames = new String[]{"actionRef"};
        Element errorEle = this.validateParameters(paramNames, true, null);
        if (errorEle != null) {
            Document document = this.showAddContentUI(errorEle);
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        String[] actionRef = this.getParameterAsArray("actionRef");
        try {
            this.subscriptionRepository.setContent(actionRef);
        }
        catch (Throwable t) {
            Document document = this.showAddContentUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_SETTING_CONTENT"), t));
            this.setParametersAsNodes(document.getRootElement(), paramNames);
            return document;
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SET_SUBSCRIPTION_CONTENT")), NODE_STATUS_OK);
    }

    Document doDeleteContent() {
        Element errorEle = this.validateParameters(new String[]{"contentId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String contentId = this.getParameter("contentId", null);
        try {
            this.subscriptionRepository.deleteSubscribeContentById(contentId);
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_DELETING_CONTENT", this.getParameter("actionRef", contentId)), t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_DELETED_CONTENT", this.getParameter("actionRef", contentId))), NODE_STATUS_OK);
    }

    Document doDeleteContentForSchedule() throws Exception {
        Element errorEle = this.validateParameters(new String[]{"contentId", "schedId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String contentId = this.getParameter("contentId", null);
        String schedId = this.getParameter("schedId", null);
        try {
            this.subscriptionRepository.deleteContentForSchedule(contentId, schedId);
        }
        catch (Exception e) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_DELETING_CONTENT_FOR_SCHEDULE", this.getParameter("actionRef", contentId), this.getParameter("schedRef", schedId)), e), NODE_STATUS_ERROR);
        }
        return this.showEditContentUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_DELETED_CONTENT_FOR_SCHEDULE", this.getParameter("actionRef", contentId), this.getParameter("schedRef", schedId))));
    }

    Document showAddScheduleForContentUI() {
        Element errorEle = this.validateParameters(new String[]{"contentId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String contentId = this.getParameter("contentId", null);
        ISubscribeContent content = this.subscriptionRepository.getContentById(contentId);
        if (content == null) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_CONTENT_NOT_FOUND", this.getParameter("actionRef", contentId))), NODE_STATUS_ERROR);
        }
        List scheduleList = content.getSchedules();
        HashSet<String> currentSchedules = new HashSet<String>();
        for (int i = 0; i < scheduleList.size(); ++i) {
            currentSchedules.add(((Schedule)scheduleList.get(i)).getId());
        }
        Document document = this.getDocument(ACTION_CONTENT_SHOW_ADD_SCHEDULE, null);
        Element root = document.getRootElement();
        root.add(this.getReturnURL());
        root.add(this.createTextElement("contentId", contentId));
        root.add(this.createTextElement("actionRef", content.getActionReference()));
        List allScheduleList = this.subscriptionRepository.getSchedules();
        Element ele = this.getCollectionElement(ACTION_SCHEDULE_SHOW_LIST, allScheduleList);
        for (int i = 0; i < allScheduleList.size(); ++i) {
            Schedule sched = (Schedule)allScheduleList.get(i);
            Element tmpEle = this.getSchedule(sched);
            tmpEle.addAttribute("selected", currentSchedules.contains(sched.getId()) ? "true" : "false");
            ele.add(tmpEle);
        }
        root.add(ele);
        return document;
    }

    Document doAddScheduleForContent() {
        Element errorEle = this.validateParameters(new String[]{"contentId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String contentId = this.getParameter("contentId", null);
        ISubscribeContent content = this.subscriptionRepository.getContentById(contentId);
        if (content == null) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_CONTENT_NOT_FOUND", this.getParameter("actionRef", contentId))), NODE_STATUS_ERROR);
        }
        String[] scheduleArray = this.getParameterAsArray("schedId");
        try {
            this.subscriptionRepository.setSchedulesForContent(scheduleArray, contentId);
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_SETTING_SCHEDULES_FOR_CONTENT", this.getParameter("actionRef", contentId)), t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_SET_SCHEDULES_FOR_CONTENT", this.getParameter("actionRef", contentId))), NODE_STATUS_OK);
    }

    Document showImportUI() {
        Document document = this.getDocument(ACTION_SHOW_IMPORT, null);
        document.getRootElement().add(this.getReturnURL());
        return document;
    }

    public Document doImport() {
        HttpServletRequest request = ((HttpRequestParameterProvider)((Object)this.getParameterProviders().get("request"))).getRequest();
        String contentType = request.getContentType();
        if (contentType == null || contentType.indexOf("multipart/form-data") < 0 && contentType.indexOf("multipart/mixed stream") < 0) {
            return this.showCommandResultUI(this.getErrorMessage(Messages.getString("SubscriptionAdminUIComponent.ERROR_IMPORT_FILE_NOT_UPLOADED")), NODE_STATUS_ERROR);
        }
        Enumeration enumer = request.getParameterNames();
        while (enumer.hasMoreElements()) {
            System.out.println(enumer.nextElement().toString());
        }
        try {
            String publishPassword = null;
            FileItem publishFile = null;
            ServletFileUpload uploader = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            List fileList = uploader.parseRequest(request);
            for (FileItem fi : fileList) {
                if (fi.isFormField()) {
                    publishPassword = new String(fi.get());
                    continue;
                }
                publishFile = fi;
            }
            this.saveFileItem(publishFile, publishPassword);
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_UNABLE_TO_PARSE_FILE"), t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_IMPORT_SUCCESSFUL")), NODE_STATUS_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int saveFileItem(FileItem fi, String password) {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
        int status = 3;
        if (!SubscriptionAdminUIComponent.checkPublisherKey(PublisherUtil.getPasswordKey((String)password))) return 4;
        String solutionPath = PentahoSystem.getApplicationContext().getSolutionPath("");
        try {
            PentahoSystem.systemEntryPoint();
            status = repository.publish(solutionPath, "system", "ScheduleAndContentImport.xml", fi.get(), true);
            return status;
        }
        catch (PentahoAccessControlException e) {
            status = 2;
            if (!logger.isErrorEnabled()) return status;
            logger.error((Object)Messages.getErrorString("SubscriptionAdminUIComponent.ERROR_0104_USER_ERROR"), (Throwable)e);
            return status;
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    Document showSubscriptionsPageUI(Element ele) {
        String userName = this.getParameter("user", null);
        Document document = this.getDocument(ACTION_SUBSCRIPTION_SHOW_LIST, ele);
        Element root = document.getRootElement();
        try {
            List allSubscriptions = userName == null ? this.subscriptionRepository.getAllSubscriptions() : this.subscriptionRepository.getUserSubscriptions(userName);
            root.add(this.getSubscriptions(allSubscriptions, true));
        }
        catch (Throwable t) {
            root.add(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_BUILDING_SUBSCRIPTION_PAGE"), t));
        }
        return document;
    }

    private Document doDeleteScheduleContentAndSubscription() throws SubscriptionRepositoryCheckedException, ParameterValidationException, SubscriptionSchedulerException {
        String[] paramNames = new String[]{"schedId"};
        this.validateParametersEx(paramNames, true);
        String schedId = this.getParameter("schedId", null);
        ISchedule schedule = this.subscriptionRepository.getSchedule(schedId);
        SubscriptionRepositoryHelper.deleteScheduleContentAndSubscription((ISubscriptionRepository)this.subscriptionRepository, (ISchedule)schedule);
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_DELETED_SCHEDULE", this.getParameter("schedRef", schedId))), NODE_STATUS_OK);
    }

    Document doDeleteSubscription() {
        Element errorEle = this.validateParameters(new String[]{"subscriptionId"}, true, null);
        if (errorEle != null) {
            return this.showCommandResultUI(errorEle, NODE_STATUS_ERROR);
        }
        String subscriptionId = this.getParameter("subscriptionId", null);
        try {
            this.subscriptionRepository.deleteSubscription(subscriptionId);
        }
        catch (Throwable t) {
            return this.showCommandResultUI(this.getException(Messages.getString("SubscriptionAdminUIComponent.ERROR_DELETING_SUBSCRIPTION", this.getParameter("title", subscriptionId)), t), NODE_STATUS_ERROR);
        }
        return this.showCommandResultUI(this.getOkMessage(Messages.getString("SubscriptionAdminUIComponent.USER_DELETED_SUBSCRIPTION", this.getParameter("title", subscriptionId))), NODE_STATUS_OK);
    }

    Document showCommandResultUI(Element ele, String result) {
        Document document = this.getDocument(NODE_CMD_RESULT, ele);
        Element root = document.getRootElement();
        root.addAttribute(NODE_RESULT_TYPE, result);
        return document;
    }

    Element getReturnParams() {
        Element ele = DocumentHelper.createElement((String)NODE_RETURN_PARAM);
        IParameterProvider parameterProvider = (IParameterProvider)this.getParameterProviders().get("request");
        Iterator nameItr = parameterProvider.getParameterNames();
        while (nameItr.hasNext()) {
            String name = (String)nameItr.next();
            String value = parameterProvider.getStringParameter(name, null);
            if (value == null) continue;
            ele.addElement(name).addText(value);
        }
        return ele;
    }

    Element getReturnURL() {
        Element ele = DocumentHelper.createElement((String)NODE_RETURN_URL);
        IParameterProvider parameterProvider = (IParameterProvider)this.getParameterProviders().get("request");
        String str = "";
        Iterator nameItr = parameterProvider.getParameterNames();
        while (nameItr.hasNext()) {
            String name = (String)nameItr.next();
            String value = parameterProvider.getStringParameter(name, null);
            if (value == null) continue;
            str = str + "&" + name + "=" + value;
        }
        ele.addText(str);
        return ele;
    }

    Element getErrorMessage(String message) {
        Encoder encoder = ESAPI.encoder();
        return this.getMessage(NODE_STATUS_ERROR, encoder.encodeForHTML(message));
    }

    Element getWarningMessage(String message) {
        Encoder encoder = ESAPI.encoder();
        return this.getMessage(NODE_STATUS_WARNING, encoder.encodeForHTML(message));
    }

    Element getOkMessage(String message) {
        Encoder encoder = ESAPI.encoder();
        return this.getMessage(NODE_STATUS_OK, encoder.encodeForHTML(message));
    }

    Element getInfoMessage(String message) {
        Encoder encoder = ESAPI.encoder();
        return this.getMessage(NODE_STATUS_INFO, encoder.encodeForHTML(message));
    }

    Element getMessage(String type, String message) {
        return DocumentHelper.createElement((String)NODE_RESULT_MSG).addAttribute(NODE_RESULT_TYPE, type).addText(message);
    }

    Element getException(String message, Throwable t) {
        Encoder encoder = ESAPI.encoder();
        Element root = DocumentHelper.createElement((String)NODE_EXCEPTION);
        if (message != null) {
            root.addElement(NODE_RESULT_MSG).addText(encoder.encodeForHTML(message));
        }
        String exMsg = null;
        for (Throwable tmpT = t; tmpT != null && exMsg == null; tmpT = tmpT.getCause()) {
            exMsg = tmpT.getLocalizedMessage();
        }
        root.addElement("exceptionMessage").addText(exMsg != null ? encoder.encodeForHTML(exMsg) : Messages.getString("SubscriptionAdminUIComponent.ERROR_CAUSE_UNKNOWN", t.getClass().getName()));
        return root;
    }

    private Element createTextElement(String elementName, String text) {
        return DocumentHelper.createElement((String)elementName).addText(text);
    }

    Element validateParameters(String[] params, boolean notEmpty, Element ele) {
        for (String element : params) {
            Object param = this.getObjectParameter(element, null);
            if (param != null && (!notEmpty || !this.isEmpty(param))) continue;
            if (ele == null) {
                ele = DocumentHelper.createElement((String)NODE_PARAM_ERRORS);
            }
            ele.addElement(NODE_PARAM_MISSING).addText(element);
        }
        return ele;
    }

    private boolean isEmpty(Object parameter) {
        assert (parameter != null);
        if (parameter instanceof String) {
            return ((String)parameter).length() == 0;
        }
        if (parameter instanceof Object[]) {
            Object[] objArray = (Object[])parameter;
            for (int i = 0; i < objArray.length; ++i) {
                if (!this.isEmpty(objArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private void validateParametersEx(String[] params, boolean notEmpty) throws ParameterValidationException {
        ArrayList<String> missingParams = new ArrayList<String>();
        for (String paramName : params) {
            Object param = this.getObjectParameter(paramName, null);
            if (param != null && (!notEmpty || !this.isEmpty(param))) continue;
            missingParams.add(paramName);
        }
        if (missingParams.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.getString("SubscriptionAdminUIComponent.MISSING_PARAMETERS"));
            for (String paramName : missingParams) {
                String friendlyName = PARAM_NAME_TO_FRIENDLY_NAME.get(paramName);
                sb.append(friendlyName).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            throw new ParameterValidationException(sb.toString());
        }
    }

    private void setParametersAsNodes(Element parent, String[] paramNames) {
        if (parent == null || paramNames == null) {
            return;
        }
        for (String element : paramNames) {
            Node node = parent.selectSingleNode(element);
            if (node instanceof Element) {
                ((Element)node).setText(this.getParameter(element, ""));
                continue;
            }
            parent.addElement(element).addText(this.getParameter(element, ""));
        }
    }

    private Document getDocument(String rootName, Element ele) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootName);
        if (ele != null) {
            root.add(ele);
        }
        return document;
    }

    private static final boolean checkPublisherKey(String key) {
        String setting;
        Node node;
        Document doc;
        if (key != null && (doc = PentahoSystem.getSystemSettings().getSystemSettingsDocument(PublishConfigFile)) != null && (node = doc.selectSingleNode("//publisher-config/publisher-password")) != null && (setting = node.getText()) != null && setting.length() > 0) {
            String pubKey = PublisherUtil.getPasswordKey((String)setting);
            return pubKey.equals(key);
        }
        return false;
    }

    static {
        PARAM_NAME_TO_FRIENDLY_NAME.put("schedId", "system schedule id");
        PARAM_NAME_TO_FRIENDLY_NAME.put("title", "title");
        PARAM_NAME_TO_FRIENDLY_NAME.put("schedRef", "name");
        PARAM_NAME_TO_FRIENDLY_NAME.put("desc", "description");
        PARAM_NAME_TO_FRIENDLY_NAME.put("cron", "cron string");
        PARAM_NAME_TO_FRIENDLY_NAME.put("group", "group name");
        PARAM_NAME_TO_FRIENDLY_NAME.put("actionRefs", "action sequence path(s)");
        PARAM_NAME_TO_FRIENDLY_NAME.put("contentId", "system content id");
        PARAM_NAME_TO_FRIENDLY_NAME.put("jobId", "name");
        PARAM_NAME_TO_FRIENDLY_NAME.put("subscriptionId", "system subscription id");
        logger = LogFactory.getLog(SubscriptionAdminUIComponent.class);
    }

    private static class CronStringException
    extends PentahoCheckedChainedException {
        private static final long serialVersionUID = 666L;

        public CronStringException() {
        }

        public CronStringException(String message, Throwable reas) {
            super(message, reas);
        }

        public CronStringException(String message) {
            super(message);
        }

        public CronStringException(Throwable reas) {
            super(reas);
        }
    }

    private static class ParameterValidationException
    extends PentahoCheckedChainedException {
        private static final long serialVersionUID = 666L;

        public ParameterValidationException() {
        }

        public ParameterValidationException(String message, Throwable reas) {
            super(message, reas);
        }

        public ParameterValidationException(String message) {
            super(message);
        }

        public ParameterValidationException(Throwable reas) {
            super(reas);
        }
    }
}

