/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.refactor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IBackgroundExecution;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.repository.ISubscription;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.api.scheduler.BackgroundExecutionException;
import org.pentaho.platform.api.scheduler.IJobDetail;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.scheduler.SchedulerHelper;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.web.http.messages.Messages;
import org.pentaho.platform.web.refactor.SubscriptionAdminUIComponent;

public class UserFilesComponent
extends XmlComponent {
    private static final long serialVersionUID = -7404173000559758744L;
    protected static final String FILE = "file";
    protected static final String NAME = "name";
    protected static final String TIMESTAMP = "timestamp";
    protected static final String ACTIONS = "actions";
    protected static final String ACTION = "action";
    protected static final String TITLE = "title";
    protected static final String PARAMS = "params";
    protected static final String PARAM = "param";
    protected static final String PARAM_NAME = "param-name";
    protected static final String PARAM_VALUE = "param-value";
    protected static final String USER_FILES = "user-files";
    protected static final String MIMETYPE = "mimetype";
    protected static final String SIZE = "size";
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private static final Log logger = LogFactory.getLog(UserFilesComponent.class);

    public Log getLogger() {
        return logger;
    }

    public UserFilesComponent() {
        super(null, null, null);
        this.setXsl("text/html", "UserFiles.xsl");
    }

    public UserFilesComponent(IPentahoUrlFactory urlFactory, HttpServletRequest request, HttpServletResponse response, List messages) {
        super(urlFactory, messages, null);
        this.request = request;
        this.response = response;
        this.setXsl("text/html", "UserFiles.xsl");
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public boolean validate() {
        return true;
    }

    public Document getXmlContent() {
        Document result = DocumentHelper.createDocument();
        Element root = result.addElement(USER_FILES);
        this.addFiles(root);
        return result;
    }

    protected void addFiles(Element root) {
        this.addScheduledAndExecuting(root);
        this.addExecutedlist(root);
        this.addSubscriptions(root);
    }

    protected void addScheduledAndExecuting(Element root) {
        Element jobs = root.addElement("scheduled");
        IPentahoSession session = this.getSession();
        IBackgroundExecution backgroundExecution = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)session);
        List jobsList = null;
        if (backgroundExecution != null) {
            try {
                jobsList = backgroundExecution.getScheduledAndExecutingBackgroundJobs(session);
            }
            catch (BackgroundExecutionException bex) {
                jobsList = new ArrayList();
                Element errorRoot = root.addElement("error");
                errorRoot.addElement("error-message").setText(Messages.getErrorString("UI.USER_ERROR_0003_NO_BACKGROUND_EXECUTION"));
            }
        } else {
            jobsList = new ArrayList();
            Element errorRoot = root.addElement("error");
            errorRoot.addElement("error-message").setText(Messages.getErrorString("UI.USER_ERROR_0003_NO_BACKGROUND_EXECUTION"));
        }
        if (jobsList != null && jobsList.size() > 0) {
            for (IJobDetail jobDetail : jobsList) {
                Element job = jobs.addElement(FILE);
                job.addElement(NAME).setText(jobDetail.getActionName() != null ? jobDetail.getActionName() : jobDetail.getName());
                job.addElement(TIMESTAMP).setText(jobDetail.getSubmissionDate() != null ? jobDetail.getSubmissionDate() : new Date().toString());
                Element actions = job.addElement(ACTIONS);
                Element action = actions.addElement(ACTION);
                action.addElement(TITLE).setText(Messages.getString("UI.USER_CANCEL"));
                Element params = action.addElement(PARAMS);
                Element param = params.addElement(PARAM);
                param.addElement(PARAM_NAME).setText("del-job-name");
                param.addElement(PARAM_VALUE).setText(jobDetail.getName());
                param = params.addElement(PARAM);
                param.addElement(PARAM_NAME).setText("del-job-group");
                param.addElement(PARAM_VALUE).setText(jobDetail.getGroupName());
                param = params.addElement(PARAM);
                param.addElement(PARAM_NAME).setText(ACTION);
                param.addElement(PARAM_VALUE).setText("cancel-job");
            }
        }
    }

    protected void addExecutedlist(Element root) {
        Element jobs = root.addElement("executed");
        IPentahoSession session = this.getSession();
        IBackgroundExecution backgroundExecution = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)session);
        ArrayList pastExecutionList = null;
        pastExecutionList = backgroundExecution != null ? backgroundExecution.getBackgroundExecutedContentList(session) : new ArrayList();
        SimpleDateFormat fmt = new SimpleDateFormat();
        for (int i = 0; i < pastExecutionList.size(); ++i) {
            IContentItem item = (IContentItem)pastExecutionList.get(i);
            Element job = jobs.addElement(FILE);
            job.addElement(NAME).setText(item.getTitle());
            String dateStr = "";
            Date time = item.getFileDateTime();
            if (time != null) {
                dateStr = fmt.format(time);
            }
            job.addElement(TIMESTAMP).setText(dateStr);
            job.addElement(MIMETYPE).setText(item.getMimeType());
            job.addElement(SIZE).setText(Long.toString(item.getFileSize()));
            Element actions = job.addElement(ACTIONS);
            Element action = actions.addElement(ACTION);
            action.addElement(TITLE).setText(Messages.getString("UI.USER_VIEW"));
            Element params = action.addElement(PARAMS);
            Element param = params.addElement(PARAM);
            param.addElement(PARAM_NAME).setText(ACTION);
            param.addElement(PARAM_VALUE).setText("view");
            param = params.addElement(PARAM);
            param.addElement(PARAM_NAME).setText("id");
            param.addElement(PARAM_VALUE).setText(item.getId());
            action = actions.addElement(ACTION);
            action.addElement(TITLE).setText(Messages.getString("UI.USER_DELETE"));
            params = action.addElement(PARAMS);
            param = params.addElement(PARAM);
            param.addElement(PARAM_NAME).setText(ACTION);
            param.addElement(PARAM_VALUE).setText("delete");
            param = params.addElement(PARAM);
            param.addElement(PARAM_NAME).setText("content-id");
            param.addElement(PARAM_VALUE).setText(item.getId());
        }
    }

    public boolean cancelJob(String jobName, String jobGroup) {
        try {
            SchedulerHelper.deleteJob((IPentahoSession)this.getSession(), (String)jobName, (String)jobGroup);
            return true;
        }
        catch (Throwable t) {
            this.error(Messages.getErrorString("Scheduler.ERROR_0001_SCHEDULER_CANNOT_CANCEL", t.getMessage()), t);
            return false;
        }
    }

    public boolean deleteContent(String contentId) {
        try {
            IPentahoSession session = this.getSession();
            IBackgroundExecution backgroundExecution = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)session);
            if (backgroundExecution != null) {
                backgroundExecution.removeBackgroundExecutedContentForID(contentId, session);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            this.error(Messages.getErrorString("Scheduler.ERROR_0001_SCHEDULER_CANNOT_CANCEL", t.getMessage()), t);
            return false;
        }
    }

    protected void addSubscriptions(Element root) {
        SubscriptionAdminUIComponent admin = null;
        try {
            admin = new SubscriptionAdminUIComponent(this.urlFactory, this.getMessages());
            admin.validate(this.getSession(), null);
            SimpleParameterProvider params = new SimpleParameterProvider();
            admin.setParameterProvider("request", (IParameterProvider)params);
            params.setParameter("schedulerAction", "listSubscriptions");
            params.setParameter("user", this.getSession().getName());
            Document doc = admin.getXmlContent();
            List subscriptionList = doc.selectNodes("listSubscriptions/subscriptions/subscription");
            if (subscriptionList != null) {
                ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getSession());
                for (Element node : subscriptionList) {
                    String actionRef = node.selectSingleNode("actionRef").getText();
                    ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
                    ActionInfo actionInfo = ActionInfo.parseActionString((String)actionRef);
                    IActionSequence action = repo.getActionSequence(actionInfo.getSolutionName(), actionInfo.getPath(), actionInfo.getActionName(), repo.getLoggingLevel(), 1);
                    String actionTitle = action.getTitle();
                    node.addElement("action-title").setText(actionTitle);
                    if (subscriptionRepository == null) continue;
                    try {
                        ISubscription subscription = subscriptionRepository.getSubscription(node.selectSingleNode("@subscriptionId").getText(), this.getSession());
                        subscriptionRepository.addSubscriptionToDocument(subscription, node, null, this.getSession());
                    }
                    catch (Throwable t) {
                        this.error(Messages.getErrorString("PRO_SUBSCRIPTREP.ERROR_0005_GENERAL_ERROR"), t);
                    }
                }
            }
            Element subsRoot = doc.getRootElement();
            subsRoot.detach();
            root.add(subsRoot);
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("PRO_SUBSCRIPTREP.ERROR_0005_GENERAL_ERROR"), e);
        }
    }
}

